/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.api.serialization.RecordDeserializer;
import org.apache.flink.runtime.io.network.api.serialization.SpillingAdaptiveSpanningRecordDeserializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.jobgraph.tasks.StatefulTask;
import org.apache.flink.runtime.metrics.groups.TaskIOMetricGroup;
import org.apache.flink.runtime.plugable.DeserializationDelegate;
import org.apache.flink.runtime.plugable.NonReusingDeserializationDelegate;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.io.BarrierBuffer;
import org.apache.flink.streaming.runtime.io.BarrierTracker;
import org.apache.flink.streaming.runtime.io.CheckpointBarrierHandler;
import org.apache.flink.streaming.runtime.io.InputGateUtil;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.streamrecord.StreamElementSerializer;

@Internal
public class StreamTwoInputProcessor<IN1, IN2> {
    private final RecordDeserializer<DeserializationDelegate<StreamElement>>[] recordDeserializers;
    private RecordDeserializer<DeserializationDelegate<StreamElement>> currentRecordDeserializer;
    private int currentChannel = -1;
    private boolean isFinished;
    private final CheckpointBarrierHandler barrierHandler;
    private final long[] watermarks1;
    private long lastEmittedWatermark1;
    private final long[] watermarks2;
    private long lastEmittedWatermark2;
    private final int numInputChannels1;
    private final DeserializationDelegate<StreamElement> deserializationDelegate1;
    private final DeserializationDelegate<StreamElement> deserializationDelegate2;

    public StreamTwoInputProcessor(Collection<InputGate> inputGates1, Collection<InputGate> inputGates2, TypeSerializer<IN1> inputSerializer1, TypeSerializer<IN2> inputSerializer2, StatefulTask checkpointedTask, CheckpointingMode checkpointMode, IOManager ioManager, Configuration taskManagerConfig) throws IOException {
        InputGate inputGate = InputGateUtil.createInputGate(inputGates1, inputGates2);
        if (checkpointMode == CheckpointingMode.EXACTLY_ONCE) {
            long maxAlign = taskManagerConfig.getLong(TaskManagerOptions.TASK_CHECKPOINT_ALIGNMENT_BYTES_LIMIT);
            if (maxAlign != -1L && maxAlign <= 0L) {
                throw new IllegalConfigurationException(TaskManagerOptions.TASK_CHECKPOINT_ALIGNMENT_BYTES_LIMIT.key() + " must be positive or -1 (infinite)");
            }
            this.barrierHandler = new BarrierBuffer(inputGate, ioManager, maxAlign);
        } else if (checkpointMode == CheckpointingMode.AT_LEAST_ONCE) {
            this.barrierHandler = new BarrierTracker(inputGate);
        } else {
            throw new IllegalArgumentException("Unrecognized CheckpointingMode: " + (Object)((Object)checkpointMode));
        }
        if (checkpointedTask != null) {
            this.barrierHandler.registerCheckpointEventHandler(checkpointedTask);
        }
        StreamElementSerializer<IN1> ser1 = new StreamElementSerializer<IN1>(inputSerializer1);
        this.deserializationDelegate1 = new NonReusingDeserializationDelegate(ser1);
        StreamElementSerializer<IN2> ser2 = new StreamElementSerializer<IN2>(inputSerializer2);
        this.deserializationDelegate2 = new NonReusingDeserializationDelegate(ser2);
        this.recordDeserializers = new SpillingAdaptiveSpanningRecordDeserializer[inputGate.getNumberOfInputChannels()];
        for (int i = 0; i < this.recordDeserializers.length; ++i) {
            this.recordDeserializers[i] = new SpillingAdaptiveSpanningRecordDeserializer(ioManager.getSpillingDirectoriesPaths());
        }
        int numInputChannels1 = 0;
        for (InputGate gate : inputGates1) {
            numInputChannels1 += gate.getNumberOfInputChannels();
        }
        this.numInputChannels1 = numInputChannels1;
        int numInputChannels2 = inputGate.getNumberOfInputChannels() - numInputChannels1;
        this.watermarks1 = new long[numInputChannels1];
        Arrays.fill(this.watermarks1, Long.MIN_VALUE);
        this.lastEmittedWatermark1 = Long.MIN_VALUE;
        this.watermarks2 = new long[numInputChannels2];
        Arrays.fill(this.watermarks2, Long.MIN_VALUE);
        this.lastEmittedWatermark2 = Long.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processInput(TwoInputStreamOperator<IN1, IN2, ?> streamOperator, Object lock) throws Exception {
        block24: {
            AbstractEvent event;
            if (this.isFinished) {
                return false;
            }
            while (true) {
                BufferOrEvent bufferOrEvent;
                if (this.currentRecordDeserializer != null) {
                    RecordDeserializer.DeserializationResult result = this.currentChannel < this.numInputChannels1 ? this.currentRecordDeserializer.getNextRecord(this.deserializationDelegate1) : this.currentRecordDeserializer.getNextRecord(this.deserializationDelegate2);
                    if (result.isBufferConsumed()) {
                        this.currentRecordDeserializer.getCurrentBuffer().recycle();
                        this.currentRecordDeserializer = null;
                    }
                    if (result.isFullRecord()) {
                        Object object;
                        StreamElement recordOrWatermark;
                        if (this.currentChannel < this.numInputChannels1) {
                            recordOrWatermark = (StreamElement)this.deserializationDelegate1.getInstance();
                            if (recordOrWatermark.isWatermark()) {
                                this.handleWatermark(streamOperator, recordOrWatermark.asWatermark(), this.currentChannel, lock);
                                continue;
                            }
                            if (recordOrWatermark.isLatencyMarker()) {
                                object = lock;
                                synchronized (object) {
                                    streamOperator.processLatencyMarker1(recordOrWatermark.asLatencyMarker());
                                }
                            }
                            object = lock;
                            synchronized (object) {
                                streamOperator.setKeyContextElement1(recordOrWatermark.asRecord());
                                streamOperator.processElement1(recordOrWatermark.asRecord());
                            }
                            return true;
                        }
                        recordOrWatermark = (StreamElement)this.deserializationDelegate2.getInstance();
                        if (recordOrWatermark.isWatermark()) {
                            this.handleWatermark(streamOperator, recordOrWatermark.asWatermark(), this.currentChannel, lock);
                            continue;
                        }
                        if (recordOrWatermark.isLatencyMarker()) {
                            object = lock;
                            synchronized (object) {
                                streamOperator.processLatencyMarker2(recordOrWatermark.asLatencyMarker());
                            }
                        }
                        object = lock;
                        synchronized (object) {
                            streamOperator.setKeyContextElement2(recordOrWatermark.asRecord());
                            streamOperator.processElement2(recordOrWatermark.asRecord());
                        }
                        return true;
                    }
                }
                if ((bufferOrEvent = this.barrierHandler.getNextNonBlocked()) == null) break block24;
                if (bufferOrEvent.isBuffer()) {
                    this.currentChannel = bufferOrEvent.getChannelIndex();
                    this.currentRecordDeserializer = this.recordDeserializers[this.currentChannel];
                    this.currentRecordDeserializer.setNextBuffer(bufferOrEvent.getBuffer());
                    continue;
                }
                event = bufferOrEvent.getEvent();
                if (event.getClass() != EndOfPartitionEvent.class) break;
            }
            throw new IOException("Unexpected event: " + event);
        }
        this.isFinished = true;
        if (!this.barrierHandler.isEmpty()) {
            throw new IllegalStateException("Trailing data in checkpoint barrier handler.");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleWatermark(TwoInputStreamOperator<IN1, IN2, ?> operator, Watermark mark, int channelIndex, Object lock) throws Exception {
        if (channelIndex < this.numInputChannels1) {
            long watermarkMillis = mark.getTimestamp();
            if (watermarkMillis > this.watermarks1[channelIndex]) {
                this.watermarks1[channelIndex] = watermarkMillis;
                long newMinWatermark = Long.MAX_VALUE;
                for (long wm : this.watermarks1) {
                    newMinWatermark = Math.min(wm, newMinWatermark);
                }
                if (newMinWatermark > this.lastEmittedWatermark1) {
                    this.lastEmittedWatermark1 = newMinWatermark;
                    Object object = lock;
                    synchronized (object) {
                        operator.processWatermark1(new Watermark(this.lastEmittedWatermark1));
                    }
                }
            }
        } else {
            long watermarkMillis = mark.getTimestamp();
            if (watermarkMillis > this.watermarks2[channelIndex -= this.numInputChannels1]) {
                this.watermarks2[channelIndex] = watermarkMillis;
                long newMinWatermark = Long.MAX_VALUE;
                for (long wm : this.watermarks2) {
                    newMinWatermark = Math.min(wm, newMinWatermark);
                }
                if (newMinWatermark > this.lastEmittedWatermark2) {
                    this.lastEmittedWatermark2 = newMinWatermark;
                    Object object = lock;
                    synchronized (object) {
                        operator.processWatermark2(new Watermark(this.lastEmittedWatermark2));
                    }
                }
            }
        }
    }

    public void setMetricGroup(TaskIOMetricGroup metrics) {
        metrics.gauge("currentLowWatermark", (Gauge)new Gauge<Long>(){

            public Long getValue() {
                return Math.min(StreamTwoInputProcessor.this.lastEmittedWatermark1, StreamTwoInputProcessor.this.lastEmittedWatermark2);
            }
        });
        metrics.gauge("checkpointAlignmentTime", (Gauge)new Gauge<Long>(){

            public Long getValue() {
                return StreamTwoInputProcessor.this.barrierHandler.getAlignmentDurationNanos();
            }
        });
    }

    public void cleanup() throws IOException {
        for (RecordDeserializer<DeserializationDelegate<StreamElement>> deserializer : this.recordDeserializers) {
            Buffer buffer = deserializer.getCurrentBuffer();
            if (buffer == null || buffer.isRecycled()) continue;
            buffer.recycle();
        }
        this.barrierHandler.cleanup();
    }
}

