/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.io.StreamRecordWriter;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.streamrecord.StreamElementSerializer;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.Preconditions;

@Internal
public class RecordWriterOutput<OUT>
implements Output<StreamRecord<OUT>> {
    private StreamRecordWriter<SerializationDelegate<StreamElement>> recordWriter;
    private SerializationDelegate<StreamElement> serializationDelegate;

    public RecordWriterOutput(StreamRecordWriter<SerializationDelegate<StreamRecord<OUT>>> recordWriter, TypeSerializer<OUT> outSerializer) {
        Preconditions.checkNotNull(recordWriter);
        this.recordWriter = recordWriter;
        StreamElementSerializer<OUT> outRecordSerializer = new StreamElementSerializer<OUT>(outSerializer);
        if (outSerializer != null) {
            this.serializationDelegate = new SerializationDelegate(outRecordSerializer);
        }
    }

    public void collect(StreamRecord<OUT> record) {
        this.serializationDelegate.setInstance(record);
        try {
            this.recordWriter.emit(this.serializationDelegate);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void emitWatermark(Watermark mark) {
        this.serializationDelegate.setInstance((Object)mark);
        try {
            this.recordWriter.broadcastEmit(this.serializationDelegate);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void emitLatencyMarker(LatencyMarker latencyMarker) {
        this.serializationDelegate.setInstance((Object)latencyMarker);
        try {
            this.recordWriter.randomEmit(this.serializationDelegate);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void broadcastEvent(AbstractEvent event) throws IOException, InterruptedException {
        this.recordWriter.broadcastEvent(event);
    }

    public void flush() throws IOException {
        this.recordWriter.flush();
    }

    public void close() {
        this.recordWriter.close();
    }

    public void clearBuffers() {
        this.recordWriter.clearBuffers();
    }
}

