/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.triggers;

import java.io.Serializable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.state.MergingState;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.streaming.api.windowing.triggers.TriggerResult;
import org.apache.flink.streaming.api.windowing.windows.Window;

@PublicEvolving
public abstract class Trigger<T, W extends Window>
implements Serializable {
    private static final long serialVersionUID = -4104633972991191369L;

    public abstract TriggerResult onElement(T var1, long var2, W var4, TriggerContext var5) throws Exception;

    public abstract TriggerResult onProcessingTime(long var1, W var3, TriggerContext var4) throws Exception;

    public abstract TriggerResult onEventTime(long var1, W var3, TriggerContext var4) throws Exception;

    public boolean canMerge() {
        return false;
    }

    public void onMerge(W window, OnMergeContext ctx) throws Exception {
        throw new RuntimeException("This trigger does not support merging.");
    }

    public abstract void clear(W var1, TriggerContext var2) throws Exception;

    public static interface OnMergeContext
    extends TriggerContext {
        public <S extends MergingState<?, ?>> void mergePartitionedState(StateDescriptor<S, ?> var1);
    }

    public static interface TriggerContext {
        public long getCurrentProcessingTime();

        public MetricGroup getMetricGroup();

        public long getCurrentWatermark();

        public void registerProcessingTimeTimer(long var1);

        public void registerEventTimeTimer(long var1);

        public void deleteProcessingTimeTimer(long var1);

        public void deleteEventTimeTimer(long var1);

        public <S extends State> S getPartitionedState(StateDescriptor<S, ?> var1);

        @Deprecated
        public <S extends Serializable> ValueState<S> getKeyValueState(String var1, Class<S> var2, S var3);

        @Deprecated
        public <S extends Serializable> ValueState<S> getKeyValueState(String var1, TypeInformation<S> var2, S var3);
    }
}

