/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.async.queue;

import java.util.concurrent.Executor;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.concurrent.AcceptFunction;
import org.apache.flink.runtime.concurrent.Future;
import org.apache.flink.streaming.api.operators.async.queue.AsyncCollectionResult;
import org.apache.flink.streaming.api.operators.async.queue.AsyncResult;
import org.apache.flink.streaming.api.operators.async.queue.AsyncWatermarkResult;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class StreamElementQueueEntry<T>
implements AsyncResult {
    private final StreamElement streamElement;

    public StreamElementQueueEntry(StreamElement streamElement) {
        this.streamElement = (StreamElement)Preconditions.checkNotNull((Object)streamElement);
    }

    public StreamElement getStreamElement() {
        return this.streamElement;
    }

    public boolean isDone() {
        return this.getFuture().isDone();
    }

    public void onComplete(final AcceptFunction<StreamElementQueueEntry<T>> completeFunction, Executor executor) {
        final StreamElementQueueEntry thisReference = this;
        this.getFuture().thenAcceptAsync(new AcceptFunction<T>(){

            public void accept(T value) {
                completeFunction.accept((Object)thisReference);
            }
        }, executor);
    }

    protected abstract Future<T> getFuture();

    @Override
    public final boolean isWatermark() {
        return AsyncWatermarkResult.class.isAssignableFrom(this.getClass());
    }

    @Override
    public final boolean isResultCollection() {
        return AsyncCollectionResult.class.isAssignableFrom(this.getClass());
    }

    @Override
    public final AsyncWatermarkResult asWatermark() {
        return (AsyncWatermarkResult)((Object)this);
    }

    @Override
    public final <T> AsyncCollectionResult<T> asResultCollection() {
        return (AsyncCollectionResult)((Object)this);
    }
}

