/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.streaming.api.SimpleTimerService;
import org.apache.flink.streaming.api.TimeDomain;
import org.apache.flink.streaming.api.TimerService;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.streaming.api.operators.Triggerable;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.Preconditions;

@Internal
public class ProcessOperator<K, IN, OUT>
extends AbstractUdfStreamOperator<OUT, ProcessFunction<IN, OUT>>
implements OneInputStreamOperator<IN, OUT>,
Triggerable<K, VoidNamespace> {
    private static final long serialVersionUID = 1L;
    private transient TimestampedCollector<OUT> collector;
    private transient TimerService timerService;
    private transient ContextImpl<IN> context;
    private transient OnTimerContextImpl onTimerContext;

    public ProcessOperator(ProcessFunction<IN, OUT> flatMapper) {
        super(flatMapper);
        this.chainingStrategy = ChainingStrategy.ALWAYS;
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.collector = new TimestampedCollector(this.output);
        InternalTimerService<VoidNamespace> internalTimerService = this.getInternalTimerService("user-timers", VoidNamespaceSerializer.INSTANCE, this);
        this.timerService = new SimpleTimerService(internalTimerService);
        this.context = new ContextImpl(this.timerService);
        this.onTimerContext = new OnTimerContextImpl(this.timerService);
    }

    @Override
    public void onEventTime(InternalTimer<K, VoidNamespace> timer) throws Exception {
        this.collector.setAbsoluteTimestamp(timer.getTimestamp());
        this.onTimerContext.timeDomain = TimeDomain.EVENT_TIME;
        this.onTimerContext.timer = timer;
        ((ProcessFunction)this.userFunction).onTimer(timer.getTimestamp(), this.onTimerContext, this.collector);
        this.onTimerContext.timeDomain = null;
        this.onTimerContext.timer = null;
    }

    @Override
    public void onProcessingTime(InternalTimer<K, VoidNamespace> timer) throws Exception {
        this.collector.setAbsoluteTimestamp(timer.getTimestamp());
        this.onTimerContext.timeDomain = TimeDomain.PROCESSING_TIME;
        this.onTimerContext.timer = timer;
        ((ProcessFunction)this.userFunction).onTimer(timer.getTimestamp(), this.onTimerContext, this.collector);
        this.onTimerContext.timeDomain = null;
        this.onTimerContext.timer = null;
    }

    @Override
    public void processElement(StreamRecord<IN> element) throws Exception {
        this.collector.setTimestamp(element);
        ((ContextImpl)this.context).element = element;
        ((ProcessFunction)this.userFunction).processElement(element.getValue(), this.context, this.collector);
        ((ContextImpl)this.context).element = null;
    }

    private static class OnTimerContextImpl
    implements ProcessFunction.OnTimerContext {
        private final TimerService timerService;
        private TimeDomain timeDomain;
        private InternalTimer<?, VoidNamespace> timer;

        OnTimerContextImpl(TimerService timerService) {
            this.timerService = (TimerService)Preconditions.checkNotNull((Object)timerService);
        }

        @Override
        public TimeDomain timeDomain() {
            Preconditions.checkState((this.timeDomain != null ? 1 : 0) != 0);
            return this.timeDomain;
        }

        @Override
        public Long timestamp() {
            Preconditions.checkState((this.timer != null ? 1 : 0) != 0);
            return this.timer.getTimestamp();
        }

        @Override
        public TimerService timerService() {
            return this.timerService;
        }
    }

    private static class ContextImpl<T>
    implements ProcessFunction.Context {
        private final TimerService timerService;
        private StreamRecord<T> element;

        ContextImpl(TimerService timerService) {
            this.timerService = (TimerService)Preconditions.checkNotNull((Object)timerService);
        }

        @Override
        public Long timestamp() {
            Preconditions.checkState((this.element != null ? 1 : 0) != 0);
            if (this.element.hasTimestamp()) {
                return this.element.getTimestamp();
            }
            return null;
        }

        @Override
        public TimerService timerService() {
            return this.timerService;
        }
    }
}

