/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.concurrent.RunnableFuture;
import org.apache.flink.runtime.state.KeyGroupsStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.StateUtil;
import org.apache.flink.util.ExceptionUtils;

public class OperatorSnapshotResult {
    private RunnableFuture<KeyGroupsStateHandle> keyedStateManagedFuture;
    private RunnableFuture<KeyGroupsStateHandle> keyedStateRawFuture;
    private RunnableFuture<OperatorStateHandle> operatorStateManagedFuture;
    private RunnableFuture<OperatorStateHandle> operatorStateRawFuture;

    public OperatorSnapshotResult() {
        this(null, null, null, null);
    }

    public OperatorSnapshotResult(RunnableFuture<KeyGroupsStateHandle> keyedStateManagedFuture, RunnableFuture<KeyGroupsStateHandle> keyedStateRawFuture, RunnableFuture<OperatorStateHandle> operatorStateManagedFuture, RunnableFuture<OperatorStateHandle> operatorStateRawFuture) {
        this.keyedStateManagedFuture = keyedStateManagedFuture;
        this.keyedStateRawFuture = keyedStateRawFuture;
        this.operatorStateManagedFuture = operatorStateManagedFuture;
        this.operatorStateRawFuture = operatorStateRawFuture;
    }

    public RunnableFuture<KeyGroupsStateHandle> getKeyedStateManagedFuture() {
        return this.keyedStateManagedFuture;
    }

    public void setKeyedStateManagedFuture(RunnableFuture<KeyGroupsStateHandle> keyedStateManagedFuture) {
        this.keyedStateManagedFuture = keyedStateManagedFuture;
    }

    public RunnableFuture<KeyGroupsStateHandle> getKeyedStateRawFuture() {
        return this.keyedStateRawFuture;
    }

    public void setKeyedStateRawFuture(RunnableFuture<KeyGroupsStateHandle> keyedStateRawFuture) {
        this.keyedStateRawFuture = keyedStateRawFuture;
    }

    public RunnableFuture<OperatorStateHandle> getOperatorStateManagedFuture() {
        return this.operatorStateManagedFuture;
    }

    public void setOperatorStateManagedFuture(RunnableFuture<OperatorStateHandle> operatorStateManagedFuture) {
        this.operatorStateManagedFuture = operatorStateManagedFuture;
    }

    public RunnableFuture<OperatorStateHandle> getOperatorStateRawFuture() {
        return this.operatorStateRawFuture;
    }

    public void setOperatorStateRawFuture(RunnableFuture<OperatorStateHandle> operatorStateRawFuture) {
        this.operatorStateRawFuture = operatorStateRawFuture;
    }

    public void cancel() throws Exception {
        Exception exception = null;
        try {
            StateUtil.discardStateFuture(this.getKeyedStateManagedFuture());
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)new Exception("Could not properly cancel managed keyed state future.", e), exception);
        }
        try {
            StateUtil.discardStateFuture(this.getOperatorStateManagedFuture());
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)new Exception("Could not properly cancel managed operator state future.", e), (Throwable)exception);
        }
        try {
            StateUtil.discardStateFuture(this.getKeyedStateRawFuture());
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)new Exception("Could not properly cancel raw keyed state future.", e), (Throwable)exception);
        }
        try {
            StateUtil.discardStateFuture(this.getOperatorStateRawFuture());
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)new Exception("Could not properly cancel raw operator state future.", e), (Throwable)exception);
        }
        if (exception != null) {
            throw exception;
        }
    }
}

