/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

@Internal
public class InternalTimer<K, N>
implements Comparable<InternalTimer<K, N>> {
    private final long timestamp;
    private final K key;
    private final N namespace;

    public InternalTimer(long timestamp, K key, N namespace) {
        this.timestamp = timestamp;
        this.key = key;
        this.namespace = namespace;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public K getKey() {
        return this.key;
    }

    public N getNamespace() {
        return this.namespace;
    }

    @Override
    public int compareTo(InternalTimer<K, N> o) {
        return Long.compare(this.timestamp, o.timestamp);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalTimer timer = (InternalTimer)o;
        return this.timestamp == timer.timestamp && this.key.equals(timer.key) && this.namespace.equals(timer.namespace);
    }

    public int hashCode() {
        int result = (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + this.key.hashCode();
        result = 31 * result + this.namespace.hashCode();
        return result;
    }

    public String toString() {
        return "Timer{timestamp=" + this.timestamp + ", key=" + this.key + ", namespace=" + this.namespace + '}';
    }

    public static class TimerSerializer<K, N>
    extends TypeSerializer<InternalTimer<K, N>> {
        private static final long serialVersionUID = 1119562170939152304L;
        private final TypeSerializer<K> keySerializer;
        private final TypeSerializer<N> namespaceSerializer;

        TimerSerializer(TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer) {
            this.keySerializer = keySerializer;
            this.namespaceSerializer = namespaceSerializer;
        }

        public boolean isImmutableType() {
            return false;
        }

        public TypeSerializer<InternalTimer<K, N>> duplicate() {
            return this;
        }

        public InternalTimer<K, N> createInstance() {
            return null;
        }

        public InternalTimer<K, N> copy(InternalTimer<K, N> from) {
            return new InternalTimer<Object, Object>(((InternalTimer)from).timestamp, ((InternalTimer)from).key, ((InternalTimer)from).namespace);
        }

        public InternalTimer<K, N> copy(InternalTimer<K, N> from, InternalTimer<K, N> reuse) {
            return this.copy(from);
        }

        public int getLength() {
            return -1;
        }

        public void serialize(InternalTimer<K, N> record, DataOutputView target) throws IOException {
            this.keySerializer.serialize(((InternalTimer)record).key, target);
            this.namespaceSerializer.serialize(((InternalTimer)record).namespace, target);
            LongSerializer.INSTANCE.serialize(Long.valueOf(((InternalTimer)record).timestamp), target);
        }

        public InternalTimer<K, N> deserialize(DataInputView source) throws IOException {
            Object key = this.keySerializer.deserialize(source);
            Object namespace = this.namespaceSerializer.deserialize(source);
            Long timestamp = LongSerializer.INSTANCE.deserialize(source);
            return new InternalTimer<Object, Object>(timestamp, key, namespace);
        }

        public InternalTimer<K, N> deserialize(InternalTimer<K, N> reuse, DataInputView source) throws IOException {
            return this.deserialize(source);
        }

        public void copy(DataInputView source, DataOutputView target) throws IOException {
            this.keySerializer.copy(source, target);
            this.namespaceSerializer.copy(source, target);
            LongSerializer.INSTANCE.copy(source, target);
        }

        public boolean equals(Object obj) {
            return obj == this || obj != null && obj.getClass() == ((Object)((Object)this)).getClass() && this.keySerializer.equals(((TimerSerializer)((Object)obj)).keySerializer) && this.namespaceSerializer.equals(((TimerSerializer)((Object)obj)).namespaceSerializer);
        }

        public boolean canEqual(Object obj) {
            return true;
        }

        public int hashCode() {
            return ((Object)((Object)this)).getClass().hashCode();
        }
    }
}

