/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.streaming.api.collector.selector.OutputSelector;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.operators.StreamOperator;

@Internal
public class StreamNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient StreamExecutionEnvironment env;
    private final int id;
    private Integer parallelism = null;
    private int maxParallelism;
    private Long bufferTimeout = null;
    private final String operatorName;
    private String slotSharingGroup;
    private KeySelector<?, ?> statePartitioner1;
    private KeySelector<?, ?> statePartitioner2;
    private TypeSerializer<?> stateKeySerializer;
    private transient StreamOperator<?> operator;
    private List<OutputSelector<?>> outputSelectors;
    private TypeSerializer<?> typeSerializerIn1;
    private TypeSerializer<?> typeSerializerIn2;
    private TypeSerializer<?> typeSerializerOut;
    private List<StreamEdge> inEdges = new ArrayList<StreamEdge>();
    private List<StreamEdge> outEdges = new ArrayList<StreamEdge>();
    private final Class<? extends AbstractInvokable> jobVertexClass;
    private InputFormat<?, ?> inputFormat;
    private String transformationUID;
    private String userHash;

    public StreamNode(StreamExecutionEnvironment env, Integer id, String slotSharingGroup, StreamOperator<?> operator, String operatorName, List<OutputSelector<?>> outputSelector, Class<? extends AbstractInvokable> jobVertexClass) {
        this.env = env;
        this.id = id;
        this.operatorName = operatorName;
        this.operator = operator;
        this.outputSelectors = outputSelector;
        this.jobVertexClass = jobVertexClass;
        this.slotSharingGroup = slotSharingGroup;
    }

    public void addInEdge(StreamEdge inEdge) {
        if (inEdge.getTargetId() != this.getId()) {
            throw new IllegalArgumentException("Destination id doesn't match the StreamNode id");
        }
        this.inEdges.add(inEdge);
    }

    public void addOutEdge(StreamEdge outEdge) {
        if (outEdge.getSourceId() != this.getId()) {
            throw new IllegalArgumentException("Source id doesn't match the StreamNode id");
        }
        this.outEdges.add(outEdge);
    }

    public List<StreamEdge> getOutEdges() {
        return this.outEdges;
    }

    public List<StreamEdge> getInEdges() {
        return this.inEdges;
    }

    public List<Integer> getOutEdgeIndices() {
        ArrayList<Integer> outEdgeIndices = new ArrayList<Integer>();
        for (StreamEdge edge : this.outEdges) {
            outEdgeIndices.add(edge.getTargetId());
        }
        return outEdgeIndices;
    }

    public List<Integer> getInEdgeIndices() {
        ArrayList<Integer> inEdgeIndices = new ArrayList<Integer>();
        for (StreamEdge edge : this.inEdges) {
            inEdgeIndices.add(edge.getSourceId());
        }
        return inEdgeIndices;
    }

    public int getId() {
        return this.id;
    }

    public int getParallelism() {
        if (this.parallelism == -1) {
            return this.env.getParallelism();
        }
        return this.parallelism;
    }

    public void setParallelism(Integer parallelism) {
        this.parallelism = parallelism;
    }

    int getMaxParallelism() {
        return this.maxParallelism;
    }

    void setMaxParallelism(int maxParallelism) {
        this.maxParallelism = maxParallelism;
    }

    public Long getBufferTimeout() {
        return this.bufferTimeout != null ? this.bufferTimeout.longValue() : this.env.getBufferTimeout();
    }

    public void setBufferTimeout(Long bufferTimeout) {
        this.bufferTimeout = bufferTimeout;
    }

    public StreamOperator<?> getOperator() {
        return this.operator;
    }

    public void setOperator(StreamOperator<?> operator) {
        this.operator = operator;
    }

    public String getOperatorName() {
        return this.operatorName;
    }

    public List<OutputSelector<?>> getOutputSelectors() {
        return this.outputSelectors;
    }

    public void addOutputSelector(OutputSelector<?> outputSelector) {
        this.outputSelectors.add(outputSelector);
    }

    public TypeSerializer<?> getTypeSerializerIn1() {
        return this.typeSerializerIn1;
    }

    public void setSerializerIn1(TypeSerializer<?> typeSerializerIn1) {
        this.typeSerializerIn1 = typeSerializerIn1;
    }

    public TypeSerializer<?> getTypeSerializerIn2() {
        return this.typeSerializerIn2;
    }

    public void setSerializerIn2(TypeSerializer<?> typeSerializerIn2) {
        this.typeSerializerIn2 = typeSerializerIn2;
    }

    public TypeSerializer<?> getTypeSerializerOut() {
        return this.typeSerializerOut;
    }

    public void setSerializerOut(TypeSerializer<?> typeSerializerOut) {
        this.typeSerializerOut = typeSerializerOut;
    }

    public Class<? extends AbstractInvokable> getJobVertexClass() {
        return this.jobVertexClass;
    }

    public InputFormat<?, ?> getInputFormat() {
        return this.inputFormat;
    }

    public void setInputFormat(InputFormat<?, ?> inputFormat) {
        this.inputFormat = inputFormat;
    }

    public void setSlotSharingGroup(String slotSharingGroup) {
        this.slotSharingGroup = slotSharingGroup;
    }

    public String getSlotSharingGroup() {
        return this.slotSharingGroup;
    }

    public boolean isSameSlotSharingGroup(StreamNode downstreamVertex) {
        return this.slotSharingGroup == null && downstreamVertex.slotSharingGroup == null || this.slotSharingGroup != null && this.slotSharingGroup.equals(downstreamVertex.slotSharingGroup);
    }

    public String toString() {
        return this.operatorName + "-" + this.id;
    }

    public KeySelector<?, ?> getStatePartitioner1() {
        return this.statePartitioner1;
    }

    public KeySelector<?, ?> getStatePartitioner2() {
        return this.statePartitioner2;
    }

    public void setStatePartitioner1(KeySelector<?, ?> statePartitioner) {
        this.statePartitioner1 = statePartitioner;
    }

    public void setStatePartitioner2(KeySelector<?, ?> statePartitioner) {
        this.statePartitioner2 = statePartitioner;
    }

    public TypeSerializer<?> getStateKeySerializer() {
        return this.stateKeySerializer;
    }

    public void setStateKeySerializer(TypeSerializer<?> stateKeySerializer) {
        this.stateKeySerializer = stateKeySerializer;
    }

    public String getTransformationUID() {
        return this.transformationUID;
    }

    void setTransformationUID(String transformationId) {
        this.transformationUID = transformationId;
    }

    public String getUserHash() {
        return this.userHash;
    }

    public void setUserHash(String userHash) {
        this.userHash = userHash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamNode that = (StreamNode)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id;
    }
}

