/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.StreamGraphHasher;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.streaming.api.graph.StreamingJobGraphGenerator;
import org.apache.flink.util.StringUtils;

public class StreamGraphUserHashHasher
implements StreamGraphHasher {
    @Override
    public Map<Integer, byte[]> traverseStreamGraphAndGenerateHashes(StreamGraph streamGraph) {
        HashMap<Integer, byte[]> hashResult = new HashMap<Integer, byte[]>();
        for (StreamNode streamNode : streamGraph.getStreamNodes()) {
            String userHash = streamNode.getUserHash();
            if (null == userHash) continue;
            for (StreamEdge inEdge : streamNode.getInEdges()) {
                if (!StreamingJobGraphGenerator.isChainable(inEdge, streamGraph)) continue;
                throw new UnsupportedOperationException("Cannot assign user-specified hash to intermediate node in chain. This will be supported in future versions of Flink. As a work around start new chain at task " + streamNode.getOperatorName() + ".");
            }
            hashResult.put(streamNode.getId(), StringUtils.hexStringToByte((String)userHash));
        }
        return hashResult;
    }
}

