/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.functions.FoldFunction;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RichFunction;
import org.apache.flink.api.common.state.FoldingStateDescriptor;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.Utils;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.datastream.KeyedStream;
import org.apache.flink.streaming.api.datastream.LegacyWindowOperatorType;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.aggregation.AggregationFunction;
import org.apache.flink.streaming.api.functions.aggregation.ComparableAggregator;
import org.apache.flink.streaming.api.functions.aggregation.SumAggregator;
import org.apache.flink.streaming.api.functions.windowing.FoldApplyWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.PassThroughWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.ReduceApplyWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.WindowFunction;
import org.apache.flink.streaming.api.windowing.assigners.BaseAlignedWindowAssigner;
import org.apache.flink.streaming.api.windowing.assigners.MergingWindowAssigner;
import org.apache.flink.streaming.api.windowing.assigners.SlidingAlignedProcessingTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.SlidingProcessingTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.TumblingAlignedProcessingTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.TumblingProcessingTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.evictors.Evictor;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.api.windowing.triggers.ProcessingTimeTrigger;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.operators.windowing.AccumulatingProcessingTimeWindowOperator;
import org.apache.flink.streaming.runtime.operators.windowing.AggregatingProcessingTimeWindowOperator;
import org.apache.flink.streaming.runtime.operators.windowing.EvictingWindowOperator;
import org.apache.flink.streaming.runtime.operators.windowing.WindowOperator;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalIterableWindowFunction;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalSingleValueWindowFunction;
import org.apache.flink.streaming.runtime.streamrecord.StreamElementSerializer;
import org.apache.flink.util.Preconditions;

@Public
public class WindowedStream<T, K, W extends Window> {
    private final KeyedStream<T, K> input;
    private final WindowAssigner<? super T, W> windowAssigner;
    private Trigger<? super T, ? super W> trigger;
    private Evictor<? super T, ? super W> evictor;
    private long allowedLateness = 0L;

    @PublicEvolving
    public WindowedStream(KeyedStream<T, K> input, WindowAssigner<? super T, W> windowAssigner) {
        this.input = input;
        this.windowAssigner = windowAssigner;
        this.trigger = windowAssigner.getDefaultTrigger(input.getExecutionEnvironment());
    }

    @PublicEvolving
    public WindowedStream<T, K, W> trigger(Trigger<? super T, ? super W> trigger) {
        if (this.windowAssigner instanceof MergingWindowAssigner && !trigger.canMerge()) {
            throw new UnsupportedOperationException("A merging window assigner cannot be used with a trigger that does not support merging.");
        }
        if (this.windowAssigner instanceof BaseAlignedWindowAssigner) {
            throw new UnsupportedOperationException("Cannot use a " + this.windowAssigner.getClass().getSimpleName() + " with a custom trigger.");
        }
        this.trigger = trigger;
        return this;
    }

    @PublicEvolving
    public WindowedStream<T, K, W> allowedLateness(Time lateness) {
        long millis = lateness.toMilliseconds();
        Preconditions.checkArgument((millis >= 0L ? 1 : 0) != 0, (Object)"The allowed lateness cannot be negative.");
        this.allowedLateness = millis;
        return this;
    }

    @PublicEvolving
    public WindowedStream<T, K, W> evictor(Evictor<? super T, ? super W> evictor) {
        if (this.windowAssigner instanceof MergingWindowAssigner) {
            throw new UnsupportedOperationException("Cannot use a merging WindowAssigner with an Evictor.");
        }
        if (this.windowAssigner instanceof BaseAlignedWindowAssigner) {
            throw new UnsupportedOperationException("Cannot use a " + this.windowAssigner.getClass().getSimpleName() + " with an Evictor.");
        }
        this.evictor = evictor;
        return this;
    }

    public SingleOutputStreamOperator<T> reduce(ReduceFunction<T> function) {
        if (function instanceof RichFunction) {
            throw new UnsupportedOperationException("ReduceFunction of reduce can not be a RichFunction. Please use reduce(ReduceFunction, WindowFunction) instead.");
        }
        function = this.input.getExecutionEnvironment().clean(function);
        String callLocation = Utils.getCallLocationName();
        String udfName = "WindowedStream." + callLocation;
        SingleOutputStreamOperator result = this.createFastTimeOperatorIfValid((Function)function, (TypeInformation)this.input.getType(), udfName);
        if (result != null) {
            return result;
        }
        LegacyWindowOperatorType legacyOpType = this.getLegacyWindowType((Function)function);
        return this.reduce(function, new PassThroughWindowFunction(), legacyOpType);
    }

    @PublicEvolving
    public <R> SingleOutputStreamOperator<R> reduce(ReduceFunction<T> reduceFunction, WindowFunction<T, R, K, W> function) {
        return this.reduce(reduceFunction, function, LegacyWindowOperatorType.NONE);
    }

    @PublicEvolving
    public <R> SingleOutputStreamOperator<R> reduce(ReduceFunction<T> reduceFunction, WindowFunction<T, R, K, W> function, TypeInformation<R> resultType) {
        return this.reduce(reduceFunction, function, resultType, LegacyWindowOperatorType.NONE);
    }

    private <R> SingleOutputStreamOperator<R> reduce(ReduceFunction<T> reduceFunction, WindowFunction<T, R, K, W> function, LegacyWindowOperatorType legacyWindowOpType) {
        TypeInformation inType = this.input.getType();
        TypeInformation resultType = TypeExtractor.getUnaryOperatorReturnType(function, WindowFunction.class, (boolean)true, (boolean)true, inType, null, (boolean)false);
        return this.reduce(reduceFunction, function, resultType, legacyWindowOpType);
    }

    private <R> SingleOutputStreamOperator<R> reduce(ReduceFunction<T> reduceFunction, WindowFunction<T, R, K, W> function, TypeInformation<R> resultType, LegacyWindowOperatorType legacyWindowOpType) {
        WindowOperator<K, ? super T, T, R, ? super W> operator;
        String opName;
        if (reduceFunction instanceof RichFunction) {
            throw new UnsupportedOperationException("ReduceFunction of reduce can not be a RichFunction.");
        }
        function = this.input.getExecutionEnvironment().clean(function);
        reduceFunction = this.input.getExecutionEnvironment().clean(reduceFunction);
        String callLocation = Utils.getCallLocationName();
        String udfName = "WindowedStream." + callLocation;
        KeySelector<T, K> keySel = this.input.getKeySelector();
        if (this.evictor != null) {
            StreamElementSerializer streamRecordSerializer = new StreamElementSerializer(this.input.getType().createSerializer(this.getExecutionEnvironment().getConfig()));
            ListStateDescriptor stateDesc = new ListStateDescriptor("window-contents", streamRecordSerializer);
            opName = "TriggerWindow(" + this.windowAssigner + ", " + stateDesc + ", " + this.trigger + ", " + this.evictor + ", " + udfName + ")";
            operator = new EvictingWindowOperator<K, T, W, W>(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.getExecutionEnvironment().getConfig()), keySel, this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig()), stateDesc, new InternalIterableWindowFunction<K, W, T, R>(new ReduceApplyWindowFunction<K, W, T, R>(reduceFunction, function)), this.trigger, this.evictor, this.allowedLateness);
        } else {
            ReducingStateDescriptor stateDesc = new ReducingStateDescriptor("window-contents", reduceFunction, this.input.getType().createSerializer(this.getExecutionEnvironment().getConfig()));
            opName = "TriggerWindow(" + this.windowAssigner + ", " + stateDesc + ", " + this.trigger + ", " + udfName + ")";
            operator = new WindowOperator<K, T, T, R, W>(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.getExecutionEnvironment().getConfig()), keySel, this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig()), stateDesc, new InternalSingleValueWindowFunction<T, R, K, W>(function), this.trigger, this.allowedLateness, legacyWindowOpType);
        }
        return this.input.transform(opName, resultType, operator);
    }

    public <R> SingleOutputStreamOperator<R> fold(R initialValue, FoldFunction<T, R> function) {
        if (function instanceof RichFunction) {
            throw new UnsupportedOperationException("FoldFunction can not be a RichFunction. Please use fold(FoldFunction, WindowFunction) instead.");
        }
        TypeInformation resultType = TypeExtractor.getFoldReturnTypes(function, this.input.getType(), (String)Utils.getCallLocationName(), (boolean)true);
        return this.fold(initialValue, function, resultType);
    }

    public <R> SingleOutputStreamOperator<R> fold(R initialValue, FoldFunction<T, R> function, TypeInformation<R> resultType) {
        if (function instanceof RichFunction) {
            throw new UnsupportedOperationException("FoldFunction can not be a RichFunction. Please use fold(FoldFunction, WindowFunction) instead.");
        }
        return this.fold(initialValue, function, new PassThroughWindowFunction(), resultType, resultType);
    }

    @PublicEvolving
    public <ACC, R> SingleOutputStreamOperator<R> fold(ACC initialValue, FoldFunction<T, ACC> foldFunction, WindowFunction<ACC, R, K, W> function) {
        TypeInformation foldAccumulatorType = TypeExtractor.getFoldReturnTypes(foldFunction, this.input.getType(), (String)Utils.getCallLocationName(), (boolean)true);
        TypeInformation resultType = TypeExtractor.getUnaryOperatorReturnType(function, WindowFunction.class, (boolean)true, (boolean)true, (TypeInformation)foldAccumulatorType, null, (boolean)false);
        return this.fold(initialValue, foldFunction, function, foldAccumulatorType, resultType);
    }

    @PublicEvolving
    public <ACC, R> SingleOutputStreamOperator<R> fold(ACC initialValue, FoldFunction<T, ACC> foldFunction, WindowFunction<ACC, R, K, W> function, TypeInformation<ACC> foldAccumulatorType, TypeInformation<R> resultType) {
        WindowOperator<K, ? super T, ACC, R, ? super W> operator;
        String opName;
        if (foldFunction instanceof RichFunction) {
            throw new UnsupportedOperationException("FoldFunction of fold can not be a RichFunction.");
        }
        if (this.windowAssigner instanceof MergingWindowAssigner) {
            throw new UnsupportedOperationException("Fold cannot be used with a merging WindowAssigner.");
        }
        if (this.windowAssigner instanceof BaseAlignedWindowAssigner) {
            throw new UnsupportedOperationException("Fold cannot be used with a " + this.windowAssigner.getClass().getSimpleName() + " assigner.");
        }
        function = this.input.getExecutionEnvironment().clean(function);
        foldFunction = this.input.getExecutionEnvironment().clean(foldFunction);
        String callLocation = Utils.getCallLocationName();
        String udfName = "WindowedStream." + callLocation;
        KeySelector<T, K> keySel = this.input.getKeySelector();
        if (this.evictor != null) {
            StreamElementSerializer streamRecordSerializer = new StreamElementSerializer(this.input.getType().createSerializer(this.getExecutionEnvironment().getConfig()));
            ListStateDescriptor stateDesc = new ListStateDescriptor("window-contents", streamRecordSerializer);
            opName = "TriggerWindow(" + this.windowAssigner + ", " + stateDesc + ", " + this.trigger + ", " + this.evictor + ", " + udfName + ")";
            operator = new EvictingWindowOperator<K, T, R, W>(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.getExecutionEnvironment().getConfig()), keySel, this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig()), stateDesc, new InternalIterableWindowFunction(new FoldApplyWindowFunction<K, W, T, ACC, R>(initialValue, foldFunction, function, foldAccumulatorType)), this.trigger, this.evictor, this.allowedLateness);
        } else {
            FoldingStateDescriptor stateDesc = new FoldingStateDescriptor("window-contents", initialValue, foldFunction, foldAccumulatorType.createSerializer(this.getExecutionEnvironment().getConfig()));
            opName = "TriggerWindow(" + this.windowAssigner + ", " + stateDesc + ", " + this.trigger + ", " + udfName + ")";
            operator = new WindowOperator<K, T, ACC, R, W>(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.getExecutionEnvironment().getConfig()), keySel, this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig()), stateDesc, new InternalSingleValueWindowFunction<ACC, R, K, W>(function), this.trigger, this.allowedLateness);
        }
        return this.input.transform(opName, resultType, operator);
    }

    public <R> SingleOutputStreamOperator<R> apply(WindowFunction<T, R, K, W> function) {
        TypeInformation resultType = TypeExtractor.getUnaryOperatorReturnType(function, WindowFunction.class, (boolean)true, (boolean)true, this.getInputType(), null, (boolean)false);
        return this.apply(function, resultType);
    }

    public <R> SingleOutputStreamOperator<R> apply(WindowFunction<T, R, K, W> function, TypeInformation<R> resultType) {
        WindowOperator<K, ? super T, T, R, ? super W> operator;
        String opName;
        function = this.input.getExecutionEnvironment().clean(function);
        String callLocation = Utils.getCallLocationName();
        String udfName = "WindowedStream." + callLocation;
        SingleOutputStreamOperator<R> result = this.createFastTimeOperatorIfValid(function, resultType, udfName);
        if (result != null) {
            return result;
        }
        LegacyWindowOperatorType legacyWindowOpType = this.getLegacyWindowType(function);
        KeySelector<T, K> keySel = this.input.getKeySelector();
        if (this.evictor != null) {
            StreamElementSerializer streamRecordSerializer = new StreamElementSerializer(this.input.getType().createSerializer(this.getExecutionEnvironment().getConfig()));
            ListStateDescriptor stateDesc = new ListStateDescriptor("window-contents", streamRecordSerializer);
            opName = "TriggerWindow(" + this.windowAssigner + ", " + stateDesc + ", " + this.trigger + ", " + this.evictor + ", " + udfName + ")";
            operator = new EvictingWindowOperator<K, T, R, W>(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.getExecutionEnvironment().getConfig()), keySel, this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig()), stateDesc, new InternalIterableWindowFunction<T, R, K, W>(function), this.trigger, this.evictor, this.allowedLateness);
        } else {
            ListStateDescriptor stateDesc = new ListStateDescriptor("window-contents", this.input.getType().createSerializer(this.getExecutionEnvironment().getConfig()));
            opName = "TriggerWindow(" + this.windowAssigner + ", " + stateDesc + ", " + this.trigger + ", " + udfName + ")";
            operator = new WindowOperator<K, T, T, R, W>(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.getExecutionEnvironment().getConfig()), keySel, this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig()), stateDesc, new InternalIterableWindowFunction<T, R, K, W>(function), this.trigger, this.allowedLateness, legacyWindowOpType);
        }
        return this.input.transform(opName, resultType, operator);
    }

    @Deprecated
    public <R> SingleOutputStreamOperator<R> apply(ReduceFunction<T> reduceFunction, WindowFunction<T, R, K, W> function) {
        TypeInformation inType = this.input.getType();
        TypeInformation resultType = TypeExtractor.getUnaryOperatorReturnType(function, WindowFunction.class, (boolean)true, (boolean)true, inType, null, (boolean)false);
        return this.apply(reduceFunction, function, resultType);
    }

    @Deprecated
    public <R> SingleOutputStreamOperator<R> apply(ReduceFunction<T> reduceFunction, WindowFunction<T, R, K, W> function, TypeInformation<R> resultType) {
        WindowOperator<K, ? super T, T, R, ? super W> operator;
        String opName;
        if (reduceFunction instanceof RichFunction) {
            throw new UnsupportedOperationException("ReduceFunction of apply can not be a RichFunction.");
        }
        function = this.input.getExecutionEnvironment().clean(function);
        reduceFunction = this.input.getExecutionEnvironment().clean(reduceFunction);
        String callLocation = Utils.getCallLocationName();
        String udfName = "WindowedStream." + callLocation;
        KeySelector<T, K> keySel = this.input.getKeySelector();
        if (this.evictor != null) {
            StreamElementSerializer streamRecordSerializer = new StreamElementSerializer(this.input.getType().createSerializer(this.getExecutionEnvironment().getConfig()));
            ListStateDescriptor stateDesc = new ListStateDescriptor("window-contents", streamRecordSerializer);
            opName = "TriggerWindow(" + this.windowAssigner + ", " + stateDesc + ", " + this.trigger + ", " + this.evictor + ", " + udfName + ")";
            operator = new EvictingWindowOperator<K, T, W, W>(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.getExecutionEnvironment().getConfig()), keySel, this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig()), stateDesc, new InternalIterableWindowFunction<K, W, T, R>(new ReduceApplyWindowFunction<K, W, T, R>(reduceFunction, function)), this.trigger, this.evictor, this.allowedLateness);
        } else {
            ReducingStateDescriptor stateDesc = new ReducingStateDescriptor("window-contents", reduceFunction, this.input.getType().createSerializer(this.getExecutionEnvironment().getConfig()));
            opName = "TriggerWindow(" + this.windowAssigner + ", " + stateDesc + ", " + this.trigger + ", " + udfName + ")";
            operator = new WindowOperator<K, T, T, R, W>(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.getExecutionEnvironment().getConfig()), keySel, this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig()), stateDesc, new InternalSingleValueWindowFunction<T, R, K, W>(function), this.trigger, this.allowedLateness);
        }
        return this.input.transform(opName, resultType, operator);
    }

    @Deprecated
    public <R> SingleOutputStreamOperator<R> apply(R initialValue, FoldFunction<T, R> foldFunction, WindowFunction<R, R, K, W> function) {
        TypeInformation resultType = TypeExtractor.getFoldReturnTypes(foldFunction, this.input.getType(), (String)Utils.getCallLocationName(), (boolean)true);
        return this.apply(initialValue, foldFunction, function, resultType);
    }

    @Deprecated
    public <R> SingleOutputStreamOperator<R> apply(R initialValue, FoldFunction<T, R> foldFunction, WindowFunction<R, R, K, W> function, TypeInformation<R> resultType) {
        WindowOperator<K, ? super T, R, R, ? super W> operator;
        String opName;
        if (foldFunction instanceof RichFunction) {
            throw new UnsupportedOperationException("FoldFunction of apply can not be a RichFunction.");
        }
        if (this.windowAssigner instanceof MergingWindowAssigner) {
            throw new UnsupportedOperationException("Fold cannot be used with a merging WindowAssigner.");
        }
        function = this.input.getExecutionEnvironment().clean(function);
        foldFunction = this.input.getExecutionEnvironment().clean(foldFunction);
        String callLocation = Utils.getCallLocationName();
        String udfName = "WindowedStream." + callLocation;
        KeySelector<T, K> keySel = this.input.getKeySelector();
        if (this.evictor != null) {
            StreamElementSerializer streamRecordSerializer = new StreamElementSerializer(this.input.getType().createSerializer(this.getExecutionEnvironment().getConfig()));
            ListStateDescriptor stateDesc = new ListStateDescriptor("window-contents", streamRecordSerializer);
            opName = "TriggerWindow(" + this.windowAssigner + ", " + stateDesc + ", " + this.trigger + ", " + this.evictor + ", " + udfName + ")";
            operator = new EvictingWindowOperator<K, T, R, W>(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.getExecutionEnvironment().getConfig()), keySel, this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig()), stateDesc, new InternalIterableWindowFunction(new FoldApplyWindowFunction<K, W, T, R, R>(initialValue, foldFunction, function, resultType)), this.trigger, this.evictor, this.allowedLateness);
        } else {
            FoldingStateDescriptor stateDesc = new FoldingStateDescriptor("window-contents", initialValue, foldFunction, resultType.createSerializer(this.getExecutionEnvironment().getConfig()));
            opName = "TriggerWindow(" + this.windowAssigner + ", " + stateDesc + ", " + this.trigger + ", " + udfName + ")";
            operator = new WindowOperator<K, T, R, R, W>(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.getExecutionEnvironment().getConfig()), keySel, this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig()), stateDesc, new InternalSingleValueWindowFunction<R, R, K, W>(function), this.trigger, this.allowedLateness);
        }
        return this.input.transform(opName, resultType, operator);
    }

    public SingleOutputStreamOperator<T> sum(int positionToSum) {
        return this.aggregate(new SumAggregator(positionToSum, this.input.getType(), this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T> sum(String field) {
        return this.aggregate(new SumAggregator(field, this.input.getType(), this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T> min(int positionToMin) {
        return this.aggregate(new ComparableAggregator(positionToMin, this.input.getType(), AggregationFunction.AggregationType.MIN, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T> min(String field) {
        return this.aggregate(new ComparableAggregator(field, this.input.getType(), AggregationFunction.AggregationType.MIN, false, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T> minBy(int positionToMinBy) {
        return this.minBy(positionToMinBy, true);
    }

    public SingleOutputStreamOperator<T> minBy(String positionToMinBy) {
        return this.minBy(positionToMinBy, true);
    }

    public SingleOutputStreamOperator<T> minBy(int positionToMinBy, boolean first) {
        return this.aggregate(new ComparableAggregator(positionToMinBy, this.input.getType(), AggregationFunction.AggregationType.MINBY, first, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T> minBy(String field, boolean first) {
        return this.aggregate(new ComparableAggregator(field, this.input.getType(), AggregationFunction.AggregationType.MINBY, first, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T> max(int positionToMax) {
        return this.aggregate(new ComparableAggregator(positionToMax, this.input.getType(), AggregationFunction.AggregationType.MAX, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T> max(String field) {
        return this.aggregate(new ComparableAggregator(field, this.input.getType(), AggregationFunction.AggregationType.MAX, false, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T> maxBy(int positionToMaxBy) {
        return this.maxBy(positionToMaxBy, true);
    }

    public SingleOutputStreamOperator<T> maxBy(String positionToMaxBy) {
        return this.maxBy(positionToMaxBy, true);
    }

    public SingleOutputStreamOperator<T> maxBy(int positionToMaxBy, boolean first) {
        return this.aggregate(new ComparableAggregator(positionToMaxBy, this.input.getType(), AggregationFunction.AggregationType.MAXBY, first, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T> maxBy(String field, boolean first) {
        return this.aggregate(new ComparableAggregator(field, this.input.getType(), AggregationFunction.AggregationType.MAXBY, first, this.input.getExecutionConfig()));
    }

    private SingleOutputStreamOperator<T> aggregate(AggregationFunction<T> aggregator) {
        return this.reduce(aggregator);
    }

    private LegacyWindowOperatorType getLegacyWindowType(Function function) {
        if (this.windowAssigner instanceof SlidingProcessingTimeWindows && this.trigger instanceof ProcessingTimeTrigger && this.evictor == null) {
            if (function instanceof ReduceFunction) {
                return LegacyWindowOperatorType.FAST_AGGREGATING;
            }
            if (function instanceof WindowFunction) {
                return LegacyWindowOperatorType.FAST_ACCUMULATING;
            }
        } else if (this.windowAssigner instanceof TumblingProcessingTimeWindows && this.trigger instanceof ProcessingTimeTrigger && this.evictor == null) {
            if (function instanceof ReduceFunction) {
                return LegacyWindowOperatorType.FAST_AGGREGATING;
            }
            if (function instanceof WindowFunction) {
                return LegacyWindowOperatorType.FAST_ACCUMULATING;
            }
        }
        return LegacyWindowOperatorType.NONE;
    }

    private <R> SingleOutputStreamOperator<R> createFastTimeOperatorIfValid(Function function, TypeInformation<R> resultType, String functionName) {
        if (this.windowAssigner.getClass() == SlidingAlignedProcessingTimeWindows.class && this.trigger == null && this.evictor == null) {
            SlidingAlignedProcessingTimeWindows timeWindows = (SlidingAlignedProcessingTimeWindows)this.windowAssigner;
            long windowLength = timeWindows.getSize();
            long windowSlide = timeWindows.getSlide();
            String opName = "Fast " + timeWindows + " of " + functionName;
            if (function instanceof ReduceFunction) {
                ReduceFunction reducer = (ReduceFunction)function;
                AggregatingProcessingTimeWindowOperator<K, T> op = new AggregatingProcessingTimeWindowOperator<K, T>(reducer, this.input.getKeySelector(), this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig()), this.input.getType().createSerializer(this.getExecutionEnvironment().getConfig()), windowLength, windowSlide);
                return this.input.transform(opName, resultType, op);
            }
            if (function instanceof WindowFunction) {
                WindowFunction wf = (WindowFunction)function;
                AccumulatingProcessingTimeWindowOperator op = new AccumulatingProcessingTimeWindowOperator(wf, this.input.getKeySelector(), this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig()), this.input.getType().createSerializer(this.getExecutionEnvironment().getConfig()), windowLength, windowSlide);
                return this.input.transform(opName, resultType, op);
            }
        } else if (this.windowAssigner.getClass() == TumblingAlignedProcessingTimeWindows.class && this.trigger == null && this.evictor == null) {
            TumblingAlignedProcessingTimeWindows timeWindows = (TumblingAlignedProcessingTimeWindows)this.windowAssigner;
            long windowLength = timeWindows.getSize();
            long windowSlide = timeWindows.getSize();
            String opName = "Fast " + timeWindows + " of " + functionName;
            if (function instanceof ReduceFunction) {
                ReduceFunction reducer = (ReduceFunction)function;
                AggregatingProcessingTimeWindowOperator<K, T> op = new AggregatingProcessingTimeWindowOperator<K, T>(reducer, this.input.getKeySelector(), this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig()), this.input.getType().createSerializer(this.getExecutionEnvironment().getConfig()), windowLength, windowSlide);
                return this.input.transform(opName, resultType, op);
            }
            if (function instanceof WindowFunction) {
                WindowFunction wf = (WindowFunction)function;
                AccumulatingProcessingTimeWindowOperator op = new AccumulatingProcessingTimeWindowOperator(wf, this.input.getKeySelector(), this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig()), this.input.getType().createSerializer(this.getExecutionEnvironment().getConfig()), windowLength, windowSlide);
                return this.input.transform(opName, resultType, op);
            }
        }
        return null;
    }

    public StreamExecutionEnvironment getExecutionEnvironment() {
        return this.input.getExecutionEnvironment();
    }

    public TypeInformation<T> getInputType() {
        return this.input.getType();
    }
}

