/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.StreamSink;
import org.apache.flink.streaming.api.transformations.SinkTransformation;

@Public
public class DataStreamSink<T> {
    SinkTransformation<T> transformation;

    protected DataStreamSink(DataStream<T> inputStream, StreamSink<T> operator) {
        this.transformation = new SinkTransformation<T>(inputStream.getTransformation(), "Unnamed", operator, inputStream.getExecutionEnvironment().getParallelism());
    }

    @Internal
    public SinkTransformation<T> getTransformation() {
        return this.transformation;
    }

    public DataStreamSink<T> name(String name) {
        this.transformation.setName(name);
        return this;
    }

    @PublicEvolving
    public DataStreamSink<T> uid(String uid) {
        this.transformation.setUid(uid);
        return this;
    }

    @PublicEvolving
    public DataStreamSink<T> setUidHash(String uidHash) {
        this.transformation.setUidHash(uidHash);
        return this;
    }

    public DataStreamSink<T> setParallelism(int parallelism) {
        this.transformation.setParallelism(parallelism);
        return this;
    }

    @PublicEvolving
    public DataStreamSink<T> disableChaining() {
        this.transformation.setChainingStrategy(ChainingStrategy.NEVER);
        return this;
    }

    @PublicEvolving
    public DataStreamSink<T> slotSharingGroup(String slotSharingGroup) {
        this.transformation.setSlotSharingGroup(slotSharingGroup);
        return this;
    }
}

