/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink.committables;

import java.io.IOException;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.io.SimpleVersionedSerialization;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputView;

@Internal
public class SinkV1CommittableDeserializer {
    @VisibleForTesting
    public static final int MAGIC_NUMBER = -1189141204;

    public static <T> List<T> readVersionAndDeserializeList(SimpleVersionedSerializer<T> serializer, DataInputView in) throws IOException {
        SinkV1CommittableDeserializer.validateMagicNumber(in);
        return SimpleVersionedSerialization.readVersionAndDeserializeList(serializer, (DataInputView)in);
    }

    private static void validateMagicNumber(DataInputView in) throws IOException {
        int magicNumber = in.readInt();
        if (magicNumber != -1189141204) {
            throw new IllegalStateException(String.format("Corrupt data: Unexpected magic number %08X", magicNumber));
        }
    }
}

