/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.contrib.streaming.state.DefaultConfigurableOptionsFactory;
import org.apache.flink.contrib.streaming.state.PredefinedOptions;
import org.apache.flink.contrib.streaming.state.RocksDBStateBackend;

public class RocksDBOptions {
    @Documentation.Section(value={"expert_rocksdb"})
    public static final ConfigOption<String> LOCAL_DIRECTORIES = ConfigOptions.key((String)"state.backend.rocksdb.localdir").noDefaultValue().withDeprecatedKeys(new String[]{"state.backend.rocksdb.checkpointdir"}).withDescription("The local directory (on the TaskManager) where RocksDB puts its files.");
    @Documentation.Section(value={"state_backend_rocksdb"})
    public static final ConfigOption<RocksDBStateBackend.PriorityQueueStateType> TIMER_SERVICE_FACTORY = ConfigOptions.key((String)"state.backend.rocksdb.timer-service.factory").enumType(RocksDBStateBackend.PriorityQueueStateType.class).defaultValue((Object)RocksDBStateBackend.PriorityQueueStateType.ROCKSDB).withDescription(String.format("This determines the factory for timer service state implementation. Options are either %s (heap-based) or %s for an implementation based on RocksDB.", RocksDBStateBackend.PriorityQueueStateType.HEAP.name(), RocksDBStateBackend.PriorityQueueStateType.ROCKSDB.name()));
    @Documentation.Section(value={"expert_rocksdb"})
    public static final ConfigOption<Integer> CHECKPOINT_TRANSFER_THREAD_NUM = ConfigOptions.key((String)"state.backend.rocksdb.checkpoint.transfer.thread.num").defaultValue((Object)1).withDescription("The number of threads (per stateful operator) used to transfer (download and upload) files in RocksDBStateBackend.");
    @Documentation.Section(value={"expert_rocksdb"})
    public static final ConfigOption<String> PREDEFINED_OPTIONS = ConfigOptions.key((String)"state.backend.rocksdb.predefined-options").defaultValue((Object)PredefinedOptions.DEFAULT.name()).withDescription(String.format("The predefined settings for RocksDB DBOptions and ColumnFamilyOptions by Flink community. Current supported candidate predefined-options are %s, %s, %s or %s. Note that user customized options and options from the RocksDBOptionsFactory are applied on top of these predefined ones.", PredefinedOptions.DEFAULT.name(), PredefinedOptions.SPINNING_DISK_OPTIMIZED.name(), PredefinedOptions.SPINNING_DISK_OPTIMIZED_HIGH_MEM.name(), PredefinedOptions.FLASH_SSD_OPTIMIZED.name()));
    @Documentation.Section(value={"expert_rocksdb"})
    public static final ConfigOption<String> OPTIONS_FACTORY = ConfigOptions.key((String)"state.backend.rocksdb.options-factory").defaultValue((Object)DefaultConfigurableOptionsFactory.class.getName()).withDescription(String.format("The options factory class for RocksDB to create DBOptions and ColumnFamilyOptions. The default options factory is %s, and it would read the configured options which provided in 'RocksDBConfigurableOptions'.", DefaultConfigurableOptionsFactory.class.getName()));
    @Documentation.Section(value={"state_backend_rocksdb"})
    public static final ConfigOption<Boolean> USE_MANAGED_MEMORY = ConfigOptions.key((String)"state.backend.rocksdb.memory.managed").booleanType().defaultValue((Object)true).withDescription("If set, the RocksDB state backend will automatically configure itself to use the managed memory budget of the task slot, and divide the memory over write buffers, indexes, block caches, etc. That way, the three major uses of memory of RocksDB will be capped.");
    @Documentation.Section(value={"state_backend_rocksdb"})
    public static final ConfigOption<MemorySize> FIX_PER_SLOT_MEMORY_SIZE = ConfigOptions.key((String)"state.backend.rocksdb.memory.fixed-per-slot").memoryType().noDefaultValue().withDescription(String.format("The fixed total amount of memory, shared among all RocksDB instances per slot. This option overrides the '%s' option when configured. If neither this option, nor the '%s' optionare set, then each RocksDB column family state has its own memory caches (as controlled by the column family options).", USE_MANAGED_MEMORY.key(), USE_MANAGED_MEMORY.key()));
    @Documentation.Section(value={"state_backend_rocksdb"})
    public static final ConfigOption<Double> WRITE_BUFFER_RATIO = ConfigOptions.key((String)"state.backend.rocksdb.memory.write-buffer-ratio").doubleType().defaultValue((Object)0.5).withDescription(String.format("The maximum amount of memory that write buffers may take, as a fraction of the total shared memory. This option only has an effect when '%s' or '%s' are configured.", USE_MANAGED_MEMORY.key(), FIX_PER_SLOT_MEMORY_SIZE.key()));
    @Documentation.Section(value={"state_backend_rocksdb"})
    public static final ConfigOption<Double> HIGH_PRIORITY_POOL_RATIO = ConfigOptions.key((String)"state.backend.rocksdb.memory.high-prio-pool-ratio").doubleType().defaultValue((Object)0.1).withDescription(String.format("The fraction of cache memory that is reserved for high-priority data like index, filter, and compression dictionary blocks. This option only has an effect when '%s' or '%s' are configured.", USE_MANAGED_MEMORY.key(), FIX_PER_SLOT_MEMORY_SIZE.key()));
}

