/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.flink.sql.parser.SqlUnparseUtils;

public class SqlCreateCatalog
extends SqlCreate {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("CREATE CATALOG", SqlKind.OTHER_DDL);
    private final SqlIdentifier catalogName;
    private final SqlNodeList propertyList;

    public SqlCreateCatalog(SqlParserPos position, SqlIdentifier catalogName, SqlNodeList propertyList) {
        super((SqlOperator)OPERATOR, position, false, false);
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName cannot be null");
        this.propertyList = Objects.requireNonNull(propertyList, "propertyList cannot be null");
    }

    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.catalogName, (Object)this.propertyList);
    }

    public SqlIdentifier getCatalogName() {
        return this.catalogName;
    }

    public SqlNodeList getPropertyList() {
        return this.propertyList;
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE CATALOG");
        this.catalogName.unparse(writer, leftPrec, rightPrec);
        if (this.propertyList.size() > 0) {
            writer.keyword("WITH");
            SqlWriter.Frame withFrame = writer.startList("(", ")");
            for (SqlNode property : this.propertyList) {
                SqlUnparseUtils.printIndent(writer);
                property.unparse(writer, leftPrec, rightPrec);
            }
            writer.newlineAndIndent();
            writer.endList(withFrame);
        }
    }

    public String catalogName() {
        return this.catalogName.getSimple();
    }
}

