/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkField;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkPojo;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallLocation;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallingType;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.traits.LocationTrait;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ShardFilter;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.ToString;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.builder.CopyableBuilder;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListShardsRequest
extends KinesisRequest
implements ToCopyableBuilder<Builder, ListShardsRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("StreamName").getter(ListShardsRequest.getter(ListShardsRequest::streamName)).setter(ListShardsRequest.setter(Builder::streamName)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("NextToken").getter(ListShardsRequest.getter(ListShardsRequest::nextToken)).setter(ListShardsRequest.setter(Builder::nextToken)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();
    private static final SdkField<String> EXCLUSIVE_START_SHARD_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("ExclusiveStartShardId").getter(ListShardsRequest.getter(ListShardsRequest::exclusiveStartShardId)).setter(ListShardsRequest.setter(Builder::exclusiveStartShardId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusiveStartShardId").build()).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder(MarshallingType.INTEGER).memberName("MaxResults").getter(ListShardsRequest.getter(ListShardsRequest::maxResults)).setter(ListShardsRequest.setter(Builder::maxResults)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();
    private static final SdkField<Instant> STREAM_CREATION_TIMESTAMP_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("StreamCreationTimestamp").getter(ListShardsRequest.getter(ListShardsRequest::streamCreationTimestamp)).setter(ListShardsRequest.setter(Builder::streamCreationTimestamp)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamCreationTimestamp").build()).build();
    private static final SdkField<ShardFilter> SHARD_FILTER_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("ShardFilter").getter(ListShardsRequest.getter(ListShardsRequest::shardFilter)).setter(ListShardsRequest.setter(Builder::shardFilter)).constructor(ShardFilter::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardFilter").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD, NEXT_TOKEN_FIELD, EXCLUSIVE_START_SHARD_ID_FIELD, MAX_RESULTS_FIELD, STREAM_CREATION_TIMESTAMP_FIELD, SHARD_FILTER_FIELD));
    private final String streamName;
    private final String nextToken;
    private final String exclusiveStartShardId;
    private final Integer maxResults;
    private final Instant streamCreationTimestamp;
    private final ShardFilter shardFilter;

    private ListShardsRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.nextToken = builder.nextToken;
        this.exclusiveStartShardId = builder.exclusiveStartShardId;
        this.maxResults = builder.maxResults;
        this.streamCreationTimestamp = builder.streamCreationTimestamp;
        this.shardFilter = builder.shardFilter;
    }

    public final String streamName() {
        return this.streamName;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String exclusiveStartShardId() {
        return this.exclusiveStartShardId;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final Instant streamCreationTimestamp() {
        return this.streamCreationTimestamp;
    }

    public final ShardFilter shardFilter() {
        return this.shardFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusiveStartShardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamCreationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.shardFilter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListShardsRequest)) {
            return false;
        }
        ListShardsRequest other = (ListShardsRequest)obj;
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.exclusiveStartShardId(), other.exclusiveStartShardId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.streamCreationTimestamp(), other.streamCreationTimestamp()) && Objects.equals(this.shardFilter(), other.shardFilter());
    }

    public final String toString() {
        return ToString.builder("ListShardsRequest").add("StreamName", this.streamName()).add("NextToken", this.nextToken()).add("ExclusiveStartShardId", this.exclusiveStartShardId()).add("MaxResults", this.maxResults()).add("StreamCreationTimestamp", this.streamCreationTimestamp()).add("ShardFilter", this.shardFilter()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ExclusiveStartShardId": {
                return Optional.ofNullable(clazz.cast(this.exclusiveStartShardId()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "StreamCreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.streamCreationTimestamp()));
            }
            case "ShardFilter": {
                return Optional.ofNullable(clazz.cast(this.shardFilter()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListShardsRequest, T> g) {
        return obj -> g.apply((ListShardsRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisRequest.BuilderImpl
    implements Builder {
        private String streamName;
        private String nextToken;
        private String exclusiveStartShardId;
        private Integer maxResults;
        private Instant streamCreationTimestamp;
        private ShardFilter shardFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListShardsRequest model) {
            super(model);
            this.streamName(model.streamName);
            this.nextToken(model.nextToken);
            this.exclusiveStartShardId(model.exclusiveStartShardId);
            this.maxResults(model.maxResults);
            this.streamCreationTimestamp(model.streamCreationTimestamp);
            this.shardFilter(model.shardFilter);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getExclusiveStartShardId() {
            return this.exclusiveStartShardId;
        }

        public final void setExclusiveStartShardId(String exclusiveStartShardId) {
            this.exclusiveStartShardId = exclusiveStartShardId;
        }

        @Override
        public final Builder exclusiveStartShardId(String exclusiveStartShardId) {
            this.exclusiveStartShardId = exclusiveStartShardId;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Instant getStreamCreationTimestamp() {
            return this.streamCreationTimestamp;
        }

        public final void setStreamCreationTimestamp(Instant streamCreationTimestamp) {
            this.streamCreationTimestamp = streamCreationTimestamp;
        }

        @Override
        public final Builder streamCreationTimestamp(Instant streamCreationTimestamp) {
            this.streamCreationTimestamp = streamCreationTimestamp;
            return this;
        }

        public final ShardFilter.Builder getShardFilter() {
            return this.shardFilter != null ? this.shardFilter.toBuilder() : null;
        }

        public final void setShardFilter(ShardFilter.BuilderImpl shardFilter) {
            this.shardFilter = shardFilter != null ? shardFilter.build() : null;
        }

        @Override
        public final Builder shardFilter(ShardFilter shardFilter) {
            this.shardFilter = shardFilter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListShardsRequest build() {
            return new ListShardsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListShardsRequest> {
        public Builder streamName(String var1);

        public Builder nextToken(String var1);

        public Builder exclusiveStartShardId(String var1);

        public Builder maxResults(Integer var1);

        public Builder streamCreationTimestamp(Instant var1);

        public Builder shardFilter(ShardFilter var1);

        default public Builder shardFilter(Consumer<ShardFilter.Builder> shardFilter) {
            return this.shardFilter((ShardFilter)ShardFilter.builder().applyMutation(shardFilter).build());
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

