/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkField;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkPojo;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallLocation;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallingType;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.traits.ListTrait;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.traits.LocationTrait;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.util.SdkAutoConstructList;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.MetricsName;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.MetricsNameListCopier;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.ToString;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.builder.CopyableBuilder;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisableEnhancedMonitoringRequest
extends KinesisRequest
implements ToCopyableBuilder<Builder, DisableEnhancedMonitoringRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("StreamName").getter(DisableEnhancedMonitoringRequest.getter(DisableEnhancedMonitoringRequest::streamName)).setter(DisableEnhancedMonitoringRequest.setter(Builder::streamName)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();
    private static final SdkField<List<String>> SHARD_LEVEL_METRICS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("ShardLevelMetrics").getter(DisableEnhancedMonitoringRequest.getter(DisableEnhancedMonitoringRequest::shardLevelMetricsAsStrings)).setter(DisableEnhancedMonitoringRequest.setter(Builder::shardLevelMetricsWithStrings)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardLevelMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD, SHARD_LEVEL_METRICS_FIELD));
    private final String streamName;
    private final List<String> shardLevelMetrics;

    private DisableEnhancedMonitoringRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.shardLevelMetrics = builder.shardLevelMetrics;
    }

    public final String streamName() {
        return this.streamName;
    }

    public final List<MetricsName> shardLevelMetrics() {
        return MetricsNameListCopier.copyStringToEnum(this.shardLevelMetrics);
    }

    public final boolean hasShardLevelMetrics() {
        return this.shardLevelMetrics != null && !(this.shardLevelMetrics instanceof SdkAutoConstructList);
    }

    public final List<String> shardLevelMetricsAsStrings() {
        return this.shardLevelMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasShardLevelMetrics() ? this.shardLevelMetricsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableEnhancedMonitoringRequest)) {
            return false;
        }
        DisableEnhancedMonitoringRequest other = (DisableEnhancedMonitoringRequest)obj;
        return Objects.equals(this.streamName(), other.streamName()) && this.hasShardLevelMetrics() == other.hasShardLevelMetrics() && Objects.equals(this.shardLevelMetricsAsStrings(), other.shardLevelMetricsAsStrings());
    }

    public final String toString() {
        return ToString.builder("DisableEnhancedMonitoringRequest").add("StreamName", this.streamName()).add("ShardLevelMetrics", this.hasShardLevelMetrics() ? this.shardLevelMetricsAsStrings() : null).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "ShardLevelMetrics": {
                return Optional.ofNullable(clazz.cast(this.shardLevelMetricsAsStrings()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisableEnhancedMonitoringRequest, T> g) {
        return obj -> g.apply((DisableEnhancedMonitoringRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisRequest.BuilderImpl
    implements Builder {
        private String streamName;
        private List<String> shardLevelMetrics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisableEnhancedMonitoringRequest model) {
            super(model);
            this.streamName(model.streamName);
            this.shardLevelMetricsWithStrings(model.shardLevelMetrics);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final Collection<String> getShardLevelMetrics() {
            if (this.shardLevelMetrics instanceof SdkAutoConstructList) {
                return null;
            }
            return this.shardLevelMetrics;
        }

        public final void setShardLevelMetrics(Collection<String> shardLevelMetrics) {
            this.shardLevelMetrics = MetricsNameListCopier.copy(shardLevelMetrics);
        }

        @Override
        public final Builder shardLevelMetricsWithStrings(Collection<String> shardLevelMetrics) {
            this.shardLevelMetrics = MetricsNameListCopier.copy(shardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shardLevelMetricsWithStrings(String ... shardLevelMetrics) {
            this.shardLevelMetricsWithStrings(Arrays.asList(shardLevelMetrics));
            return this;
        }

        @Override
        public final Builder shardLevelMetrics(Collection<MetricsName> shardLevelMetrics) {
            this.shardLevelMetrics = MetricsNameListCopier.copyEnumToString(shardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shardLevelMetrics(MetricsName ... shardLevelMetrics) {
            this.shardLevelMetrics(Arrays.asList(shardLevelMetrics));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisableEnhancedMonitoringRequest build() {
            return new DisableEnhancedMonitoringRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisableEnhancedMonitoringRequest> {
        public Builder streamName(String var1);

        public Builder shardLevelMetricsWithStrings(Collection<String> var1);

        public Builder shardLevelMetricsWithStrings(String ... var1);

        public Builder shardLevelMetrics(Collection<MetricsName> var1);

        public Builder shardLevelMetrics(MetricsName ... var1);

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

