/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.exception.AwsServiceException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.ApiName;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.RequestOverrideConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientOption;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.handler.SyncClientHandler;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.exception.SdkClientException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.http.HttpResponseHandler;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.metrics.CoreMetric;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.metrics.MetricCollector;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.metrics.MetricPublisher;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.metrics.NoOpMetricCollector;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.cbor.AwsCborProtocolFactory;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.core.ExceptionMetadata;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.KinesisClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.AddTagsToStreamRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.AddTagsToStreamResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.CreateStreamRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.CreateStreamResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DecreaseStreamRetentionPeriodRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DecreaseStreamRetentionPeriodResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DeleteStreamRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DeleteStreamResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DeregisterStreamConsumerRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DeregisterStreamConsumerResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DescribeLimitsRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DescribeLimitsResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DescribeStreamConsumerRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DescribeStreamConsumerResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DescribeStreamRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DescribeStreamResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DisableEnhancedMonitoringRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DisableEnhancedMonitoringResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.EnableEnhancedMonitoringRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.EnableEnhancedMonitoringResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ExpiredIteratorException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ExpiredNextTokenException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.GetRecordsRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.GetRecordsResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.GetShardIteratorRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.GetShardIteratorResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.IncreaseStreamRetentionPeriodRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.IncreaseStreamRetentionPeriodResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.InternalFailureException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.InvalidArgumentException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.KinesisException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.KmsAccessDeniedException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.KmsDisabledException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.KmsInvalidStateException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.KmsNotFoundException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.KmsOptInRequiredException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.KmsThrottlingException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.LimitExceededException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ListShardsRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ListShardsResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ListStreamConsumersRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ListStreamConsumersResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ListStreamsRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ListStreamsResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ListTagsForStreamRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ListTagsForStreamResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.MergeShardsRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.MergeShardsResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ProvisionedThroughputExceededException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.PutRecordRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.PutRecordResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.PutRecordsRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.PutRecordsResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.RegisterStreamConsumerRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.RegisterStreamConsumerResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.RemoveTagsFromStreamRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.RemoveTagsFromStreamResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ResourceInUseException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ResourceNotFoundException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.SplitShardRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.SplitShardResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.StartStreamEncryptionRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.StartStreamEncryptionResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.StopStreamEncryptionRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.StopStreamEncryptionResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.UpdateShardCountRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.UpdateShardCountResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.UpdateStreamModeRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.UpdateStreamModeResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ValidationException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.paginators.ListStreamConsumersIterable;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.AddTagsToStreamRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.CreateStreamRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.DecreaseStreamRetentionPeriodRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.DeleteStreamRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.DeregisterStreamConsumerRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.DescribeLimitsRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.DescribeStreamConsumerRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.DescribeStreamRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.DescribeStreamSummaryRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.DisableEnhancedMonitoringRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.EnableEnhancedMonitoringRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.GetRecordsRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.GetShardIteratorRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.IncreaseStreamRetentionPeriodRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.ListShardsRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.ListStreamConsumersRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.ListStreamsRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.ListTagsForStreamRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.MergeShardsRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.PutRecordRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.PutRecordsRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.RegisterStreamConsumerRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.RemoveTagsFromStreamRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.SplitShardRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.StartStreamEncryptionRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.StopStreamEncryptionRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.UpdateShardCountRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.transform.UpdateStreamModeRequestMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.waiters.KinesisWaiter;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultKinesisClient
implements KinesisClient {
    private static final Logger log = Logger.loggerFor(DefaultKinesisClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsCborProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultKinesisClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsCborProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return "kinesis";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddTagsToStreamResponse addTagsToStream(AddTagsToStreamRequest addTagsToStreamRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, LimitExceededException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddTagsToStreamResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(this.clientConfiguration, addTagsToStreamRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddTagsToStream");
            AddTagsToStreamResponse addTagsToStreamResponse = (AddTagsToStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddTagsToStream").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(addTagsToStreamRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new AddTagsToStreamRequestMarshaller(this.protocolFactory)));
            return addTagsToStreamResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateStreamResponse createStream(CreateStreamRequest createStreamRequest) throws ResourceInUseException, LimitExceededException, InvalidArgumentException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateStreamResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(this.clientConfiguration, createStreamRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStream");
            CreateStreamResponse createStreamResponse = (CreateStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateStream").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(createStreamRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new CreateStreamRequestMarshaller(this.protocolFactory)));
            return createStreamResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DecreaseStreamRetentionPeriodResponse decreaseStreamRetentionPeriod(DecreaseStreamRetentionPeriodRequest decreaseStreamRetentionPeriodRequest) throws ResourceInUseException, ResourceNotFoundException, LimitExceededException, InvalidArgumentException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DecreaseStreamRetentionPeriodResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(this.clientConfiguration, decreaseStreamRetentionPeriodRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DecreaseStreamRetentionPeriod");
            DecreaseStreamRetentionPeriodResponse decreaseStreamRetentionPeriodResponse = (DecreaseStreamRetentionPeriodResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DecreaseStreamRetentionPeriod").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(decreaseStreamRetentionPeriodRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DecreaseStreamRetentionPeriodRequestMarshaller(this.protocolFactory)));
            return decreaseStreamRetentionPeriodResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteStreamResponse deleteStream(DeleteStreamRequest deleteStreamRequest) throws ResourceNotFoundException, LimitExceededException, ResourceInUseException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteStreamResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(this.clientConfiguration, deleteStreamRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStream");
            DeleteStreamResponse deleteStreamResponse = (DeleteStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteStream").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(deleteStreamRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DeleteStreamRequestMarshaller(this.protocolFactory)));
            return deleteStreamResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeregisterStreamConsumerResponse deregisterStreamConsumer(DeregisterStreamConsumerRequest deregisterStreamConsumerRequest) throws LimitExceededException, ResourceNotFoundException, InvalidArgumentException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterStreamConsumerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(this.clientConfiguration, deregisterStreamConsumerRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterStreamConsumer");
            DeregisterStreamConsumerResponse deregisterStreamConsumerResponse = (DeregisterStreamConsumerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterStreamConsumer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(deregisterStreamConsumerRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DeregisterStreamConsumerRequestMarshaller(this.protocolFactory)));
            return deregisterStreamConsumerResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLimitsResponse describeLimits(DescribeLimitsRequest describeLimitsRequest) throws LimitExceededException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeLimitsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(this.clientConfiguration, describeLimitsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeLimits");
            DescribeLimitsResponse describeLimitsResponse = (DescribeLimitsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLimits").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(describeLimitsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DescribeLimitsRequestMarshaller(this.protocolFactory)));
            return describeLimitsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeStreamResponse describeStream(DescribeStreamRequest describeStreamRequest) throws ResourceNotFoundException, LimitExceededException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeStreamResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(this.clientConfiguration, describeStreamRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeStream");
            DescribeStreamResponse describeStreamResponse = (DescribeStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStream").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(describeStreamRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DescribeStreamRequestMarshaller(this.protocolFactory)));
            return describeStreamResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeStreamConsumerResponse describeStreamConsumer(DescribeStreamConsumerRequest describeStreamConsumerRequest) throws LimitExceededException, ResourceNotFoundException, InvalidArgumentException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeStreamConsumerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(this.clientConfiguration, describeStreamConsumerRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeStreamConsumer");
            DescribeStreamConsumerResponse describeStreamConsumerResponse = (DescribeStreamConsumerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStreamConsumer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(describeStreamConsumerRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DescribeStreamConsumerRequestMarshaller(this.protocolFactory)));
            return describeStreamConsumerResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeStreamSummaryResponse describeStreamSummary(DescribeStreamSummaryRequest describeStreamSummaryRequest) throws ResourceNotFoundException, LimitExceededException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeStreamSummaryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(this.clientConfiguration, describeStreamSummaryRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeStreamSummary");
            DescribeStreamSummaryResponse describeStreamSummaryResponse = (DescribeStreamSummaryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStreamSummary").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(describeStreamSummaryRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DescribeStreamSummaryRequestMarshaller(this.protocolFactory)));
            return describeStreamSummaryResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableEnhancedMonitoringResponse disableEnhancedMonitoring(DisableEnhancedMonitoringRequest disableEnhancedMonitoringRequest) throws InvalidArgumentException, LimitExceededException, ResourceInUseException, ResourceNotFoundException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableEnhancedMonitoringResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(this.clientConfiguration, disableEnhancedMonitoringRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableEnhancedMonitoring");
            DisableEnhancedMonitoringResponse disableEnhancedMonitoringResponse = (DisableEnhancedMonitoringResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableEnhancedMonitoring").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(disableEnhancedMonitoringRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DisableEnhancedMonitoringRequestMarshaller(this.protocolFactory)));
            return disableEnhancedMonitoringResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableEnhancedMonitoringResponse enableEnhancedMonitoring(EnableEnhancedMonitoringRequest enableEnhancedMonitoringRequest) throws InvalidArgumentException, LimitExceededException, ResourceInUseException, ResourceNotFoundException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableEnhancedMonitoringResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(this.clientConfiguration, enableEnhancedMonitoringRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableEnhancedMonitoring");
            EnableEnhancedMonitoringResponse enableEnhancedMonitoringResponse = (EnableEnhancedMonitoringResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableEnhancedMonitoring").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(enableEnhancedMonitoringRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new EnableEnhancedMonitoringRequestMarshaller(this.protocolFactory)));
            return enableEnhancedMonitoringResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRecordsResponse getRecords(GetRecordsRequest getRecordsRequest) throws ResourceNotFoundException, InvalidArgumentException, ProvisionedThroughputExceededException, ExpiredIteratorException, KmsDisabledException, KmsInvalidStateException, KmsAccessDeniedException, KmsNotFoundException, KmsOptInRequiredException, KmsThrottlingException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRecordsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(this.clientConfiguration, getRecordsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRecords");
            GetRecordsResponse getRecordsResponse = (GetRecordsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRecords").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getRecordsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetRecordsRequestMarshaller(this.protocolFactory)));
            return getRecordsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetShardIteratorResponse getShardIterator(GetShardIteratorRequest getShardIteratorRequest) throws ResourceNotFoundException, InvalidArgumentException, ProvisionedThroughputExceededException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetShardIteratorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(this.clientConfiguration, getShardIteratorRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetShardIterator");
            GetShardIteratorResponse getShardIteratorResponse = (GetShardIteratorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetShardIterator").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getShardIteratorRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetShardIteratorRequestMarshaller(this.protocolFactory)));
            return getShardIteratorResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IncreaseStreamRetentionPeriodResponse increaseStreamRetentionPeriod(IncreaseStreamRetentionPeriodRequest increaseStreamRetentionPeriodRequest) throws ResourceInUseException, ResourceNotFoundException, LimitExceededException, InvalidArgumentException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, IncreaseStreamRetentionPeriodResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(this.clientConfiguration, increaseStreamRetentionPeriodRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "IncreaseStreamRetentionPeriod");
            IncreaseStreamRetentionPeriodResponse increaseStreamRetentionPeriodResponse = (IncreaseStreamRetentionPeriodResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("IncreaseStreamRetentionPeriod").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(increaseStreamRetentionPeriodRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new IncreaseStreamRetentionPeriodRequestMarshaller(this.protocolFactory)));
            return increaseStreamRetentionPeriodResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListShardsResponse listShards(ListShardsRequest listShardsRequest) throws ResourceNotFoundException, InvalidArgumentException, LimitExceededException, ExpiredNextTokenException, ResourceInUseException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListShardsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(this.clientConfiguration, listShardsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListShards");
            ListShardsResponse listShardsResponse = (ListShardsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListShards").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(listShardsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListShardsRequestMarshaller(this.protocolFactory)));
            return listShardsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListStreamConsumersResponse listStreamConsumers(ListStreamConsumersRequest listStreamConsumersRequest) throws ResourceNotFoundException, InvalidArgumentException, LimitExceededException, ExpiredNextTokenException, ResourceInUseException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListStreamConsumersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(this.clientConfiguration, listStreamConsumersRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStreamConsumers");
            ListStreamConsumersResponse listStreamConsumersResponse = (ListStreamConsumersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListStreamConsumers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(listStreamConsumersRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListStreamConsumersRequestMarshaller(this.protocolFactory)));
            return listStreamConsumersResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListStreamConsumersIterable listStreamConsumersPaginator(ListStreamConsumersRequest listStreamConsumersRequest) throws ResourceNotFoundException, InvalidArgumentException, LimitExceededException, ExpiredNextTokenException, ResourceInUseException, AwsServiceException, SdkClientException, KinesisException {
        return new ListStreamConsumersIterable(this, this.applyPaginatorUserAgent(listStreamConsumersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListStreamsResponse listStreams(ListStreamsRequest listStreamsRequest) throws LimitExceededException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListStreamsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(this.clientConfiguration, listStreamsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStreams");
            ListStreamsResponse listStreamsResponse = (ListStreamsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListStreams").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(listStreamsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListStreamsRequestMarshaller(this.protocolFactory)));
            return listStreamsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForStreamResponse listTagsForStream(ListTagsForStreamRequest listTagsForStreamRequest) throws ResourceNotFoundException, InvalidArgumentException, LimitExceededException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForStreamResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(this.clientConfiguration, listTagsForStreamRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForStream");
            ListTagsForStreamResponse listTagsForStreamResponse = (ListTagsForStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForStream").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(listTagsForStreamRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListTagsForStreamRequestMarshaller(this.protocolFactory)));
            return listTagsForStreamResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MergeShardsResponse mergeShards(MergeShardsRequest mergeShardsRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, LimitExceededException, ValidationException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, MergeShardsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(this.clientConfiguration, mergeShardsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "MergeShards");
            MergeShardsResponse mergeShardsResponse = (MergeShardsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("MergeShards").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(mergeShardsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new MergeShardsRequestMarshaller(this.protocolFactory)));
            return mergeShardsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutRecordResponse putRecord(PutRecordRequest putRecordRequest) throws ResourceNotFoundException, InvalidArgumentException, ProvisionedThroughputExceededException, KmsDisabledException, KmsInvalidStateException, KmsAccessDeniedException, KmsNotFoundException, KmsOptInRequiredException, KmsThrottlingException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutRecordResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(this.clientConfiguration, putRecordRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutRecord");
            PutRecordResponse putRecordResponse = (PutRecordResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutRecord").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(putRecordRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new PutRecordRequestMarshaller(this.protocolFactory)));
            return putRecordResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutRecordsResponse putRecords(PutRecordsRequest putRecordsRequest) throws ResourceNotFoundException, InvalidArgumentException, ProvisionedThroughputExceededException, KmsDisabledException, KmsInvalidStateException, KmsAccessDeniedException, KmsNotFoundException, KmsOptInRequiredException, KmsThrottlingException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutRecordsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(this.clientConfiguration, putRecordsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutRecords");
            PutRecordsResponse putRecordsResponse = (PutRecordsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutRecords").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(putRecordsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new PutRecordsRequestMarshaller(this.protocolFactory)));
            return putRecordsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterStreamConsumerResponse registerStreamConsumer(RegisterStreamConsumerRequest registerStreamConsumerRequest) throws InvalidArgumentException, LimitExceededException, ResourceInUseException, ResourceNotFoundException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterStreamConsumerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(this.clientConfiguration, registerStreamConsumerRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterStreamConsumer");
            RegisterStreamConsumerResponse registerStreamConsumerResponse = (RegisterStreamConsumerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterStreamConsumer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(registerStreamConsumerRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new RegisterStreamConsumerRequestMarshaller(this.protocolFactory)));
            return registerStreamConsumerResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveTagsFromStreamResponse removeTagsFromStream(RemoveTagsFromStreamRequest removeTagsFromStreamRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, LimitExceededException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveTagsFromStreamResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(this.clientConfiguration, removeTagsFromStreamRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveTagsFromStream");
            RemoveTagsFromStreamResponse removeTagsFromStreamResponse = (RemoveTagsFromStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveTagsFromStream").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(removeTagsFromStreamRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new RemoveTagsFromStreamRequestMarshaller(this.protocolFactory)));
            return removeTagsFromStreamResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SplitShardResponse splitShard(SplitShardRequest splitShardRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, LimitExceededException, ValidationException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SplitShardResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(this.clientConfiguration, splitShardRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SplitShard");
            SplitShardResponse splitShardResponse = (SplitShardResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SplitShard").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(splitShardRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new SplitShardRequestMarshaller(this.protocolFactory)));
            return splitShardResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartStreamEncryptionResponse startStreamEncryption(StartStreamEncryptionRequest startStreamEncryptionRequest) throws InvalidArgumentException, LimitExceededException, ResourceInUseException, ResourceNotFoundException, KmsDisabledException, KmsInvalidStateException, KmsAccessDeniedException, KmsNotFoundException, KmsOptInRequiredException, KmsThrottlingException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartStreamEncryptionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(this.clientConfiguration, startStreamEncryptionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartStreamEncryption");
            StartStreamEncryptionResponse startStreamEncryptionResponse = (StartStreamEncryptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartStreamEncryption").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(startStreamEncryptionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new StartStreamEncryptionRequestMarshaller(this.protocolFactory)));
            return startStreamEncryptionResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopStreamEncryptionResponse stopStreamEncryption(StopStreamEncryptionRequest stopStreamEncryptionRequest) throws InvalidArgumentException, LimitExceededException, ResourceInUseException, ResourceNotFoundException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopStreamEncryptionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(this.clientConfiguration, stopStreamEncryptionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopStreamEncryption");
            StopStreamEncryptionResponse stopStreamEncryptionResponse = (StopStreamEncryptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopStreamEncryption").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(stopStreamEncryptionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new StopStreamEncryptionRequestMarshaller(this.protocolFactory)));
            return stopStreamEncryptionResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateShardCountResponse updateShardCount(UpdateShardCountRequest updateShardCountRequest) throws InvalidArgumentException, LimitExceededException, ResourceInUseException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateShardCountResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(this.clientConfiguration, updateShardCountRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateShardCount");
            UpdateShardCountResponse updateShardCountResponse = (UpdateShardCountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateShardCount").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(updateShardCountRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new UpdateShardCountRequestMarshaller(this.protocolFactory)));
            return updateShardCountResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateStreamModeResponse updateStreamMode(UpdateStreamModeRequest updateStreamModeRequest) throws InvalidArgumentException, LimitExceededException, ResourceInUseException, ResourceNotFoundException, AwsServiceException, SdkClientException, KinesisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateStreamModeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisClient.resolveMetricPublishers(this.clientConfiguration, updateStreamModeRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Kinesis");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateStreamMode");
            UpdateStreamModeResponse updateStreamModeResponse = (UpdateStreamModeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateStreamMode").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(updateStreamModeRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new UpdateStreamModeRequestMarshaller(this.protocolFactory)));
            return updateStreamModeResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return ((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)builder.clientConfiguration(this.clientConfiguration)).defaultServiceExceptionSupplier(KinesisException::builder)).protocol(AwsJsonProtocol.AWS_JSON)).protocolVersion("1.1")).registerModeledException(ExceptionMetadata.builder().errorCode("KMSThrottlingException").exceptionBuilderSupplier(KmsThrottlingException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("InternalFailureException").exceptionBuilderSupplier(InternalFailureException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceInUseException").exceptionBuilderSupplier(ResourceInUseException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").exceptionBuilderSupplier(KmsInvalidStateException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("KMSNotFoundException").exceptionBuilderSupplier(KmsNotFoundException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("ExpiredIteratorException").exceptionBuilderSupplier(ExpiredIteratorException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("KMSOptInRequired").exceptionBuilderSupplier(KmsOptInRequiredException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("ExpiredNextTokenException").exceptionBuilderSupplier(ExpiredNextTokenException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidArgumentException").exceptionBuilderSupplier(InvalidArgumentException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("KMSAccessDeniedException").exceptionBuilderSupplier(KmsAccessDeniedException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("KMSDisabledException").exceptionBuilderSupplier(KmsDisabledException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
    }

    @Override
    public void close() {
        this.clientHandler.close();
    }

    private <T extends KinesisRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.17.247").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build());
        return (T)((KinesisRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build());
    }

    @Override
    public KinesisWaiter waiter() {
        return KinesisWaiter.builder().client(this).build();
    }
}

