/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.query.internal.unmarshall;

import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkBytes;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkField;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkPojo;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallingType;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.traits.PayloadTrait;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.SdkHttpFullResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.core.StringToInstant;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.core.StringToValueConverter;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.query.internal.marshall.SimpleTypeQueryMarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.query.internal.unmarshall.ListQueryUnmarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.query.internal.unmarshall.MapQueryUnmarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.query.internal.unmarshall.QueryUnmarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.query.internal.unmarshall.QueryUnmarshallerContext;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.query.internal.unmarshall.QueryUnmarshallerRegistry;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.query.internal.unmarshall.SimpleTypeQueryUnmarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.query.unmarshall.XmlDomParser;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.query.unmarshall.XmlElement;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.query.unmarshall.XmlErrorUnmarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.CollectionUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.FunctionalUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.IoUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.Pair;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.builder.Buildable;

@SdkInternalApi
public final class QueryProtocolUnmarshaller
implements XmlErrorUnmarshaller {
    private static final QueryUnmarshallerRegistry UNMARSHALLER_REGISTRY = QueryUnmarshallerRegistry.builder().unmarshaller(MarshallingType.STRING, new SimpleTypeQueryUnmarshaller<String>(StringToValueConverter.TO_STRING)).unmarshaller(MarshallingType.INTEGER, new SimpleTypeQueryUnmarshaller<Integer>(StringToValueConverter.TO_INTEGER)).unmarshaller(MarshallingType.LONG, new SimpleTypeQueryUnmarshaller<Long>(StringToValueConverter.TO_LONG)).unmarshaller(MarshallingType.SHORT, new SimpleTypeQueryUnmarshaller<Short>(StringToValueConverter.TO_SHORT)).unmarshaller(MarshallingType.FLOAT, new SimpleTypeQueryUnmarshaller<Float>(StringToValueConverter.TO_FLOAT)).unmarshaller(MarshallingType.DOUBLE, new SimpleTypeQueryUnmarshaller<Double>(StringToValueConverter.TO_DOUBLE)).unmarshaller(MarshallingType.BOOLEAN, new SimpleTypeQueryUnmarshaller<Boolean>(StringToValueConverter.TO_BOOLEAN)).unmarshaller(MarshallingType.DOUBLE, new SimpleTypeQueryUnmarshaller<Double>(StringToValueConverter.TO_DOUBLE)).unmarshaller(MarshallingType.INSTANT, new SimpleTypeQueryUnmarshaller<Instant>(StringToInstant.create(SimpleTypeQueryMarshaller.defaultTimestampFormats()))).unmarshaller(MarshallingType.SDK_BYTES, new SimpleTypeQueryUnmarshaller<SdkBytes>(StringToValueConverter.TO_SDK_BYTES)).unmarshaller(MarshallingType.LIST, new ListQueryUnmarshaller()).unmarshaller(MarshallingType.MAP, new MapQueryUnmarshaller()).unmarshaller(MarshallingType.NULL, (context, content, field) -> null).unmarshaller(MarshallingType.SDK_POJO, (context, content, field) -> context.protocolUnmarshaller().unmarshall(context, field.constructor().get(), (XmlElement)content.get(0))).build();
    private final boolean hasResultWrapper;

    private QueryProtocolUnmarshaller(Builder builder) {
        this.hasResultWrapper = builder.hasResultWrapper;
    }

    public <TypeT extends SdkPojo> Pair<TypeT, Map<String, String>> unmarshall(SdkPojo sdkPojo, SdkHttpFullResponse response) {
        if (this.responsePayloadIsBlob(sdkPojo)) {
            XmlElement document = XmlElement.builder().textContent(response.content().map(s -> FunctionalUtils.invokeSafely(() -> IoUtils.toUtf8String(s))).orElse("")).build();
            return Pair.of(this.unmarshall(sdkPojo, document, response), new HashMap());
        }
        XmlElement document = response.content().map(XmlDomParser::parse).orElseGet(XmlElement::empty);
        XmlElement resultRoot = this.hasResultWrapper ? document.getFirstChild() : document;
        return Pair.of(this.unmarshall(sdkPojo, resultRoot, response), this.parseMetadata(document));
    }

    private boolean responsePayloadIsBlob(SdkPojo sdkPojo) {
        return sdkPojo.sdkFields().stream().anyMatch(field -> field.marshallingType() == MarshallingType.SDK_BYTES && field.containsTrait(PayloadTrait.class));
    }

    @Override
    public <TypeT extends SdkPojo> TypeT unmarshall(SdkPojo sdkPojo, XmlElement resultRoot, SdkHttpFullResponse response) {
        QueryUnmarshallerContext unmarshallerContext = QueryUnmarshallerContext.builder().registry(UNMARSHALLER_REGISTRY).protocolUnmarshaller(this).build();
        return (TypeT)this.unmarshall(unmarshallerContext, sdkPojo, resultRoot);
    }

    private Map<String, String> parseMetadata(XmlElement document) {
        XmlElement requestId;
        XmlElement responseMetadata = document.getElementByName("ResponseMetadata");
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (responseMetadata != null) {
            responseMetadata.children().forEach(c -> metadata.put(this.metadataKeyName((XmlElement)c), c.textContent()));
        }
        if ((requestId = document.getElementByName("requestId")) != null) {
            metadata.put("AWS_REQUEST_ID", requestId.textContent());
        }
        return metadata;
    }

    private String metadataKeyName(XmlElement c) {
        return c.elementName().equals("RequestId") ? "AWS_REQUEST_ID" : c.elementName();
    }

    private SdkPojo unmarshall(QueryUnmarshallerContext context, SdkPojo sdkPojo, XmlElement root) {
        if (root != null) {
            for (SdkField<?> field : sdkPojo.sdkFields()) {
                List<XmlElement> element;
                if (field.containsTrait(PayloadTrait.class) && field.marshallingType() == MarshallingType.SDK_BYTES) {
                    field.set(sdkPojo, SdkBytes.fromUtf8String(root.textContent()));
                }
                if (CollectionUtils.isNullOrEmpty(element = root.getElementsByName(field.unmarshallLocationName()))) continue;
                QueryUnmarshaller<Object> unmarshaller = UNMARSHALLER_REGISTRY.getUnmarshaller(field.location(), field.marshallingType());
                Object unmarshalled = unmarshaller.unmarshall(context, element, field);
                field.set(sdkPojo, unmarshalled);
            }
        }
        return (SdkPojo)((Buildable)((Object)sdkPojo)).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private boolean hasResultWrapper;

        private Builder() {
        }

        public Builder hasResultWrapper(boolean hasResultWrapper) {
            this.hasResultWrapper = hasResultWrapper;
            return this;
        }

        public QueryProtocolUnmarshaller build() {
            return new QueryProtocolUnmarshaller(this);
        }
    }
}

