/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.json.internal.unmarshall;

import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallLocation;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallingType;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.SdkHttpFullResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.json.internal.MarshallerUtil;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.json.internal.unmarshall.JsonUnmarshaller;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.json.internal.unmarshall.JsonUnmarshallerRegistry;

@SdkInternalApi
public final class JsonUnmarshallerContext {
    private final SdkHttpFullResponse response;
    private final JsonUnmarshallerRegistry unmarshallerRegistry;

    private JsonUnmarshallerContext(Builder builder) {
        this.response = builder.response;
        this.unmarshallerRegistry = builder.unmarshallerRegistry;
    }

    public SdkHttpFullResponse response() {
        return this.response;
    }

    public JsonUnmarshaller<Object> getUnmarshaller(MarshallLocation location, MarshallingType<?> marshallingType) {
        if (MarshallerUtil.locationInUri(location)) {
            location = MarshallLocation.PAYLOAD;
        }
        return this.unmarshallerRegistry.getUnmarshaller(location, marshallingType);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private SdkHttpFullResponse response;
        private JsonUnmarshallerRegistry unmarshallerRegistry;

        private Builder() {
        }

        public Builder response(SdkHttpFullResponse response) {
            this.response = response;
            return this;
        }

        public Builder unmarshallerRegistry(JsonUnmarshallerRegistry unmarshallerRegistry) {
            this.unmarshallerRegistry = unmarshallerRegistry;
            return this;
        }

        public JsonUnmarshallerContext build() {
            return new JsonUnmarshallerContext(this);
        }
    }
}

