/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal;

import java.util.concurrent.TimeUnit;
import org.apache.flink.kinesis.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.kinesis.shaded.io.netty.handler.timeout.IdleStateEvent;
import org.apache.flink.kinesis.shaded.io.netty.handler.timeout.IdleStateHandler;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.ChannelAttributeKey;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.utils.NettyClientLogger;

@SdkInternalApi
public class IdleConnectionReaperHandler
extends IdleStateHandler {
    private static final NettyClientLogger log = NettyClientLogger.getLogger(IdleConnectionReaperHandler.class);
    private final int maxIdleTimeMillis;

    public IdleConnectionReaperHandler(int maxIdleTimeMillis) {
        super(0L, 0L, maxIdleTimeMillis, TimeUnit.MILLISECONDS);
        this.maxIdleTimeMillis = maxIdleTimeMillis;
    }

    @Override
    protected void channelIdle(ChannelHandlerContext ctx, IdleStateEvent event) {
        assert (ctx.channel().eventLoop().inEventLoop());
        boolean channelNotInUse = Boolean.FALSE.equals(ctx.channel().attr(ChannelAttributeKey.IN_USE).get());
        if (channelNotInUse && ctx.channel().isOpen()) {
            log.debug(ctx.channel(), () -> "Closing unused connection (" + ctx.channel().id() + ") because it has been idle for longer than " + this.maxIdleTimeMillis + " milliseconds.");
            ctx.close();
        }
    }
}

