/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.http;

import java.io.FilterInputStream;
import java.io.InputStream;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkProtectedApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkTestInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.Abortable;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.Validate;

@SdkProtectedApi
public final class AbortableInputStream
extends FilterInputStream
implements Abortable {
    private final Abortable abortable;

    private AbortableInputStream(InputStream delegate, Abortable abortable) {
        super(Validate.paramNotNull(delegate, "delegate"));
        this.abortable = Validate.paramNotNull(abortable, "abortable");
    }

    public static AbortableInputStream create(InputStream delegate, Abortable abortable) {
        return new AbortableInputStream(delegate, abortable);
    }

    public static AbortableInputStream create(InputStream delegate) {
        if (delegate instanceof Abortable) {
            return new AbortableInputStream(delegate, (Abortable)((Object)delegate));
        }
        return new AbortableInputStream(delegate, () -> {});
    }

    @Override
    public void abort() {
        this.abortable.abort();
    }

    @SdkTestInternalApi
    public InputStream delegate() {
        return this.in;
    }
}

