/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.pipeline.stages;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.async.AsyncRequestBody;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.http.ExecutionContext;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.InterceptorContext;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.HttpClientDependencies;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.RequestExecutionContext;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.pipeline.RequestPipeline;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.metrics.CoreMetric;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.signer.AsyncRequestBodySigner;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.signer.AsyncSigner;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.signer.Signer;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.SdkHttpFullRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.metrics.MetricCollector;

@SdkInternalApi
public class AsyncSigningStage
implements RequestPipeline<SdkHttpFullRequest, CompletableFuture<SdkHttpFullRequest>> {
    private final HttpClientDependencies dependencies;

    public AsyncSigningStage(HttpClientDependencies dependencies) {
        this.dependencies = dependencies;
    }

    @Override
    public CompletableFuture<SdkHttpFullRequest> execute(SdkHttpFullRequest request, RequestExecutionContext context) throws Exception {
        return this.signRequest(request, context);
    }

    private CompletableFuture<SdkHttpFullRequest> signRequest(SdkHttpFullRequest request, RequestExecutionContext context) {
        this.updateInterceptorContext(request, context.executionContext());
        Signer signer = context.signer();
        MetricCollector metricCollector = context.attemptMetricCollector();
        if (!this.shouldSign(signer)) {
            return CompletableFuture.completedFuture(request);
        }
        this.adjustForClockSkew(context.executionAttributes());
        AsyncSigner asyncSigner = this.asAsyncSigner(signer, context);
        long signingStart = System.nanoTime();
        CompletableFuture<SdkHttpFullRequest> signedRequestFuture = asyncSigner.sign(request, context.requestProvider(), context.executionAttributes());
        signedRequestFuture.whenComplete((r, t) -> metricCollector.reportMetric(CoreMetric.SIGNING_DURATION, Duration.ofNanos(System.nanoTime() - signingStart)));
        return signedRequestFuture.thenApply(r -> {
            this.updateInterceptorContext((SdkHttpFullRequest)r, context.executionContext());
            return r;
        });
    }

    private void updateInterceptorContext(SdkHttpFullRequest request, ExecutionContext executionContext) {
        executionContext.interceptorContext((InterceptorContext)executionContext.interceptorContext().copy(b -> b.httpRequest(request)));
    }

    private boolean shouldSign(Signer signer) {
        return signer != null;
    }

    private void adjustForClockSkew(ExecutionAttributes attributes) {
        attributes.putAttribute(SdkExecutionAttribute.TIME_OFFSET, this.dependencies.timeOffset());
    }

    private AsyncSigner asAsyncSigner(Signer signer, RequestExecutionContext context) {
        if (signer instanceof AsyncSigner) {
            return (AsyncSigner)((Object)signer);
        }
        return (request, requestBody, executionAttributes) -> {
            SdkHttpFullRequest signedRequest = signer.sign(request, executionAttributes);
            if (signer instanceof AsyncRequestBodySigner) {
                AsyncRequestBody transformedRequestProvider = ((AsyncRequestBodySigner)((Object)signer)).signAsyncRequestBody(signedRequest, context.requestProvider(), context.executionAttributes());
                context.requestProvider(transformedRequestProvider);
            }
            return CompletableFuture.completedFuture(signedRequest);
        };
    }
}

