/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.pipeline.stages;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.RequestExecutionContext;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.pipeline.RequestPipeline;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.SdkHttpFullRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
public class AsyncBeforeTransmissionExecutionInterceptorsStage
implements RequestPipeline<CompletableFuture<SdkHttpFullRequest>, CompletableFuture<SdkHttpFullRequest>> {
    @Override
    public CompletableFuture<SdkHttpFullRequest> execute(CompletableFuture<SdkHttpFullRequest> input, RequestExecutionContext context) throws Exception {
        CompletableFuture future = new CompletableFuture();
        input.whenComplete((r, t) -> {
            if (t != null) {
                return;
            }
            try {
                context.interceptorChain().beforeTransmission(context.executionContext().interceptorContext(), context.executionAttributes());
                future.complete(r);
            }
            catch (Throwable interceptorException) {
                future.completeExceptionally(interceptorException);
            }
        });
        return CompletableFutureUtils.forwardExceptionTo(future, input);
    }
}

