/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.core;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.Immutable;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkPublicApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.ApiName;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.ExecutionAttribute;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.signer.Signer;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.metrics.MetricPublisher;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.CollectionUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.Validate;

@Immutable
@SdkPublicApi
public abstract class RequestOverrideConfiguration {
    private final Map<String, List<String>> headers;
    private final Map<String, List<String>> rawQueryParameters;
    private final List<ApiName> apiNames;
    private final Duration apiCallTimeout;
    private final Duration apiCallAttemptTimeout;
    private final Signer signer;
    private final List<MetricPublisher> metricPublishers;
    private final ExecutionAttributes executionAttributes;

    protected RequestOverrideConfiguration(Builder<?> builder) {
        this.headers = CollectionUtils.deepUnmodifiableMap(builder.headers(), () -> new TreeMap(String.CASE_INSENSITIVE_ORDER));
        this.rawQueryParameters = CollectionUtils.deepUnmodifiableMap(builder.rawQueryParameters());
        this.apiNames = Collections.unmodifiableList(new ArrayList<ApiName>(builder.apiNames()));
        this.apiCallTimeout = Validate.isPositiveOrNull(builder.apiCallTimeout(), "apiCallTimeout");
        this.apiCallAttemptTimeout = Validate.isPositiveOrNull(builder.apiCallAttemptTimeout(), "apiCallAttemptTimeout");
        this.signer = builder.signer();
        this.metricPublishers = Collections.unmodifiableList(new ArrayList<MetricPublisher>(builder.metricPublishers()));
        this.executionAttributes = ExecutionAttributes.unmodifiableExecutionAttributes(builder.executionAttributes());
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public Map<String, List<String>> rawQueryParameters() {
        return this.rawQueryParameters;
    }

    public List<ApiName> apiNames() {
        return this.apiNames;
    }

    public Optional<Duration> apiCallTimeout() {
        return Optional.ofNullable(this.apiCallTimeout);
    }

    public Optional<Duration> apiCallAttemptTimeout() {
        return Optional.ofNullable(this.apiCallAttemptTimeout);
    }

    public Optional<Signer> signer() {
        return Optional.ofNullable(this.signer);
    }

    public List<MetricPublisher> metricPublishers() {
        return this.metricPublishers;
    }

    public ExecutionAttributes executionAttributes() {
        return this.executionAttributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestOverrideConfiguration that = (RequestOverrideConfiguration)o;
        return Objects.equals(this.headers, that.headers) && Objects.equals(this.rawQueryParameters, that.rawQueryParameters) && Objects.equals(this.apiNames, that.apiNames) && Objects.equals(this.apiCallTimeout, that.apiCallTimeout) && Objects.equals(this.apiCallAttemptTimeout, that.apiCallAttemptTimeout) && Objects.equals(this.signer, that.signer) && Objects.equals(this.metricPublishers, that.metricPublishers) && Objects.equals(this.executionAttributes, that.executionAttributes);
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.headers);
        hashCode = 31 * hashCode + Objects.hashCode(this.rawQueryParameters);
        hashCode = 31 * hashCode + Objects.hashCode(this.apiNames);
        hashCode = 31 * hashCode + Objects.hashCode(this.apiCallTimeout);
        hashCode = 31 * hashCode + Objects.hashCode(this.apiCallAttemptTimeout);
        hashCode = 31 * hashCode + Objects.hashCode(this.signer);
        hashCode = 31 * hashCode + Objects.hashCode(this.metricPublishers);
        hashCode = 31 * hashCode + Objects.hashCode(this.executionAttributes);
        return hashCode;
    }

    public abstract Builder<? extends Builder> toBuilder();

    protected static abstract class BuilderImpl<B extends Builder>
    implements Builder<B> {
        private Map<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        private Map<String, List<String>> rawQueryParameters = new HashMap<String, List<String>>();
        private List<ApiName> apiNames = new ArrayList<ApiName>();
        private Duration apiCallTimeout;
        private Duration apiCallAttemptTimeout;
        private Signer signer;
        private List<MetricPublisher> metricPublishers = new ArrayList<MetricPublisher>();
        private ExecutionAttributes.Builder executionAttributesBuilder = ExecutionAttributes.builder();

        protected BuilderImpl() {
        }

        protected BuilderImpl(RequestOverrideConfiguration sdkRequestOverrideConfig) {
            this.headers(sdkRequestOverrideConfig.headers);
            this.rawQueryParameters(sdkRequestOverrideConfig.rawQueryParameters);
            sdkRequestOverrideConfig.apiNames.forEach(this::addApiName);
            this.apiCallTimeout(sdkRequestOverrideConfig.apiCallTimeout);
            this.apiCallAttemptTimeout(sdkRequestOverrideConfig.apiCallAttemptTimeout);
            this.signer(sdkRequestOverrideConfig.signer().orElse(null));
            this.metricPublishers(sdkRequestOverrideConfig.metricPublishers());
            this.executionAttributes(sdkRequestOverrideConfig.executionAttributes());
        }

        @Override
        public Map<String, List<String>> headers() {
            return CollectionUtils.unmodifiableMapOfLists(this.headers);
        }

        @Override
        public B putHeader(String name, List<String> values) {
            Validate.paramNotNull(values, "values");
            this.headers.put(name, new ArrayList<String>(values));
            return (B)this;
        }

        @Override
        public B headers(Map<String, List<String>> headers) {
            Validate.paramNotNull(headers, "headers");
            this.headers = CollectionUtils.deepCopyMap(headers);
            return (B)this;
        }

        @Override
        public Map<String, List<String>> rawQueryParameters() {
            return CollectionUtils.unmodifiableMapOfLists(this.rawQueryParameters);
        }

        @Override
        public B putRawQueryParameter(String name, List<String> values) {
            Validate.paramNotNull(name, "name");
            Validate.paramNotNull(values, "values");
            this.rawQueryParameters.put(name, new ArrayList<String>(values));
            return (B)this;
        }

        @Override
        public B rawQueryParameters(Map<String, List<String>> rawQueryParameters) {
            Validate.paramNotNull(rawQueryParameters, "rawQueryParameters");
            this.rawQueryParameters = CollectionUtils.deepCopyMap(rawQueryParameters);
            return (B)this;
        }

        @Override
        public List<ApiName> apiNames() {
            return Collections.unmodifiableList(this.apiNames);
        }

        @Override
        public B addApiName(ApiName apiName) {
            this.apiNames.add(apiName);
            return (B)this;
        }

        @Override
        public B addApiName(Consumer<ApiName.Builder> apiNameConsumer) {
            ApiName.Builder b = ApiName.builder();
            apiNameConsumer.accept(b);
            this.addApiName(b.build());
            return (B)this;
        }

        @Override
        public B apiCallTimeout(Duration apiCallTimeout) {
            this.apiCallTimeout = apiCallTimeout;
            return (B)this;
        }

        public void setApiCallTimeout(Duration apiCallTimeout) {
            this.apiCallTimeout(apiCallTimeout);
        }

        @Override
        public Duration apiCallTimeout() {
            return this.apiCallTimeout;
        }

        @Override
        public B apiCallAttemptTimeout(Duration apiCallAttemptTimeout) {
            this.apiCallAttemptTimeout = apiCallAttemptTimeout;
            return (B)this;
        }

        public void setApiCallAttemptTimeout(Duration apiCallAttemptTimeout) {
            this.apiCallAttemptTimeout(apiCallAttemptTimeout);
        }

        @Override
        public Duration apiCallAttemptTimeout() {
            return this.apiCallAttemptTimeout;
        }

        @Override
        public B signer(Signer signer) {
            this.signer = signer;
            return (B)this;
        }

        public void setSigner(Signer signer) {
            this.signer(signer);
        }

        @Override
        public Signer signer() {
            return this.signer;
        }

        @Override
        public B metricPublishers(List<MetricPublisher> metricPublishers) {
            Validate.paramNotNull(metricPublishers, "metricPublishers");
            this.metricPublishers = new ArrayList<MetricPublisher>(metricPublishers);
            return (B)this;
        }

        @Override
        public B addMetricPublisher(MetricPublisher metricPublisher) {
            Validate.paramNotNull(metricPublisher, "metricPublisher");
            this.metricPublishers.add(metricPublisher);
            return (B)this;
        }

        public void setMetricPublishers(List<MetricPublisher> metricPublishers) {
            this.metricPublishers(metricPublishers);
        }

        @Override
        public List<MetricPublisher> metricPublishers() {
            return this.metricPublishers;
        }

        @Override
        public B executionAttributes(ExecutionAttributes executionAttributes) {
            Validate.paramNotNull(executionAttributes, "executionAttributes");
            this.executionAttributesBuilder = executionAttributes.toBuilder();
            return (B)this;
        }

        @Override
        public <T> B putExecutionAttribute(ExecutionAttribute<T> executionAttribute, T value) {
            this.executionAttributesBuilder.put(executionAttribute, value);
            return (B)this;
        }

        @Override
        public ExecutionAttributes executionAttributes() {
            return this.executionAttributesBuilder.build();
        }

        public void setExecutionAttributes(ExecutionAttributes executionAttributes) {
            this.executionAttributes(executionAttributes);
        }
    }

    public static interface Builder<B extends Builder> {
        public Map<String, List<String>> headers();

        default public B putHeader(String name, String value) {
            this.putHeader(name, Collections.singletonList(value));
            return (B)this;
        }

        public B putHeader(String var1, List<String> var2);

        public B headers(Map<String, List<String>> var1);

        public Map<String, List<String>> rawQueryParameters();

        default public B putRawQueryParameter(String name, String value) {
            this.putRawQueryParameter(name, Collections.singletonList(value));
            return (B)this;
        }

        public B putRawQueryParameter(String var1, List<String> var2);

        public B rawQueryParameters(Map<String, List<String>> var1);

        public List<ApiName> apiNames();

        public B addApiName(ApiName var1);

        public B addApiName(Consumer<ApiName.Builder> var1);

        public B apiCallTimeout(Duration var1);

        public Duration apiCallTimeout();

        public B apiCallAttemptTimeout(Duration var1);

        public Duration apiCallAttemptTimeout();

        public B signer(Signer var1);

        public Signer signer();

        public B metricPublishers(List<MetricPublisher> var1);

        public B addMetricPublisher(MetricPublisher var1);

        public List<MetricPublisher> metricPublishers();

        public B executionAttributes(ExecutionAttributes var1);

        public <T> B putExecutionAttribute(ExecutionAttribute<T> var1, T var2);

        public ExecutionAttributes executionAttributes();

        public RequestOverrideConfiguration build();
    }
}

