/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesisanalytics.model.transform;

import org.apache.flink.kinesis.shaded.com.amazonaws.SdkClientException;
import org.apache.flink.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.MarshallLocation;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.MarshallingInfo;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.MarshallingType;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesisanalytics.model.DestinationSchema;

@SdkInternalApi
public class DestinationSchemaMarshaller {
    private static final MarshallingInfo<String> RECORDFORMATTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecordFormatType").build();
    private static final DestinationSchemaMarshaller instance = new DestinationSchemaMarshaller();

    public static DestinationSchemaMarshaller getInstance() {
        return instance;
    }

    public void marshall(DestinationSchema destinationSchema, ProtocolMarshaller protocolMarshaller) {
        if (destinationSchema == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(destinationSchema.getRecordFormatType(), RECORDFORMATTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

