/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.metrics.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.MetricDatum;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.StandardUnit;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.StatisticSet;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.metrics.impl.EndingMetricsScope;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.metrics.interfaces.MetricsLevel;

public abstract class AccumulatingMetricsScope<KeyType>
extends EndingMetricsScope {
    protected Map<KeyType, MetricDatum> data = new HashMap<KeyType, MetricDatum>();

    @Override
    public void addData(String name, double value, StandardUnit unit) {
        this.addData(this.getKey(name), name, value, unit);
    }

    @Override
    public void addData(String name, double value, StandardUnit unit, MetricsLevel level) {
        this.addData(this.getKey(name), name, value, unit);
    }

    protected abstract KeyType getKey(String var1);

    public void addData(KeyType key, String name, double value, StandardUnit unit) {
        super.addData(name, value, unit);
        MetricDatum datum = this.data.get(key);
        if (datum == null) {
            this.data.put(key, new MetricDatum().withMetricName(name).withUnit(unit).withStatisticValues(new StatisticSet().withMaximum(value).withMinimum(value).withSampleCount(1.0).withSum(value)));
        } else {
            if (!datum.getUnit().equals(unit.name())) {
                throw new IllegalArgumentException("Cannot add to existing metric with different unit");
            }
            StatisticSet statistics = datum.getStatisticValues();
            statistics.setMaximum(Math.max(value, statistics.getMaximum()));
            statistics.setMinimum(Math.min(value, statistics.getMinimum()));
            statistics.setSampleCount(statistics.getSampleCount() + 1.0);
            statistics.setSum(statistics.getSum() + value);
        }
    }
}

