/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.leases.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.flink.kinesis.shaded.com.amazonaws.AmazonClientException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.AttributeValue;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.BillingMode;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ConditionalCheckFailedException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.GetItemResult;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.LimitExceededException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ProvisionedThroughputExceededException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ResourceInUseException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ScanRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ScanResult;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.TableStatus;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisClientLibConfiguration;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.leases.exceptions.DependencyException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.leases.exceptions.InvalidStateException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.leases.exceptions.ProvisionedThroughputException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.leases.impl.Lease;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.leases.impl.UpdateField;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.leases.interfaces.ILeaseManager;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.leases.interfaces.ILeaseSerializer;
import org.apache.flink.kinesis.shaded.org.apache.commons.logging.Log;
import org.apache.flink.kinesis.shaded.org.apache.commons.logging.LogFactory;

public class LeaseManager<T extends Lease>
implements ILeaseManager<T> {
    private static final Log LOG = LogFactory.getLog(LeaseManager.class);
    protected String table;
    protected AmazonDynamoDB dynamoDBClient;
    protected ILeaseSerializer<T> serializer;
    protected boolean consistentReads;
    private BillingMode billingMode;

    @Deprecated
    public LeaseManager(String table, AmazonDynamoDB dynamoDBClient, ILeaseSerializer<T> serializer) {
        this(table, dynamoDBClient, serializer, false, KinesisClientLibConfiguration.DEFAULT_DDB_BILLING_MODE);
    }

    public LeaseManager(String table, AmazonDynamoDB dynamoDBClient, ILeaseSerializer<T> serializer, BillingMode billingMode) {
        this(table, dynamoDBClient, serializer, false, billingMode);
    }

    public LeaseManager(String table, AmazonDynamoDB dynamoDBClient, ILeaseSerializer<T> serializer, boolean consistentReads, BillingMode billingMode) {
        this.verifyNotNull(table, "Table name cannot be null");
        this.verifyNotNull(dynamoDBClient, "dynamoDBClient cannot be null");
        this.verifyNotNull(serializer, "ILeaseSerializer cannot be null");
        this.table = table;
        this.dynamoDBClient = dynamoDBClient;
        this.consistentReads = consistentReads;
        this.serializer = serializer;
        this.billingMode = billingMode;
    }

    @Override
    public boolean createLeaseTableIfNotExists(Long readCapacity, Long writeCapacity) throws ProvisionedThroughputException, DependencyException {
        this.verifyNotNull(readCapacity, "readCapacity cannot be null");
        this.verifyNotNull(writeCapacity, "writeCapacity cannot be null");
        try {
            if (this.tableStatus() != null) {
                return false;
            }
        }
        catch (DependencyException de) {
            LOG.error("Failed to get table status for " + this.table, de);
        }
        CreateTableRequest request = new CreateTableRequest();
        request.setTableName(this.table);
        request.setKeySchema(this.serializer.getKeySchema());
        request.setAttributeDefinitions(this.serializer.getAttributeDefinitions());
        request.setBillingMode(this.billingMode.name());
        if (BillingMode.PROVISIONED.equals((Object)this.billingMode)) {
            ProvisionedThroughput throughput = new ProvisionedThroughput();
            throughput.setReadCapacityUnits(readCapacity);
            throughput.setWriteCapacityUnits(writeCapacity);
            request.setProvisionedThroughput(throughput);
        }
        try {
            this.dynamoDBClient.createTable(request);
        }
        catch (ResourceInUseException e) {
            LOG.info("Table " + this.table + " already exists.");
            return false;
        }
        catch (LimitExceededException e) {
            throw new ProvisionedThroughputException("Capacity exceeded when creating table " + this.table, e);
        }
        catch (AmazonClientException e) {
            throw new DependencyException(e);
        }
        return true;
    }

    @Override
    public boolean leaseTableExists() throws DependencyException {
        TableStatus tableStatus = this.tableStatus();
        return TableStatus.ACTIVE == tableStatus || TableStatus.UPDATING == tableStatus;
    }

    private TableStatus tableStatus() throws DependencyException {
        DescribeTableResult result;
        DescribeTableRequest request = new DescribeTableRequest();
        request.setTableName(this.table);
        try {
            result = this.dynamoDBClient.describeTable(request);
        }
        catch (ResourceNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Got ResourceNotFoundException for table %s in leaseTableExists, returning false.", this.table));
            }
            return null;
        }
        catch (AmazonClientException e) {
            throw new DependencyException(e);
        }
        TableStatus tableStatus = TableStatus.fromValue(result.getTable().getTableStatus());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Lease table exists and is in status " + (Object)((Object)tableStatus));
        }
        return tableStatus;
    }

    @Override
    public boolean waitUntilLeaseTableExists(long secondsBetweenPolls, long timeoutSeconds) throws DependencyException {
        long sleepTimeRemaining = TimeUnit.SECONDS.toMillis(timeoutSeconds);
        while (!this.leaseTableExists()) {
            if (sleepTimeRemaining <= 0L) {
                return false;
            }
            long timeToSleepMillis = Math.min(TimeUnit.SECONDS.toMillis(secondsBetweenPolls), sleepTimeRemaining);
            sleepTimeRemaining -= this.sleep(timeToSleepMillis);
        }
        return true;
    }

    long sleep(long timeToSleepMillis) {
        long startTime = System.currentTimeMillis();
        try {
            Thread.sleep(timeToSleepMillis);
        }
        catch (InterruptedException e) {
            LOG.debug("Interrupted while sleeping");
        }
        return System.currentTimeMillis() - startTime;
    }

    @Override
    public List<T> listLeases() throws DependencyException, InvalidStateException, ProvisionedThroughputException {
        return this.list(null);
    }

    @Override
    public boolean isLeaseTableEmpty() throws DependencyException, InvalidStateException, ProvisionedThroughputException {
        return this.list(1, 1).isEmpty();
    }

    List<T> list(Integer limit) throws DependencyException, InvalidStateException, ProvisionedThroughputException {
        return this.list(limit, Integer.MAX_VALUE);
    }

    private List<T> list(Integer limit, Integer maxPages) throws InvalidStateException, ProvisionedThroughputException, DependencyException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Listing leases from table " + this.table);
        }
        ScanRequest scanRequest = new ScanRequest();
        scanRequest.setTableName(this.table);
        if (limit != null) {
            scanRequest.setLimit(limit);
        }
        try {
            ScanResult scanResult = this.dynamoDBClient.scan(scanRequest);
            ArrayList<T> result = new ArrayList<T>();
            while (scanResult != null) {
                for (Map<String, AttributeValue> item : scanResult.getItems()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Got item " + item.toString() + " from DynamoDB.");
                    }
                    result.add(this.serializer.fromDynamoRecord(item));
                }
                Map<String, AttributeValue> lastEvaluatedKey = scanResult.getLastEvaluatedKey();
                if (lastEvaluatedKey == null || (maxPages = Integer.valueOf(maxPages - 1)) <= 0) {
                    scanResult = null;
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("lastEvaluatedKey was null - scan finished.");
                    continue;
                }
                scanRequest.setExclusiveStartKey(lastEvaluatedKey);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("lastEvaluatedKey was " + lastEvaluatedKey + ", continuing scan.");
                }
                scanResult = this.dynamoDBClient.scan(scanRequest);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Listed " + result.size() + " leases from table " + this.table);
            }
            return result;
        }
        catch (ResourceNotFoundException e) {
            throw new InvalidStateException("Cannot scan lease table " + this.table + " because it does not exist.", e);
        }
        catch (ProvisionedThroughputExceededException e) {
            throw new ProvisionedThroughputException(e);
        }
        catch (AmazonClientException e) {
            throw new DependencyException(e);
        }
    }

    @Override
    public boolean createLeaseIfNotExists(T lease) throws DependencyException, InvalidStateException, ProvisionedThroughputException {
        this.verifyNotNull(lease, "lease cannot be null");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating lease " + lease);
        }
        PutItemRequest request = new PutItemRequest();
        request.setTableName(this.table);
        request.setItem(this.serializer.toDynamoRecord(lease));
        request.setExpected(this.serializer.getDynamoNonexistantExpectation());
        try {
            this.dynamoDBClient.putItem(request);
        }
        catch (ConditionalCheckFailedException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Did not create lease " + lease + " because it already existed");
            }
            return false;
        }
        catch (AmazonClientException e) {
            throw this.convertAndRethrowExceptions("create", ((Lease)lease).getLeaseKey(), e);
        }
        return true;
    }

    @Override
    public T getLease(String leaseKey) throws DependencyException, InvalidStateException, ProvisionedThroughputException {
        this.verifyNotNull(leaseKey, "leaseKey cannot be null");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Getting lease with key " + leaseKey);
        }
        GetItemRequest request = new GetItemRequest();
        request.setTableName(this.table);
        request.setKey(this.serializer.getDynamoHashKey(leaseKey));
        request.setConsistentRead(this.consistentReads);
        try {
            GetItemResult result = this.dynamoDBClient.getItem(request);
            Map<String, AttributeValue> dynamoRecord = result.getItem();
            if (dynamoRecord == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No lease found with key " + leaseKey + ", returning null.");
                }
                return null;
            }
            T lease = this.serializer.fromDynamoRecord(dynamoRecord);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got lease " + lease);
            }
            return lease;
        }
        catch (AmazonClientException e) {
            throw this.convertAndRethrowExceptions("get", leaseKey, e);
        }
    }

    @Override
    public boolean renewLease(T lease) throws DependencyException, InvalidStateException, ProvisionedThroughputException {
        this.verifyNotNull(lease, "lease cannot be null");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Renewing lease with key " + ((Lease)lease).getLeaseKey());
        }
        UpdateItemRequest request = new UpdateItemRequest();
        request.setTableName(this.table);
        request.setKey(this.serializer.getDynamoHashKey(lease));
        request.setExpected(this.serializer.getDynamoLeaseCounterExpectation(lease));
        request.setAttributeUpdates(this.serializer.getDynamoLeaseCounterUpdate(lease));
        try {
            this.dynamoDBClient.updateItem(request);
        }
        catch (ConditionalCheckFailedException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Lease renewal failed for lease with key " + ((Lease)lease).getLeaseKey() + " because the lease counter was not " + ((Lease)lease).getLeaseCounter());
            }
            String expectedOwner = ((Lease)lease).getLeaseOwner();
            Long expectedCounter = ((Lease)lease).getLeaseCounter() + 1L;
            T updatedLease = this.getLease(((Lease)lease).getLeaseKey());
            if (updatedLease == null || !expectedOwner.equals(((Lease)updatedLease).getLeaseOwner()) || !expectedCounter.equals(((Lease)updatedLease).getLeaseCounter())) {
                return false;
            }
            LOG.info("Detected spurious renewal failure for lease with key " + ((Lease)lease).getLeaseKey() + ", but recovered");
        }
        catch (AmazonClientException e) {
            throw this.convertAndRethrowExceptions("renew", ((Lease)lease).getLeaseKey(), e);
        }
        ((Lease)lease).setLeaseCounter(((Lease)lease).getLeaseCounter() + 1L);
        return true;
    }

    @Override
    public boolean takeLease(T lease, String owner) throws DependencyException, InvalidStateException, ProvisionedThroughputException {
        this.verifyNotNull(lease, "lease cannot be null");
        this.verifyNotNull(owner, "owner cannot be null");
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Taking lease with leaseKey %s from %s to %s", ((Lease)lease).getLeaseKey(), ((Lease)lease).getLeaseOwner() == null ? "nobody" : ((Lease)lease).getLeaseOwner(), owner));
        }
        UpdateItemRequest request = new UpdateItemRequest();
        request.setTableName(this.table);
        request.setKey(this.serializer.getDynamoHashKey(lease));
        request.setExpected(this.serializer.getDynamoLeaseCounterExpectation(lease));
        Map<String, AttributeValueUpdate> updates = this.serializer.getDynamoLeaseCounterUpdate(lease);
        updates.putAll(this.serializer.getDynamoTakeLeaseUpdate(lease, owner));
        request.setAttributeUpdates(updates);
        try {
            this.dynamoDBClient.updateItem(request);
        }
        catch (ConditionalCheckFailedException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Lease renewal failed for lease with key " + ((Lease)lease).getLeaseKey() + " because the lease counter was not " + ((Lease)lease).getLeaseCounter());
            }
            return false;
        }
        catch (AmazonClientException e) {
            throw this.convertAndRethrowExceptions("take", ((Lease)lease).getLeaseKey(), e);
        }
        ((Lease)lease).setLeaseCounter(((Lease)lease).getLeaseCounter() + 1L);
        ((Lease)lease).setLeaseOwner(owner);
        return true;
    }

    @Override
    public boolean evictLease(T lease) throws DependencyException, InvalidStateException, ProvisionedThroughputException {
        this.verifyNotNull(lease, "lease cannot be null");
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Evicting lease with leaseKey %s owned by %s", ((Lease)lease).getLeaseKey(), ((Lease)lease).getLeaseOwner()));
        }
        UpdateItemRequest request = new UpdateItemRequest();
        request.setTableName(this.table);
        request.setKey(this.serializer.getDynamoHashKey(lease));
        request.setExpected(this.serializer.getDynamoLeaseOwnerExpectation(lease));
        Map<String, AttributeValueUpdate> updates = this.serializer.getDynamoLeaseCounterUpdate(lease);
        updates.putAll(this.serializer.getDynamoEvictLeaseUpdate(lease));
        request.setAttributeUpdates(updates);
        try {
            this.dynamoDBClient.updateItem(request);
        }
        catch (ConditionalCheckFailedException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Lease eviction failed for lease with key " + ((Lease)lease).getLeaseKey() + " because the lease owner was not " + ((Lease)lease).getLeaseOwner());
            }
            return false;
        }
        catch (AmazonClientException e) {
            throw this.convertAndRethrowExceptions("evict", ((Lease)lease).getLeaseKey(), e);
        }
        ((Lease)lease).setLeaseOwner(null);
        ((Lease)lease).setLeaseCounter(((Lease)lease).getLeaseCounter() + 1L);
        return true;
    }

    @Override
    public void deleteAll() throws DependencyException, InvalidStateException, ProvisionedThroughputException {
        List<T> allLeases = this.listLeases();
        LOG.warn("Deleting " + allLeases.size() + " items from table " + this.table);
        for (Lease lease : allLeases) {
            DeleteItemRequest deleteRequest = new DeleteItemRequest();
            deleteRequest.setTableName(this.table);
            deleteRequest.setKey(this.serializer.getDynamoHashKey(lease));
            this.dynamoDBClient.deleteItem(deleteRequest);
        }
    }

    @Override
    public void deleteLease(T lease) throws DependencyException, InvalidStateException, ProvisionedThroughputException {
        this.verifyNotNull(lease, "lease cannot be null");
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Deleting lease with leaseKey %s", ((Lease)lease).getLeaseKey()));
        }
        DeleteItemRequest deleteRequest = new DeleteItemRequest();
        deleteRequest.setTableName(this.table);
        deleteRequest.setKey(this.serializer.getDynamoHashKey(lease));
        try {
            this.dynamoDBClient.deleteItem(deleteRequest);
        }
        catch (AmazonClientException e) {
            throw this.convertAndRethrowExceptions("delete", ((Lease)lease).getLeaseKey(), e);
        }
    }

    @Override
    public boolean updateLease(T lease) throws DependencyException, InvalidStateException, ProvisionedThroughputException {
        this.verifyNotNull(lease, "lease cannot be null");
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Updating lease %s", lease));
        }
        UpdateItemRequest request = new UpdateItemRequest();
        request.setTableName(this.table);
        request.setKey(this.serializer.getDynamoHashKey(lease));
        Map<String, ExpectedAttributeValue> expectations = this.serializer.getDynamoLeaseCounterExpectation(lease);
        expectations.putAll(this.serializer.getDynamoLeaseCheckpointExpectation(lease));
        request.setExpected(expectations);
        Map<String, AttributeValueUpdate> updates = this.serializer.getDynamoLeaseCounterUpdate(lease);
        updates.putAll(this.serializer.getDynamoUpdateLeaseUpdate(lease));
        request.setAttributeUpdates(updates);
        try {
            this.dynamoDBClient.updateItem(request);
        }
        catch (ConditionalCheckFailedException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Lease update failed for lease with key " + ((Lease)lease).getLeaseKey() + " because the lease counter was not " + ((Lease)lease).getLeaseCounter());
            }
            return false;
        }
        catch (AmazonClientException e) {
            throw this.convertAndRethrowExceptions("update", ((Lease)lease).getLeaseKey(), e);
        }
        ((Lease)lease).setLeaseCounter(((Lease)lease).getLeaseCounter() + 1L);
        return true;
    }

    @Override
    public void updateLeaseWithMetaInfo(T lease, UpdateField updateField) throws DependencyException, InvalidStateException, ProvisionedThroughputException {
        this.verifyNotNull(lease, "lease cannot be null");
        this.verifyNotNull((Object)updateField, "updateField cannot be null");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updating lease " + lease + " for field " + (Object)((Object)updateField));
        }
        UpdateItemRequest request = new UpdateItemRequest();
        request.setTableName(this.table);
        request.setKey(this.serializer.getDynamoHashKey(lease));
        request.setExpected(this.serializer.getDynamoExistentExpectation(((Lease)lease).getLeaseKey()));
        Map<String, AttributeValueUpdate> updates = this.serializer.getDynamoUpdateLeaseUpdate(lease, updateField);
        request.setAttributeUpdates(updates);
        try {
            this.dynamoDBClient.updateItem(request);
        }
        catch (ConditionalCheckFailedException e) {
            LOG.warn("Lease update failed for lease with key " + ((Lease)lease).getLeaseKey() + " because the lease did not exist at the time of the update", e);
        }
        catch (AmazonClientException e) {
            throw this.convertAndRethrowExceptions("update", ((Lease)lease).getLeaseKey(), e);
        }
    }

    protected DependencyException convertAndRethrowExceptions(String operation, String leaseKey, AmazonClientException e) throws ProvisionedThroughputException, InvalidStateException {
        if (e instanceof ProvisionedThroughputExceededException) {
            LOG.warn("Provisioned Throughput on the lease table has been exceeded. It's recommended that you increase the IOPs on the table. Failure to increase the IOPs may cause the application to not make progress.");
            throw new ProvisionedThroughputException(e);
        }
        if (e instanceof ResourceNotFoundException) {
            throw new InvalidStateException(String.format("Cannot %s lease with key %s because table %s does not exist.", operation, leaseKey, this.table), e);
        }
        return new DependencyException(e);
    }

    private void verifyNotNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }
}

