/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import java.util.concurrent.Executors;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.BlockingGetRecordsCache;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.DataFetchingStrategy;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.GetRecordsCache;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.GetRecordsRetrievalStrategy;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.PrefetchGetRecordsCache;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.RecordsFetcherFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.metrics.interfaces.IMetricsFactory;
import org.apache.flink.kinesis.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.flink.kinesis.shaded.org.apache.commons.logging.Log;
import org.apache.flink.kinesis.shaded.org.apache.commons.logging.LogFactory;

public class SimpleRecordsFetcherFactory
implements RecordsFetcherFactory {
    private static final Log log = LogFactory.getLog(SimpleRecordsFetcherFactory.class);
    private int maxPendingProcessRecordsInput = 3;
    private int maxByteSize = 0x800000;
    private int maxRecordsCount = 30000;
    private long idleMillisBetweenCalls = 1500L;
    private DataFetchingStrategy dataFetchingStrategy = DataFetchingStrategy.DEFAULT;

    @Override
    public GetRecordsCache createRecordsFetcher(GetRecordsRetrievalStrategy getRecordsRetrievalStrategy, String shardId, IMetricsFactory metricsFactory, int maxRecords) {
        if (this.dataFetchingStrategy.equals((Object)DataFetchingStrategy.DEFAULT)) {
            return new BlockingGetRecordsCache(maxRecords, getRecordsRetrievalStrategy);
        }
        return new PrefetchGetRecordsCache(this.maxPendingProcessRecordsInput, this.maxByteSize, this.maxRecordsCount, maxRecords, getRecordsRetrievalStrategy, Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("prefetch-cache-" + shardId + "-%04d").build()), this.idleMillisBetweenCalls, metricsFactory, "ProcessTask", shardId);
    }

    @Override
    public void setMaxPendingProcessRecordsInput(int maxPendingProcessRecordsInput) {
        this.maxPendingProcessRecordsInput = maxPendingProcessRecordsInput;
    }

    @Override
    public void setMaxByteSize(int maxByteSize) {
        this.maxByteSize = maxByteSize;
    }

    @Override
    public void setMaxRecordsCount(int maxRecordsCount) {
        this.maxRecordsCount = maxRecordsCount;
    }

    @Override
    public void setDataFetchingStrategy(DataFetchingStrategy dataFetchingStrategy) {
        this.dataFetchingStrategy = dataFetchingStrategy;
    }

    @Override
    public void setIdleMillisBetweenCalls(long idleMillisBetweenCalls) {
        this.idleMillisBetweenCalls = idleMillisBetweenCalls;
    }
}

