/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.types.ExtendedSequenceNumber;
import org.apache.flink.kinesis.shaded.org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.flink.kinesis.shaded.org.apache.commons.lang3.builder.HashCodeBuilder;

public class ShardInfo {
    private final String shardId;
    private final String concurrencyToken;
    private final List<String> parentShardIds;
    private final ExtendedSequenceNumber checkpoint;

    public ShardInfo(String shardId, String concurrencyToken, Collection<String> parentShardIds, ExtendedSequenceNumber checkpoint) {
        this.shardId = shardId;
        this.concurrencyToken = concurrencyToken;
        this.parentShardIds = new LinkedList<String>();
        if (parentShardIds != null) {
            this.parentShardIds.addAll(parentShardIds);
        }
        Collections.sort(this.parentShardIds);
        this.checkpoint = checkpoint;
    }

    public String getShardId() {
        return this.shardId;
    }

    public String getConcurrencyToken() {
        return this.concurrencyToken;
    }

    public List<String> getParentShardIds() {
        return new LinkedList<String>(this.parentShardIds);
    }

    protected boolean isCompleted() {
        return ExtendedSequenceNumber.SHARD_END.equals(this.checkpoint);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.concurrencyToken).append(this.parentShardIds).append(this.shardId).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ShardInfo other = (ShardInfo)obj;
        return new EqualsBuilder().append(this.concurrencyToken, other.concurrencyToken).append(this.parentShardIds, other.parentShardIds).append(this.shardId, other.shardId).isEquals();
    }

    public String toString() {
        return "ShardInfo [shardId=" + this.shardId + ", concurrencyToken=" + this.concurrencyToken + ", parentShardIds=" + this.parentShardIds + ", checkpoint=" + this.checkpoint + "]";
    }
}

