/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.transform;

import org.apache.flink.kinesis.shaded.com.amazonaws.SdkClientException;
import org.apache.flink.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.MarshallLocation;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.MarshallingInfo;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.MarshallingType;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.StructuredPojo;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.TransactWriteItem;

@SdkInternalApi
public class TransactWriteItemMarshaller {
    private static final MarshallingInfo<StructuredPojo> CONDITIONCHECK_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConditionCheck").build();
    private static final MarshallingInfo<StructuredPojo> PUT_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Put").build();
    private static final MarshallingInfo<StructuredPojo> DELETE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Delete").build();
    private static final MarshallingInfo<StructuredPojo> UPDATE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Update").build();
    private static final TransactWriteItemMarshaller instance = new TransactWriteItemMarshaller();

    public static TransactWriteItemMarshaller getInstance() {
        return instance;
    }

    public void marshall(TransactWriteItem transactWriteItem, ProtocolMarshaller protocolMarshaller) {
        if (transactWriteItem == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(transactWriteItem.getConditionCheck(), CONDITIONCHECK_BINDING);
            protocolMarshaller.marshall(transactWriteItem.getPut(), PUT_BINDING);
            protocolMarshaller.marshall(transactWriteItem.getDelete(), DELETE_BINDING);
            protocolMarshaller.marshall(transactWriteItem.getUpdate(), UPDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

