/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal;

import java.util.Map;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.Expected;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.Item;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.PutItemOutcome;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.Table;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.api.PutItemApi;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal.AbstractImpl;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal.InternalUtils;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.spec.PutItemSpec;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.AttributeValue;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.PutItemResult;

public class PutItemImpl
extends AbstractImpl
implements PutItemApi {
    public PutItemImpl(AmazonDynamoDB client, Table table) {
        super(client, table);
    }

    @Override
    public PutItemOutcome putItem(Item item) {
        return this.doPutItem(new PutItemSpec().withItem(item));
    }

    @Override
    public PutItemOutcome putItem(Item item, Expected ... expected) {
        return this.doPutItem(new PutItemSpec().withItem(item).withExpected(expected));
    }

    @Override
    public PutItemOutcome putItem(Item item, String conditionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.doPutItem(new PutItemSpec().withItem(item).withConditionExpression(conditionExpression).withNameMap(nameMap).withValueMap(valueMap));
    }

    @Override
    public PutItemOutcome putItem(PutItemSpec spec) {
        return this.doPutItem(spec);
    }

    private PutItemOutcome doPutItem(PutItemSpec spec) {
        String tableName = this.getTable().getTableName();
        PutItemRequest req = ((PutItemRequest)spec.getRequest()).withTableName(tableName);
        Item item = spec.getItem();
        Map<String, AttributeValue> attributes = InternalUtils.toAttributeValues(item);
        Map<String, ExpectedAttributeValue> expectedMap = InternalUtils.toExpectedAttributeValueMap(spec.getExpected());
        Map<String, AttributeValue> attrValMap = InternalUtils.fromSimpleMap(spec.getValueMap());
        req.withItem(attributes).withExpected(expectedMap).withExpressionAttributeNames(spec.getNameMap()).withExpressionAttributeValues(attrValMap);
        PutItemResult result = this.getClient().putItem(req);
        return new PutItemOutcome(result);
    }
}

