/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.Page;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.Table;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal.InternalUtils;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.spec.ListTablesSpec;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ListTablesRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ListTablesResult;

class ListTablesPage
extends Page<Table, ListTablesResult> {
    private final AmazonDynamoDB client;
    private final ListTablesSpec spec;
    private final ListTablesRequest request;
    private final int index;
    private final String lastEvaluatedKey;

    public ListTablesPage(AmazonDynamoDB client, ListTablesSpec spec, ListTablesRequest request, int index, ListTablesResult result) {
        super(Collections.unmodifiableList(ListTablesPage.toTableList(client, result.getTableNames())), result);
        this.client = client;
        this.spec = spec;
        this.request = request;
        this.index = index;
        Integer max = spec.getMaxResultSize();
        this.lastEvaluatedKey = max != null && index + result.getTableNames().size() > max ? null : result.getLastEvaluatedTableName();
    }

    @Override
    public boolean hasNextPage() {
        if (this.lastEvaluatedKey == null) {
            return false;
        }
        Integer max = this.spec.getMaxResultSize();
        if (max == null) {
            return true;
        }
        return this.nextRequestLimit(max) > 0;
    }

    private int nextRequestLimit(int max) {
        int nextIndex = this.index + this.size();
        return InternalUtils.minimum(max - nextIndex, this.spec.getMaxPageSize());
    }

    @Override
    public Page<Table, ListTablesResult> nextPage() {
        if (this.lastEvaluatedKey == null) {
            throw new NoSuchElementException("No more pages");
        }
        Integer max = this.spec.getMaxResultSize();
        if (max != null) {
            int nextLimit = this.nextRequestLimit(max);
            if (nextLimit == 0) {
                throw new NoSuchElementException("No more pages");
            }
            this.request.setLimit(nextLimit);
        }
        this.request.setExclusiveStartTableName(this.lastEvaluatedKey);
        ListTablesResult result = this.client.listTables(this.request);
        int nextIndex = this.index + this.size();
        return new ListTablesPage(this.client, this.spec, this.request, nextIndex, result);
    }

    private static List<Table> toTableList(AmazonDynamoDB client, List<String> tableNames) {
        if (tableNames == null) {
            return null;
        }
        ArrayList<Table> result = new ArrayList<Table>(tableNames.size());
        for (String tableName : tableNames) {
            result.add(new Table(client, tableName));
        }
        return result;
    }
}

