/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.math.BigInteger;
import java.util.Arrays;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDB;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerateStrategy;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerated;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerator;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.StandardTypeConverters;

@DynamoDB
@DynamoDBAutoGenerated(generator=Generator.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.ANNOTATION_TYPE})
public @interface DynamoDBVersioned {

    public static final class Generator<T>
    extends DynamoDBAutoGenerator.AbstractGenerator<T> {
        private final Sequence<T> sequence;

        public Generator(Class<T> targetType, DynamoDBVersioned annotation) {
            super(DynamoDBAutoGenerateStrategy.ALWAYS);
            this.sequence = Sequences.of(targetType);
        }

        @Override
        public final T generate(T currentValue) {
            return currentValue == null ? this.sequence.init() : this.sequence.next(currentValue);
        }

        private static enum Sequences {
            BIG_INTEGER(StandardTypeConverters.Scalar.BIG_INTEGER, new Sequence<BigInteger>(){

                @Override
                public final BigInteger init() {
                    return BigInteger.ONE;
                }

                @Override
                public final BigInteger next(BigInteger o) {
                    return o.add(BigInteger.ONE);
                }
            }),
            BYTE(StandardTypeConverters.Scalar.BYTE, new Sequence<Byte>(){

                @Override
                public final Byte init() {
                    return (byte)1;
                }

                @Override
                public final Byte next(Byte o) {
                    return (byte)((o + 1) % 127);
                }
            }),
            INTEGER(StandardTypeConverters.Scalar.INTEGER, new Sequence<Integer>(){

                @Override
                public final Integer init() {
                    return 1;
                }

                @Override
                public final Integer next(Integer o) {
                    return o + 1;
                }
            }),
            LONG(StandardTypeConverters.Scalar.LONG, new Sequence<Long>(){

                @Override
                public final Long init() {
                    return 1L;
                }

                @Override
                public final Long next(Long o) {
                    return o + 1L;
                }
            }),
            SHORT(StandardTypeConverters.Scalar.SHORT, new Sequence<Short>(){

                @Override
                public final Short init() {
                    return (short)1;
                }

                @Override
                public final Short next(Short o) {
                    return (short)(o + 1);
                }
            });

            private final Sequence<?> sequence;
            private final StandardTypeConverters.Scalar scalar;

            private Sequences(StandardTypeConverters.Scalar scalar, Sequence<?> sequence) {
                this.sequence = sequence;
                this.scalar = scalar;
            }

            private static final <T> Sequence<T> of(Class<T> targetType) {
                for (Sequences s : Sequences.values()) {
                    if (!s.scalar.is(targetType)) continue;
                    return s.sequence;
                }
                throw new DynamoDBMappingException("type [" + targetType + "] is not supported; allowed only " + Arrays.toString((Object[])Sequences.values()));
            }
        }

        static interface Sequence<T> {
            public T init();

            public T next(T var1);
        }
    }
}

