/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2;

import org.apache.flink.kinesis.shaded.com.amazonaws.ClientConfigurationFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.annotation.NotThreadSafe;
import org.apache.flink.kinesis.shaded.com.amazonaws.client.AwsSyncClientParams;
import org.apache.flink.kinesis.shaded.com.amazonaws.client.builder.AwsSyncClientBuilder;
import org.apache.flink.kinesis.shaded.com.amazonaws.endpointdiscovery.DefaultEndpointDiscoveryProviderChain;
import org.apache.flink.kinesis.shaded.com.amazonaws.endpointdiscovery.EndpointDiscoveryProviderChain;
import org.apache.flink.kinesis.shaded.com.amazonaws.internal.config.InternalConfig;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientConfigurationFactory;

@NotThreadSafe
public final class AmazonDynamoDBClientBuilder
extends AwsSyncClientBuilder<AmazonDynamoDBClientBuilder, AmazonDynamoDB> {
    private static final ClientConfigurationFactory CLIENT_CONFIG_FACTORY = new AmazonDynamoDBClientConfigurationFactory();
    private static final EndpointDiscoveryProviderChain DEFAULT_ENDPOINT_DISCOVERY_PROVIDER = new DefaultEndpointDiscoveryProviderChain();
    private boolean endpointDiscoveryEnabled = false;
    private boolean endpointDiscoveryDisabled = false;

    public static AmazonDynamoDBClientBuilder standard() {
        return new AmazonDynamoDBClientBuilder();
    }

    public static AmazonDynamoDB defaultClient() {
        return (AmazonDynamoDB)AmazonDynamoDBClientBuilder.standard().build();
    }

    private AmazonDynamoDBClientBuilder() {
        super(CLIENT_CONFIG_FACTORY);
    }

    public AmazonDynamoDBClientBuilder enableEndpointDiscovery() {
        this.endpointDiscoveryEnabled = true;
        return this;
    }

    public AmazonDynamoDBClientBuilder disableEndpointDiscovery() {
        this.endpointDiscoveryDisabled = true;
        return this;
    }

    private boolean endpointDiscoveryEnabled() {
        Boolean endpointDiscoveryChainSetting = DEFAULT_ENDPOINT_DISCOVERY_PROVIDER.endpointDiscoveryEnabled();
        if (this.endpointDiscoveryDisabled) {
            return false;
        }
        if (this.endpointDiscoveryEnabled) {
            return true;
        }
        if (endpointDiscoveryChainSetting != null && !endpointDiscoveryChainSetting.booleanValue()) {
            return false;
        }
        if (endpointDiscoveryChainSetting != null && endpointDiscoveryChainSetting.booleanValue()) {
            return true;
        }
        return InternalConfig.Factory.getInternalConfig().endpointDiscoveryEnabled();
    }

    @Override
    protected AmazonDynamoDB build(AwsSyncClientParams params) {
        if (this.endpointDiscoveryEnabled() && this.getEndpoint() == null) {
            return new AmazonDynamoDBClient(params, true);
        }
        return new AmazonDynamoDBClient(params);
    }
}

