/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.Iterator;
import org.apache.flink.hadoop.shaded.com.google.common.base.Predicate;
import org.apache.flink.hadoop.shaded.com.google.common.collect.Iterables;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.util.GSet;
import org.apache.hadoop.util.LightWeightGSet;

class BlocksMap {
    private final int capacity;
    private GSet<Block, BlockInfo> blocks;

    BlocksMap(int capacity) {
        this.capacity = capacity;
        this.blocks = new LightWeightGSet<Block, BlockInfo>(capacity){

            @Override
            public Iterator<BlockInfo> iterator() {
                LightWeightGSet.SetIterator iterator = new LightWeightGSet.SetIterator();
                iterator.setTrackModification(false);
                return iterator;
            }
        };
    }

    void close() {
        if (this.blocks != null) {
            this.blocks.clear();
            this.blocks = null;
        }
    }

    BlockCollection getBlockCollection(Block b) {
        BlockInfo info = this.blocks.get(b);
        return info != null ? info.getBlockCollection() : null;
    }

    BlockInfo addBlockCollection(BlockInfo b, BlockCollection bc) {
        BlockInfo info = this.blocks.get(b);
        if (info != b) {
            info = b;
            this.blocks.put(info);
        }
        info.setBlockCollection(bc);
        return info;
    }

    void removeBlock(Block block) {
        BlockInfo blockInfo = this.blocks.remove(block);
        if (blockInfo == null) {
            return;
        }
        blockInfo.setBlockCollection(null);
        for (int idx = blockInfo.numNodes() - 1; idx >= 0; --idx) {
            DatanodeDescriptor dn = blockInfo.getDatanode(idx);
            dn.removeBlock(blockInfo);
        }
    }

    BlockInfo getStoredBlock(Block b) {
        return this.blocks.get(b);
    }

    Iterable<DatanodeStorageInfo> getStorages(Block b) {
        return this.getStorages(this.blocks.get(b));
    }

    Iterable<DatanodeStorageInfo> getStorages(Block b, final DatanodeStorage.State state) {
        return Iterables.filter(this.getStorages(this.blocks.get(b)), new Predicate<DatanodeStorageInfo>(){

            @Override
            public boolean apply(DatanodeStorageInfo storage) {
                return storage.getState() == state;
            }
        });
    }

    Iterable<DatanodeStorageInfo> getStorages(final BlockInfo storedBlock) {
        return new Iterable<DatanodeStorageInfo>(){

            @Override
            public Iterator<DatanodeStorageInfo> iterator() {
                return new StorageIterator(storedBlock);
            }
        };
    }

    int numNodes(Block b) {
        BlockInfo info = this.blocks.get(b);
        return info == null ? 0 : info.numNodes();
    }

    boolean removeNode(Block b, DatanodeDescriptor node) {
        BlockInfo info = this.blocks.get(b);
        if (info == null) {
            return false;
        }
        boolean removed = node.removeBlock(info);
        if (info.getDatanode(0) == null && info.getBlockCollection() == null) {
            this.blocks.remove(b);
        }
        return removed;
    }

    int size() {
        return this.blocks.size();
    }

    Iterable<BlockInfo> getBlocks() {
        return this.blocks;
    }

    int getCapacity() {
        return this.capacity;
    }

    BlockInfo replaceBlock(BlockInfo newBlock) {
        BlockInfo currentBlock = this.blocks.get(newBlock);
        assert (currentBlock != null) : "the block if not in blocksMap";
        for (int idx = currentBlock.numNodes() - 1; idx >= 0; --idx) {
            DatanodeDescriptor dn = currentBlock.getDatanode(idx);
            dn.replaceBlock(currentBlock, newBlock);
        }
        this.blocks.put(newBlock);
        return newBlock;
    }

    private static class StorageIterator
    implements Iterator<DatanodeStorageInfo> {
        private final BlockInfo blockInfo;
        private int nextIdx = 0;

        StorageIterator(BlockInfo blkInfo) {
            this.blockInfo = blkInfo;
        }

        @Override
        public boolean hasNext() {
            return this.blockInfo != null && this.nextIdx < this.blockInfo.getCapacity() && this.blockInfo.getDatanode(this.nextIdx) != null;
        }

        @Override
        public DatanodeStorageInfo next() {
            return this.blockInfo.getStorageInfo(this.nextIdx++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Sorry. can't remove.");
        }
    }
}

