/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.flink.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.BlockStorageLocation;
import org.apache.hadoop.fs.CacheFlag;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSLinkResolver;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemLinkResolver;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.CorruptFileBlockIterator;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.client.HdfsDataInputStream;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.HdfsLocatedFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.security.token.block.InvalidBlockTokenException;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Progressable;

@InterfaceAudience.LimitedPrivate(value={"MapReduce", "HBase"})
@InterfaceStability.Unstable
public class DistributedFileSystem
extends FileSystem {
    private Path workingDir;
    private URI uri;
    DFSClient dfs;
    private boolean verifyChecksum = true;

    public DistributedFileSystem() {
    }

    @Override
    public String getScheme() {
        return "hdfs";
    }

    @Deprecated
    public DistributedFileSystem(InetSocketAddress namenode, Configuration conf) throws IOException {
        this.initialize(NameNode.getUri(namenode), conf);
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        this.setConf(conf);
        String host = uri.getHost();
        if (host == null) {
            throw new IOException("Incomplete HDFS URI, no host: " + uri);
        }
        this.dfs = new DFSClient(uri, conf, this.statistics);
        this.uri = URI.create(uri.getScheme() + "://" + uri.getAuthority());
        this.workingDir = this.getHomeDirectory();
    }

    @Override
    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    @Override
    public long getDefaultBlockSize() {
        return this.dfs.getDefaultBlockSize();
    }

    @Override
    public short getDefaultReplication() {
        return this.dfs.getDefaultReplication();
    }

    @Override
    public void setWorkingDirectory(Path dir) {
        String result = this.fixRelativePart(dir).toUri().getPath();
        if (!DFSUtil.isValidName(result)) {
            throw new IllegalArgumentException("Invalid DFS directory name " + result);
        }
        this.workingDir = this.fixRelativePart(dir);
    }

    @Override
    public Path getHomeDirectory() {
        return this.makeQualified(new Path("/user/" + this.dfs.ugi.getShortUserName()));
    }

    private String getPathName(Path file) {
        this.checkPath(file);
        String result = file.toUri().getPath();
        if (!DFSUtil.isValidName(result)) {
            throw new IllegalArgumentException("Pathname " + result + " from " + file + " is not a valid DFS filename.");
        }
        return result;
    }

    @Override
    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        if (file == null) {
            return null;
        }
        return this.getFileBlockLocations(file.getPath(), start, len);
    }

    @Override
    public BlockLocation[] getFileBlockLocations(Path p, final long start, final long len) throws IOException {
        this.statistics.incrementReadOps(1);
        Path absF = this.fixRelativePart(p);
        return (BlockLocation[])new FileSystemLinkResolver<BlockLocation[]>(){

            @Override
            public BlockLocation[] doCall(Path p) throws IOException, UnresolvedLinkException {
                return DistributedFileSystem.this.dfs.getBlockLocations(DistributedFileSystem.this.getPathName(p), start, len);
            }

            @Override
            public BlockLocation[] next(FileSystem fs, Path p) throws IOException {
                return fs.getFileBlockLocations(p, start, len);
            }
        }.resolve(this, absF);
    }

    @InterfaceStability.Unstable
    public BlockStorageLocation[] getFileBlockStorageLocations(List<BlockLocation> blocks) throws IOException, UnsupportedOperationException, InvalidBlockTokenException {
        return this.dfs.getBlockStorageLocations(blocks);
    }

    @Override
    public void setVerifyChecksum(boolean verifyChecksum) {
        this.verifyChecksum = verifyChecksum;
    }

    public boolean recoverLease(final Path f) throws IOException {
        Path absF = this.fixRelativePart(f);
        return (Boolean)new FileSystemLinkResolver<Boolean>(){

            @Override
            public Boolean doCall(Path p) throws IOException, UnresolvedLinkException {
                return DistributedFileSystem.this.dfs.recoverLease(DistributedFileSystem.this.getPathName(p));
            }

            @Override
            public Boolean next(FileSystem fs, Path p) throws IOException {
                if (fs instanceof DistributedFileSystem) {
                    DistributedFileSystem myDfs = (DistributedFileSystem)fs;
                    return myDfs.recoverLease(p);
                }
                throw new UnsupportedOperationException("Cannot recoverLease through a symlink to a non-DistributedFileSystem: " + f + " -> " + p);
            }
        }.resolve(this, absF);
    }

    @Override
    public FSDataInputStream open(Path f, final int bufferSize) throws IOException {
        this.statistics.incrementReadOps(1);
        Path absF = this.fixRelativePart(f);
        return (FSDataInputStream)new FileSystemLinkResolver<FSDataInputStream>(){

            @Override
            public FSDataInputStream doCall(Path p) throws IOException, UnresolvedLinkException {
                return new HdfsDataInputStream(DistributedFileSystem.this.dfs.open(DistributedFileSystem.this.getPathName(p), bufferSize, DistributedFileSystem.this.verifyChecksum));
            }

            @Override
            public FSDataInputStream next(FileSystem fs, Path p) throws IOException {
                return fs.open(p, bufferSize);
            }
        }.resolve(this, absF);
    }

    @Override
    public FSDataOutputStream append(Path f, final int bufferSize, final Progressable progress) throws IOException {
        this.statistics.incrementWriteOps(1);
        Path absF = this.fixRelativePart(f);
        return (FSDataOutputStream)new FileSystemLinkResolver<FSDataOutputStream>(){

            @Override
            public FSDataOutputStream doCall(Path p) throws IOException, UnresolvedLinkException {
                return DistributedFileSystem.this.dfs.append(DistributedFileSystem.this.getPathName(p), bufferSize, progress, DistributedFileSystem.this.statistics);
            }

            @Override
            public FSDataOutputStream next(FileSystem fs, Path p) throws IOException {
                return fs.append(p, bufferSize);
            }
        }.resolve(this, absF);
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.create(f, permission, overwrite ? EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE) : EnumSet.of(CreateFlag.CREATE), bufferSize, replication, blockSize, progress, null);
    }

    public HdfsDataOutputStream create(final Path f, final FsPermission permission, final boolean overwrite, final int bufferSize, final short replication, final long blockSize, final Progressable progress, final InetSocketAddress[] favoredNodes) throws IOException {
        this.statistics.incrementWriteOps(1);
        Path absF = this.fixRelativePart(f);
        return (HdfsDataOutputStream)new FileSystemLinkResolver<HdfsDataOutputStream>(){

            @Override
            public HdfsDataOutputStream doCall(Path p) throws IOException, UnresolvedLinkException {
                DFSOutputStream out = DistributedFileSystem.this.dfs.create(DistributedFileSystem.this.getPathName(f), permission, overwrite ? EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE) : EnumSet.of(CreateFlag.CREATE), true, replication, blockSize, progress, bufferSize, null, favoredNodes);
                return new HdfsDataOutputStream(out, DistributedFileSystem.this.statistics);
            }

            @Override
            public HdfsDataOutputStream next(FileSystem fs, Path p) throws IOException {
                if (fs instanceof DistributedFileSystem) {
                    DistributedFileSystem myDfs = (DistributedFileSystem)fs;
                    return myDfs.create(p, permission, overwrite, bufferSize, replication, blockSize, progress, favoredNodes);
                }
                throw new UnsupportedOperationException("Cannot create with favoredNodes through a symlink to a non-DistributedFileSystem: " + f + " -> " + p);
            }
        }.resolve(this, absF);
    }

    @Override
    public FSDataOutputStream create(Path f, final FsPermission permission, final EnumSet<CreateFlag> cflags, final int bufferSize, final short replication, final long blockSize, final Progressable progress, final Options.ChecksumOpt checksumOpt) throws IOException {
        this.statistics.incrementWriteOps(1);
        Path absF = this.fixRelativePart(f);
        return (FSDataOutputStream)new FileSystemLinkResolver<FSDataOutputStream>(){

            @Override
            public FSDataOutputStream doCall(Path p) throws IOException, UnresolvedLinkException {
                return new HdfsDataOutputStream(DistributedFileSystem.this.dfs.create(DistributedFileSystem.this.getPathName(p), permission, cflags, replication, blockSize, progress, bufferSize, checksumOpt), DistributedFileSystem.this.statistics);
            }

            @Override
            public FSDataOutputStream next(FileSystem fs, Path p) throws IOException {
                return fs.create(p, permission, cflags, bufferSize, replication, blockSize, progress, checksumOpt);
            }
        }.resolve(this, absF);
    }

    @Override
    protected HdfsDataOutputStream primitiveCreate(Path f, FsPermission absolutePermission, EnumSet<CreateFlag> flag, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt) throws IOException {
        this.statistics.incrementWriteOps(1);
        return new HdfsDataOutputStream(this.dfs.primitiveCreate(this.getPathName(this.fixRelativePart(f)), absolutePermission, flag, true, replication, blockSize, progress, bufferSize, checksumOpt), this.statistics);
    }

    @Override
    public FSDataOutputStream createNonRecursive(Path f, final FsPermission permission, final EnumSet<CreateFlag> flag, final int bufferSize, final short replication, final long blockSize, final Progressable progress) throws IOException {
        this.statistics.incrementWriteOps(1);
        if (flag.contains((Object)CreateFlag.OVERWRITE)) {
            flag.add(CreateFlag.CREATE);
        }
        Path absF = this.fixRelativePart(f);
        return (FSDataOutputStream)new FileSystemLinkResolver<FSDataOutputStream>(){

            @Override
            public FSDataOutputStream doCall(Path p) throws IOException, UnresolvedLinkException {
                return new HdfsDataOutputStream(DistributedFileSystem.this.dfs.create(DistributedFileSystem.this.getPathName(p), permission, flag, false, replication, blockSize, progress, bufferSize, null), DistributedFileSystem.this.statistics);
            }

            @Override
            public FSDataOutputStream next(FileSystem fs, Path p) throws IOException {
                return fs.createNonRecursive(p, permission, flag, bufferSize, replication, blockSize, progress);
            }
        }.resolve(this, absF);
    }

    @Override
    public boolean setReplication(Path src, final short replication) throws IOException {
        this.statistics.incrementWriteOps(1);
        Path absF = this.fixRelativePart(src);
        return (Boolean)new FileSystemLinkResolver<Boolean>(){

            @Override
            public Boolean doCall(Path p) throws IOException, UnresolvedLinkException {
                return DistributedFileSystem.this.dfs.setReplication(DistributedFileSystem.this.getPathName(p), replication);
            }

            @Override
            public Boolean next(FileSystem fs, Path p) throws IOException {
                return fs.setReplication(p, replication);
            }
        }.resolve(this, absF);
    }

    @Override
    public void concat(Path trg, Path[] psrcs) throws IOException {
        this.statistics.incrementWriteOps(1);
        Path absF = this.fixRelativePart(trg);
        Path[] srcs = new Path[psrcs.length];
        for (int i = 0; i < psrcs.length; ++i) {
            srcs[i] = this.fixRelativePart(psrcs[i]);
        }
        String[] srcsStr = new String[psrcs.length];
        try {
            for (int i = 0; i < psrcs.length; ++i) {
                srcsStr[i] = this.getPathName(srcs[i]);
            }
            this.dfs.concat(this.getPathName(trg), srcsStr);
        }
        catch (UnresolvedLinkException e) {
            int i;
            FileStatus stat = this.getFileLinkStatus(absF);
            if (stat.isSymlink()) {
                throw new IOException("Cannot concat with a symlink target: " + trg + " -> " + stat.getPath());
            }
            absF = this.fixRelativePart(stat.getPath());
            for (i = 0; i < psrcs.length; ++i) {
                stat = this.getFileLinkStatus(srcs[i]);
                if (stat.isSymlink()) {
                    throw new IOException("Cannot concat with a symlink src: " + psrcs[i] + " -> " + stat.getPath());
                }
                srcs[i] = this.fixRelativePart(stat.getPath());
            }
            for (i = 0; i < psrcs.length; ++i) {
                srcsStr[i] = this.getPathName(srcs[i]);
            }
            this.dfs.concat(this.getPathName(absF), srcsStr);
        }
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        this.statistics.incrementWriteOps(1);
        Path absSrc = this.fixRelativePart(src);
        Path absDst = this.fixRelativePart(dst);
        try {
            return this.dfs.rename(this.getPathName(absSrc), this.getPathName(absDst));
        }
        catch (UnresolvedLinkException e) {
            final Path source = this.getFileLinkStatus(absSrc).getPath();
            return (Boolean)new FileSystemLinkResolver<Boolean>(){

                @Override
                public Boolean doCall(Path p) throws IOException, UnresolvedLinkException {
                    return DistributedFileSystem.this.dfs.rename(DistributedFileSystem.this.getPathName(source), DistributedFileSystem.this.getPathName(p));
                }

                @Override
                public Boolean next(FileSystem fs, Path p) throws IOException {
                    return this.doCall(p);
                }
            }.resolve(this, absDst);
        }
    }

    @Override
    public void rename(Path src, Path dst, final Options.Rename ... options) throws IOException {
        this.statistics.incrementWriteOps(1);
        Path absSrc = this.fixRelativePart(src);
        Path absDst = this.fixRelativePart(dst);
        try {
            this.dfs.rename(this.getPathName(absSrc), this.getPathName(absDst), options);
        }
        catch (UnresolvedLinkException e) {
            final Path source = this.getFileLinkStatus(absSrc).getPath();
            new FileSystemLinkResolver<Void>(){

                @Override
                public Void doCall(Path p) throws IOException, UnresolvedLinkException {
                    DistributedFileSystem.this.dfs.rename(DistributedFileSystem.this.getPathName(source), DistributedFileSystem.this.getPathName(p), options);
                    return null;
                }

                @Override
                public Void next(FileSystem fs, Path p) throws IOException {
                    return this.doCall(p);
                }
            }.resolve(this, absDst);
        }
    }

    @Override
    public boolean delete(Path f, final boolean recursive) throws IOException {
        this.statistics.incrementWriteOps(1);
        Path absF = this.fixRelativePart(f);
        return (Boolean)new FileSystemLinkResolver<Boolean>(){

            @Override
            public Boolean doCall(Path p) throws IOException, UnresolvedLinkException {
                return DistributedFileSystem.this.dfs.delete(DistributedFileSystem.this.getPathName(p), recursive);
            }

            @Override
            public Boolean next(FileSystem fs, Path p) throws IOException {
                return fs.delete(p, recursive);
            }
        }.resolve(this, absF);
    }

    @Override
    public ContentSummary getContentSummary(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        Path absF = this.fixRelativePart(f);
        return (ContentSummary)new FileSystemLinkResolver<ContentSummary>(){

            @Override
            public ContentSummary doCall(Path p) throws IOException, UnresolvedLinkException {
                return DistributedFileSystem.this.dfs.getContentSummary(DistributedFileSystem.this.getPathName(p));
            }

            @Override
            public ContentSummary next(FileSystem fs, Path p) throws IOException {
                return fs.getContentSummary(p);
            }
        }.resolve(this, absF);
    }

    public void setQuota(Path src, final long namespaceQuota, final long diskspaceQuota) throws IOException {
        Path absF = this.fixRelativePart(src);
        new FileSystemLinkResolver<Void>(){

            @Override
            public Void doCall(Path p) throws IOException, UnresolvedLinkException {
                DistributedFileSystem.this.dfs.setQuota(DistributedFileSystem.this.getPathName(p), namespaceQuota, diskspaceQuota);
                return null;
            }

            @Override
            public Void next(FileSystem fs, Path p) throws IOException {
                return this.doCall(p);
            }
        }.resolve(this, absF);
    }

    private FileStatus[] listStatusInternal(Path p) throws IOException {
        String src = this.getPathName(p);
        DirectoryListing thisListing = this.dfs.listPaths(src, HdfsFileStatus.EMPTY_NAME);
        if (thisListing == null) {
            throw new FileNotFoundException("File " + p + " does not exist.");
        }
        HdfsFileStatus[] partialListing = thisListing.getPartialListing();
        if (!thisListing.hasMore()) {
            FileStatus[] stats = new FileStatus[partialListing.length];
            for (int i = 0; i < partialListing.length; ++i) {
                stats[i] = partialListing[i].makeQualified(this.getUri(), p);
            }
            this.statistics.incrementReadOps(1);
            return stats;
        }
        int totalNumEntries = partialListing.length + thisListing.getRemainingEntries();
        ArrayList<FileStatus> listing = new ArrayList<FileStatus>(totalNumEntries);
        for (HdfsFileStatus fileStatus : partialListing) {
            listing.add(fileStatus.makeQualified(this.getUri(), p));
        }
        this.statistics.incrementLargeReadOps(1);
        do {
            if ((thisListing = this.dfs.listPaths(src, thisListing.getLastName())) == null) {
                throw new FileNotFoundException("File " + p + " does not exist.");
            }
            for (HdfsFileStatus fileStatus : partialListing = thisListing.getPartialListing()) {
                listing.add(fileStatus.makeQualified(this.getUri(), p));
            }
            this.statistics.incrementLargeReadOps(1);
        } while (thisListing.hasMore());
        return listing.toArray(new FileStatus[listing.size()]);
    }

    @Override
    public FileStatus[] listStatus(Path p) throws IOException {
        Path absF = this.fixRelativePart(p);
        return (FileStatus[])new FileSystemLinkResolver<FileStatus[]>(){

            @Override
            public FileStatus[] doCall(Path p) throws IOException, UnresolvedLinkException {
                return DistributedFileSystem.this.listStatusInternal(p);
            }

            @Override
            public FileStatus[] next(FileSystem fs, Path p) throws IOException {
                return fs.listStatus(p);
            }
        }.resolve(this, absF);
    }

    @Override
    protected RemoteIterator<LocatedFileStatus> listLocatedStatus(final Path p, final PathFilter filter) throws IOException {
        final Path absF = this.fixRelativePart(p);
        return new RemoteIterator<LocatedFileStatus>(){
            private DirectoryListing thisListing;
            private int i;
            private String src = DistributedFileSystem.access$000(DistributedFileSystem.this, DistributedFileSystem.this.resolvePath(absF));
            private LocatedFileStatus curStat = null;
            {
                this.thisListing = DistributedFileSystem.this.dfs.listPaths(this.src, HdfsFileStatus.EMPTY_NAME, true);
                DistributedFileSystem.this.statistics.incrementReadOps(1);
                if (this.thisListing == null) {
                    throw new FileNotFoundException("File " + p + " does not exist.");
                }
            }

            @Override
            public boolean hasNext() throws IOException {
                while (this.curStat == null && this.hasNextNoFilter()) {
                    LocatedFileStatus next = ((HdfsLocatedFileStatus)this.thisListing.getPartialListing()[this.i++]).makeQualifiedLocated(DistributedFileSystem.this.getUri(), absF);
                    if (!filter.accept(next.getPath())) continue;
                    this.curStat = next;
                }
                return this.curStat != null;
            }

            private boolean hasNextNoFilter() throws IOException {
                if (this.thisListing == null) {
                    return false;
                }
                if (this.i >= this.thisListing.getPartialListing().length && this.thisListing.hasMore()) {
                    this.thisListing = DistributedFileSystem.this.dfs.listPaths(this.src, this.thisListing.getLastName(), true);
                    DistributedFileSystem.this.statistics.incrementReadOps(1);
                    if (this.thisListing == null) {
                        return false;
                    }
                    this.i = 0;
                }
                return this.i < this.thisListing.getPartialListing().length;
            }

            @Override
            public LocatedFileStatus next() throws IOException {
                if (this.hasNext()) {
                    LocatedFileStatus tmp = this.curStat;
                    this.curStat = null;
                    return tmp;
                }
                throw new NoSuchElementException("No more entry in " + p);
            }
        };
    }

    public boolean mkdir(Path f, FsPermission permission) throws IOException {
        return this.mkdirsInternal(f, permission, false);
    }

    @Override
    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        return this.mkdirsInternal(f, permission, true);
    }

    private boolean mkdirsInternal(Path f, final FsPermission permission, final boolean createParent) throws IOException {
        this.statistics.incrementWriteOps(1);
        Path absF = this.fixRelativePart(f);
        return (Boolean)new FileSystemLinkResolver<Boolean>(){

            @Override
            public Boolean doCall(Path p) throws IOException, UnresolvedLinkException {
                return DistributedFileSystem.this.dfs.mkdirs(DistributedFileSystem.this.getPathName(p), permission, createParent);
            }

            @Override
            public Boolean next(FileSystem fs, Path p) throws IOException {
                if (!createParent) {
                    throw new IOException("FileSystem does not support non-recursivemkdir");
                }
                return fs.mkdirs(p, permission);
            }
        }.resolve(this, absF);
    }

    @Override
    protected boolean primitiveMkdir(Path f, FsPermission absolutePermission) throws IOException {
        this.statistics.incrementWriteOps(1);
        return this.dfs.primitiveMkdir(this.getPathName(f), absolutePermission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            super.processDeleteOnExit();
            this.dfs.close();
        }
        finally {
            super.close();
        }
    }

    public String toString() {
        return "DFS[" + this.dfs + "]";
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public DFSClient getClient() {
        return this.dfs;
    }

    @Override
    public FsStatus getStatus(Path p) throws IOException {
        this.statistics.incrementReadOps(1);
        return this.dfs.getDiskStatus();
    }

    @Deprecated
    public DiskStatus getDiskStatus() throws IOException {
        return new DiskStatus(this.dfs.getDiskStatus());
    }

    @Deprecated
    public long getRawCapacity() throws IOException {
        return this.dfs.getDiskStatus().getCapacity();
    }

    @Deprecated
    public long getRawUsed() throws IOException {
        return this.dfs.getDiskStatus().getUsed();
    }

    public long getMissingBlocksCount() throws IOException {
        return this.dfs.getMissingBlocksCount();
    }

    public long getUnderReplicatedBlocksCount() throws IOException {
        return this.dfs.getUnderReplicatedBlocksCount();
    }

    public long getCorruptBlocksCount() throws IOException {
        return this.dfs.getCorruptBlocksCount();
    }

    @Override
    public RemoteIterator<Path> listCorruptFileBlocks(Path path) throws IOException {
        return new CorruptFileBlockIterator(this.dfs, path);
    }

    public DatanodeInfo[] getDataNodeStats() throws IOException {
        return this.getDataNodeStats(HdfsConstants.DatanodeReportType.ALL);
    }

    public DatanodeInfo[] getDataNodeStats(HdfsConstants.DatanodeReportType type) throws IOException {
        return this.dfs.datanodeReport(type);
    }

    public boolean setSafeMode(HdfsConstants.SafeModeAction action) throws IOException {
        return this.setSafeMode(action, false);
    }

    public boolean setSafeMode(HdfsConstants.SafeModeAction action, boolean isChecked) throws IOException {
        return this.dfs.setSafeMode(action, isChecked);
    }

    public void saveNamespace() throws AccessControlException, IOException {
        this.dfs.saveNamespace();
    }

    public long rollEdits() throws AccessControlException, IOException {
        return this.dfs.rollEdits();
    }

    public boolean restoreFailedStorage(String arg) throws AccessControlException, IOException {
        return this.dfs.restoreFailedStorage(arg);
    }

    public void refreshNodes() throws IOException {
        this.dfs.refreshNodes();
    }

    public void finalizeUpgrade() throws IOException {
        this.dfs.finalizeUpgrade();
    }

    public RollingUpgradeInfo rollingUpgrade(HdfsConstants.RollingUpgradeAction action) throws IOException {
        return this.dfs.rollingUpgrade(action);
    }

    public void metaSave(String pathname) throws IOException {
        this.dfs.metaSave(pathname);
    }

    @Override
    public FsServerDefaults getServerDefaults() throws IOException {
        return this.dfs.getServerDefaults();
    }

    @Deprecated
    public boolean reportChecksumFailure(Path f, FSDataInputStream in, long inPos, FSDataInputStream sums, long sumsPos) {
        if (!(in instanceof HdfsDataInputStream) || !(sums instanceof HdfsDataInputStream)) {
            throw new IllegalArgumentException("Input streams must be types of HdfsDataInputStream");
        }
        LocatedBlock[] lblocks = new LocatedBlock[2];
        HdfsDataInputStream dfsIn = (HdfsDataInputStream)in;
        ExtendedBlock dataBlock = dfsIn.getCurrentBlock();
        if (dataBlock == null) {
            LOG.error((Object)"Error: Current block in data stream is null! ");
            return false;
        }
        DatanodeInfo[] dataNode = new DatanodeInfo[]{dfsIn.getCurrentDatanode()};
        lblocks[0] = new LocatedBlock(dataBlock, dataNode);
        LOG.info((Object)("Found checksum error in data stream at " + dataBlock + " on datanode=" + dataNode[0]));
        HdfsDataInputStream dfsSums = (HdfsDataInputStream)sums;
        ExtendedBlock sumsBlock = dfsSums.getCurrentBlock();
        if (sumsBlock == null) {
            LOG.error((Object)"Error: Current block in checksum stream is null! ");
            return false;
        }
        DatanodeInfo[] sumsNode = new DatanodeInfo[]{dfsSums.getCurrentDatanode()};
        lblocks[1] = new LocatedBlock(sumsBlock, sumsNode);
        LOG.info((Object)("Found checksum error in checksum stream at " + sumsBlock + " on datanode=" + sumsNode[0]));
        this.dfs.reportChecksumFailure(f.toString(), lblocks);
        return true;
    }

    @Override
    public FileStatus getFileStatus(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        Path absF = this.fixRelativePart(f);
        return (FileStatus)new FileSystemLinkResolver<FileStatus>(){

            @Override
            public FileStatus doCall(Path p) throws IOException, UnresolvedLinkException {
                HdfsFileStatus fi = DistributedFileSystem.this.dfs.getFileInfo(DistributedFileSystem.this.getPathName(p));
                if (fi != null) {
                    return fi.makeQualified(DistributedFileSystem.this.getUri(), p);
                }
                throw new FileNotFoundException("File does not exist: " + p);
            }

            @Override
            public FileStatus next(FileSystem fs, Path p) throws IOException {
                return fs.getFileStatus(p);
            }
        }.resolve(this, absF);
    }

    @Override
    public void createSymlink(final Path target, Path link, final boolean createParent) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnsupportedFileSystemException, IOException {
        if (!FileSystem.areSymlinksEnabled()) {
            throw new UnsupportedOperationException("Symlinks not supported");
        }
        this.statistics.incrementWriteOps(1);
        Path absF = this.fixRelativePart(link);
        new FileSystemLinkResolver<Void>(){

            @Override
            public Void doCall(Path p) throws IOException, UnresolvedLinkException {
                DistributedFileSystem.this.dfs.createSymlink(target.toString(), DistributedFileSystem.this.getPathName(p), createParent);
                return null;
            }

            @Override
            public Void next(FileSystem fs, Path p) throws IOException, UnresolvedLinkException {
                fs.createSymlink(target, p, createParent);
                return null;
            }
        }.resolve(this, absF);
    }

    @Override
    public boolean supportsSymlinks() {
        return true;
    }

    @Override
    public FileStatus getFileLinkStatus(Path f) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        this.statistics.incrementReadOps(1);
        Path absF = this.fixRelativePart(f);
        FileStatus status = (FileStatus)new FileSystemLinkResolver<FileStatus>(){

            @Override
            public FileStatus doCall(Path p) throws IOException, UnresolvedLinkException {
                HdfsFileStatus fi = DistributedFileSystem.this.dfs.getFileLinkInfo(DistributedFileSystem.this.getPathName(p));
                if (fi != null) {
                    return fi.makeQualified(DistributedFileSystem.this.getUri(), p);
                }
                throw new FileNotFoundException("File does not exist: " + p);
            }

            @Override
            public FileStatus next(FileSystem fs, Path p) throws IOException, UnresolvedLinkException {
                return fs.getFileLinkStatus(p);
            }
        }.resolve(this, absF);
        if (status.isSymlink()) {
            Path targetQual = FSLinkResolver.qualifySymlinkTarget(this.getUri(), status.getPath(), status.getSymlink());
            status.setSymlink(targetQual);
        }
        return status;
    }

    @Override
    public Path getLinkTarget(Path f) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        this.statistics.incrementReadOps(1);
        Path absF = this.fixRelativePart(f);
        return (Path)new FileSystemLinkResolver<Path>(){

            @Override
            public Path doCall(Path p) throws IOException, UnresolvedLinkException {
                HdfsFileStatus fi = DistributedFileSystem.this.dfs.getFileLinkInfo(DistributedFileSystem.this.getPathName(p));
                if (fi != null) {
                    return fi.makeQualified(DistributedFileSystem.this.getUri(), p).getSymlink();
                }
                throw new FileNotFoundException("File does not exist: " + p);
            }

            @Override
            public Path next(FileSystem fs, Path p) throws IOException, UnresolvedLinkException {
                return fs.getLinkTarget(p);
            }
        }.resolve(this, absF);
    }

    @Override
    protected Path resolveLink(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        String target = this.dfs.getLinkTarget(this.getPathName(this.fixRelativePart(f)));
        if (target == null) {
            throw new FileNotFoundException("File does not exist: " + f.toString());
        }
        return new Path(target);
    }

    @Override
    public FileChecksum getFileChecksum(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        Path absF = this.fixRelativePart(f);
        return (FileChecksum)new FileSystemLinkResolver<FileChecksum>(){

            @Override
            public FileChecksum doCall(Path p) throws IOException, UnresolvedLinkException {
                return DistributedFileSystem.this.dfs.getFileChecksum(DistributedFileSystem.this.getPathName(p));
            }

            @Override
            public FileChecksum next(FileSystem fs, Path p) throws IOException {
                return fs.getFileChecksum(p);
            }
        }.resolve(this, absF);
    }

    @Override
    public void setPermission(Path p, final FsPermission permission) throws IOException {
        this.statistics.incrementWriteOps(1);
        Path absF = this.fixRelativePart(p);
        new FileSystemLinkResolver<Void>(){

            @Override
            public Void doCall(Path p) throws IOException, UnresolvedLinkException {
                DistributedFileSystem.this.dfs.setPermission(DistributedFileSystem.this.getPathName(p), permission);
                return null;
            }

            @Override
            public Void next(FileSystem fs, Path p) throws IOException {
                fs.setPermission(p, permission);
                return null;
            }
        }.resolve(this, absF);
    }

    @Override
    public void setOwner(Path p, final String username, final String groupname) throws IOException {
        if (username == null && groupname == null) {
            throw new IOException("username == null && groupname == null");
        }
        this.statistics.incrementWriteOps(1);
        Path absF = this.fixRelativePart(p);
        new FileSystemLinkResolver<Void>(){

            @Override
            public Void doCall(Path p) throws IOException, UnresolvedLinkException {
                DistributedFileSystem.this.dfs.setOwner(DistributedFileSystem.this.getPathName(p), username, groupname);
                return null;
            }

            @Override
            public Void next(FileSystem fs, Path p) throws IOException {
                fs.setOwner(p, username, groupname);
                return null;
            }
        }.resolve(this, absF);
    }

    @Override
    public void setTimes(Path p, final long mtime, final long atime) throws IOException {
        this.statistics.incrementWriteOps(1);
        Path absF = this.fixRelativePart(p);
        new FileSystemLinkResolver<Void>(){

            @Override
            public Void doCall(Path p) throws IOException, UnresolvedLinkException {
                DistributedFileSystem.this.dfs.setTimes(DistributedFileSystem.this.getPathName(p), mtime, atime);
                return null;
            }

            @Override
            public Void next(FileSystem fs, Path p) throws IOException {
                fs.setTimes(p, mtime, atime);
                return null;
            }
        }.resolve(this, absF);
    }

    @Override
    protected int getDefaultPort() {
        return 8020;
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(String renewer) throws IOException {
        Token<DelegationTokenIdentifier> result = this.dfs.getDelegationToken(renewer == null ? null : new Text(renewer));
        return result;
    }

    @Deprecated
    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        return this.getDelegationToken(renewer.toString());
    }

    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException {
        try {
            return token.renew(this.getConf());
        }
        catch (InterruptedException ie) {
            throw new RuntimeException("Caught interrupted", ie);
        }
    }

    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        try {
            token.cancel(this.getConf());
        }
        catch (InterruptedException ie) {
            throw new RuntimeException("Caught interrupted", ie);
        }
    }

    public void setBalancerBandwidth(long bandwidth) throws IOException {
        this.dfs.setBalancerBandwidth(bandwidth);
    }

    @Override
    public String getCanonicalServiceName() {
        return this.dfs.getCanonicalServiceName();
    }

    @Override
    protected URI canonicalizeUri(URI uri) {
        if (HAUtil.isLogicalUri(this.getConf(), uri)) {
            return uri;
        }
        return NetUtils.getCanonicalUri(uri, this.getDefaultPort());
    }

    public boolean isInSafeMode() throws IOException {
        return this.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_GET, true);
    }

    public void allowSnapshot(final Path path) throws IOException {
        Path absF = this.fixRelativePart(path);
        new FileSystemLinkResolver<Void>(){

            @Override
            public Void doCall(Path p) throws IOException, UnresolvedLinkException {
                DistributedFileSystem.this.dfs.allowSnapshot(DistributedFileSystem.this.getPathName(p));
                return null;
            }

            @Override
            public Void next(FileSystem fs, Path p) throws IOException {
                if (!(fs instanceof DistributedFileSystem)) {
                    throw new UnsupportedOperationException("Cannot perform snapshot operations on a symlink to a non-DistributedFileSystem: " + path + " -> " + p);
                }
                DistributedFileSystem myDfs = (DistributedFileSystem)fs;
                myDfs.allowSnapshot(p);
                return null;
            }
        }.resolve(this, absF);
    }

    public void disallowSnapshot(final Path path) throws IOException {
        Path absF = this.fixRelativePart(path);
        new FileSystemLinkResolver<Void>(){

            @Override
            public Void doCall(Path p) throws IOException, UnresolvedLinkException {
                DistributedFileSystem.this.dfs.disallowSnapshot(DistributedFileSystem.this.getPathName(p));
                return null;
            }

            @Override
            public Void next(FileSystem fs, Path p) throws IOException {
                if (!(fs instanceof DistributedFileSystem)) {
                    throw new UnsupportedOperationException("Cannot perform snapshot operations on a symlink to a non-DistributedFileSystem: " + path + " -> " + p);
                }
                DistributedFileSystem myDfs = (DistributedFileSystem)fs;
                myDfs.disallowSnapshot(p);
                return null;
            }
        }.resolve(this, absF);
    }

    @Override
    public Path createSnapshot(final Path path, final String snapshotName) throws IOException {
        Path absF = this.fixRelativePart(path);
        return (Path)new FileSystemLinkResolver<Path>(){

            @Override
            public Path doCall(Path p) throws IOException, UnresolvedLinkException {
                return new Path(DistributedFileSystem.this.dfs.createSnapshot(DistributedFileSystem.this.getPathName(p), snapshotName));
            }

            @Override
            public Path next(FileSystem fs, Path p) throws IOException {
                if (fs instanceof DistributedFileSystem) {
                    DistributedFileSystem myDfs = (DistributedFileSystem)fs;
                    return myDfs.createSnapshot(p);
                }
                throw new UnsupportedOperationException("Cannot perform snapshot operations on a symlink to a non-DistributedFileSystem: " + path + " -> " + p);
            }
        }.resolve(this, absF);
    }

    @Override
    public void renameSnapshot(final Path path, final String snapshotOldName, final String snapshotNewName) throws IOException {
        Path absF = this.fixRelativePart(path);
        new FileSystemLinkResolver<Void>(){

            @Override
            public Void doCall(Path p) throws IOException, UnresolvedLinkException {
                DistributedFileSystem.this.dfs.renameSnapshot(DistributedFileSystem.this.getPathName(p), snapshotOldName, snapshotNewName);
                return null;
            }

            @Override
            public Void next(FileSystem fs, Path p) throws IOException {
                if (!(fs instanceof DistributedFileSystem)) {
                    throw new UnsupportedOperationException("Cannot perform snapshot operations on a symlink to a non-DistributedFileSystem: " + path + " -> " + p);
                }
                DistributedFileSystem myDfs = (DistributedFileSystem)fs;
                myDfs.renameSnapshot(p, snapshotOldName, snapshotNewName);
                return null;
            }
        }.resolve(this, absF);
    }

    public SnapshottableDirectoryStatus[] getSnapshottableDirListing() throws IOException {
        return this.dfs.getSnapshottableDirListing();
    }

    @Override
    public void deleteSnapshot(final Path snapshotDir, final String snapshotName) throws IOException {
        Path absF = this.fixRelativePart(snapshotDir);
        new FileSystemLinkResolver<Void>(){

            @Override
            public Void doCall(Path p) throws IOException, UnresolvedLinkException {
                DistributedFileSystem.this.dfs.deleteSnapshot(DistributedFileSystem.this.getPathName(p), snapshotName);
                return null;
            }

            @Override
            public Void next(FileSystem fs, Path p) throws IOException {
                if (!(fs instanceof DistributedFileSystem)) {
                    throw new UnsupportedOperationException("Cannot perform snapshot operations on a symlink to a non-DistributedFileSystem: " + snapshotDir + " -> " + p);
                }
                DistributedFileSystem myDfs = (DistributedFileSystem)fs;
                myDfs.deleteSnapshot(p, snapshotName);
                return null;
            }
        }.resolve(this, absF);
    }

    public SnapshotDiffReport getSnapshotDiffReport(final Path snapshotDir, final String fromSnapshot, final String toSnapshot) throws IOException {
        Path absF = this.fixRelativePart(snapshotDir);
        return (SnapshotDiffReport)new FileSystemLinkResolver<SnapshotDiffReport>(){

            @Override
            public SnapshotDiffReport doCall(Path p) throws IOException, UnresolvedLinkException {
                return DistributedFileSystem.this.dfs.getSnapshotDiffReport(DistributedFileSystem.this.getPathName(p), fromSnapshot, toSnapshot);
            }

            @Override
            public SnapshotDiffReport next(FileSystem fs, Path p) throws IOException {
                if (!(fs instanceof DistributedFileSystem)) {
                    throw new UnsupportedOperationException("Cannot perform snapshot operations on a symlink to a non-DistributedFileSystem: " + snapshotDir + " -> " + p);
                }
                DistributedFileSystem myDfs = (DistributedFileSystem)fs;
                myDfs.getSnapshotDiffReport(p, fromSnapshot, toSnapshot);
                return null;
            }
        }.resolve(this, absF);
    }

    public boolean isFileClosed(final Path src) throws IOException {
        Path absF = this.fixRelativePart(src);
        return (Boolean)new FileSystemLinkResolver<Boolean>(){

            @Override
            public Boolean doCall(Path p) throws IOException, UnresolvedLinkException {
                return DistributedFileSystem.this.dfs.isFileClosed(DistributedFileSystem.this.getPathName(p));
            }

            @Override
            public Boolean next(FileSystem fs, Path p) throws IOException {
                if (fs instanceof DistributedFileSystem) {
                    DistributedFileSystem myDfs = (DistributedFileSystem)fs;
                    return myDfs.isFileClosed(p);
                }
                throw new UnsupportedOperationException("Cannot call isFileClosed on a symlink to a non-DistributedFileSystem: " + src + " -> " + p);
            }
        }.resolve(this, absF);
    }

    public long addCacheDirective(CacheDirectiveInfo info) throws IOException {
        return this.addCacheDirective(info, EnumSet.noneOf(CacheFlag.class));
    }

    public long addCacheDirective(CacheDirectiveInfo info, EnumSet<CacheFlag> flags) throws IOException {
        Preconditions.checkNotNull(info.getPath());
        Path path = new Path(this.getPathName(this.fixRelativePart(info.getPath()))).makeQualified(this.getUri(), this.getWorkingDirectory());
        return this.dfs.addCacheDirective(new CacheDirectiveInfo.Builder(info).setPath(path).build(), flags);
    }

    public void modifyCacheDirective(CacheDirectiveInfo info) throws IOException {
        this.modifyCacheDirective(info, EnumSet.noneOf(CacheFlag.class));
    }

    public void modifyCacheDirective(CacheDirectiveInfo info, EnumSet<CacheFlag> flags) throws IOException {
        if (info.getPath() != null) {
            info = new CacheDirectiveInfo.Builder(info).setPath(new Path(this.getPathName(this.fixRelativePart(info.getPath()))).makeQualified(this.getUri(), this.getWorkingDirectory())).build();
        }
        this.dfs.modifyCacheDirective(info, flags);
    }

    public void removeCacheDirective(long id) throws IOException {
        this.dfs.removeCacheDirective(id);
    }

    public RemoteIterator<CacheDirectiveEntry> listCacheDirectives(CacheDirectiveInfo filter) throws IOException {
        if (filter == null) {
            filter = new CacheDirectiveInfo.Builder().build();
        }
        if (filter.getPath() != null) {
            filter = new CacheDirectiveInfo.Builder(filter).setPath(new Path(this.getPathName(this.fixRelativePart(filter.getPath())))).build();
        }
        final RemoteIterator<CacheDirectiveEntry> iter = this.dfs.listCacheDirectives(filter);
        return new RemoteIterator<CacheDirectiveEntry>(){

            @Override
            public boolean hasNext() throws IOException {
                return iter.hasNext();
            }

            @Override
            public CacheDirectiveEntry next() throws IOException {
                CacheDirectiveEntry desc = (CacheDirectiveEntry)iter.next();
                CacheDirectiveInfo info = desc.getInfo();
                Path p = info.getPath().makeQualified(DistributedFileSystem.this.getUri(), DistributedFileSystem.this.getWorkingDirectory());
                return new CacheDirectiveEntry(new CacheDirectiveInfo.Builder(info).setPath(p).build(), desc.getStats());
            }
        };
    }

    public void addCachePool(CachePoolInfo info) throws IOException {
        CachePoolInfo.validate(info);
        this.dfs.addCachePool(info);
    }

    public void modifyCachePool(CachePoolInfo info) throws IOException {
        CachePoolInfo.validate(info);
        this.dfs.modifyCachePool(info);
    }

    public void removeCachePool(String poolName) throws IOException {
        CachePoolInfo.validateName(poolName);
        this.dfs.removeCachePool(poolName);
    }

    public RemoteIterator<CachePoolEntry> listCachePools() throws IOException {
        return this.dfs.listCachePools();
    }

    @Override
    public void modifyAclEntries(Path path, final List<AclEntry> aclSpec) throws IOException {
        Path absF = this.fixRelativePart(path);
        new FileSystemLinkResolver<Void>(){

            @Override
            public Void doCall(Path p) throws IOException {
                DistributedFileSystem.this.dfs.modifyAclEntries(DistributedFileSystem.this.getPathName(p), aclSpec);
                return null;
            }

            @Override
            public Void next(FileSystem fs, Path p) throws IOException {
                fs.modifyAclEntries(p, aclSpec);
                return null;
            }
        }.resolve(this, absF);
    }

    @Override
    public void removeAclEntries(Path path, final List<AclEntry> aclSpec) throws IOException {
        Path absF = this.fixRelativePart(path);
        new FileSystemLinkResolver<Void>(){

            @Override
            public Void doCall(Path p) throws IOException {
                DistributedFileSystem.this.dfs.removeAclEntries(DistributedFileSystem.this.getPathName(p), aclSpec);
                return null;
            }

            @Override
            public Void next(FileSystem fs, Path p) throws IOException {
                fs.removeAclEntries(p, aclSpec);
                return null;
            }
        }.resolve(this, absF);
    }

    @Override
    public void removeDefaultAcl(Path path) throws IOException {
        Path absF = this.fixRelativePart(path);
        new FileSystemLinkResolver<Void>(){

            @Override
            public Void doCall(Path p) throws IOException {
                DistributedFileSystem.this.dfs.removeDefaultAcl(DistributedFileSystem.this.getPathName(p));
                return null;
            }

            @Override
            public Void next(FileSystem fs, Path p) throws IOException, UnresolvedLinkException {
                fs.removeDefaultAcl(p);
                return null;
            }
        }.resolve(this, absF);
    }

    @Override
    public void removeAcl(Path path) throws IOException {
        Path absF = this.fixRelativePart(path);
        new FileSystemLinkResolver<Void>(){

            @Override
            public Void doCall(Path p) throws IOException {
                DistributedFileSystem.this.dfs.removeAcl(DistributedFileSystem.this.getPathName(p));
                return null;
            }

            @Override
            public Void next(FileSystem fs, Path p) throws IOException, UnresolvedLinkException {
                fs.removeAcl(p);
                return null;
            }
        }.resolve(this, absF);
    }

    @Override
    public void setAcl(Path path, final List<AclEntry> aclSpec) throws IOException {
        Path absF = this.fixRelativePart(path);
        new FileSystemLinkResolver<Void>(){

            @Override
            public Void doCall(Path p) throws IOException {
                DistributedFileSystem.this.dfs.setAcl(DistributedFileSystem.this.getPathName(p), aclSpec);
                return null;
            }

            @Override
            public Void next(FileSystem fs, Path p) throws IOException {
                fs.setAcl(p, aclSpec);
                return null;
            }
        }.resolve(this, absF);
    }

    @Override
    public AclStatus getAclStatus(Path path) throws IOException {
        Path absF = this.fixRelativePart(path);
        return (AclStatus)new FileSystemLinkResolver<AclStatus>(){

            @Override
            public AclStatus doCall(Path p) throws IOException {
                return DistributedFileSystem.this.dfs.getAclStatus(DistributedFileSystem.this.getPathName(p));
            }

            @Override
            public AclStatus next(FileSystem fs, Path p) throws IOException, UnresolvedLinkException {
                return fs.getAclStatus(p);
            }
        }.resolve(this, absF);
    }

    static {
        HdfsConfiguration.init();
    }

    @InterfaceAudience.Private
    @Deprecated
    public static class DiskStatus
    extends FsStatus {
        public DiskStatus(FsStatus stats) {
            super(stats.getCapacity(), stats.getUsed(), stats.getRemaining());
        }

        public DiskStatus(long capacity, long dfsUsed, long remaining) {
            super(capacity, dfsUsed, remaining);
        }

        public long getDfsUsed() {
            return super.getUsed();
        }
    }
}

