/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.web.resources;

import com.sun.jersey.spi.container.ResourceFilters;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivilegedExceptionAction;
import java.util.EnumSet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.client.HdfsDataInputStream;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.web.resources.OpenEntity;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.web.JsonUtil;
import org.apache.hadoop.hdfs.web.ParamFilter;
import org.apache.hadoop.hdfs.web.resources.BlockSizeParam;
import org.apache.hadoop.hdfs.web.resources.BufferSizeParam;
import org.apache.hadoop.hdfs.web.resources.DelegationParam;
import org.apache.hadoop.hdfs.web.resources.GetOpParam;
import org.apache.hadoop.hdfs.web.resources.HttpOpParam;
import org.apache.hadoop.hdfs.web.resources.LengthParam;
import org.apache.hadoop.hdfs.web.resources.NamenodeRpcAddressParam;
import org.apache.hadoop.hdfs.web.resources.OffsetParam;
import org.apache.hadoop.hdfs.web.resources.OverwriteParam;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.hdfs.web.resources.PermissionParam;
import org.apache.hadoop.hdfs.web.resources.PostOpParam;
import org.apache.hadoop.hdfs.web.resources.PutOpParam;
import org.apache.hadoop.hdfs.web.resources.ReplicationParam;
import org.apache.hadoop.hdfs.web.resources.UriFsPathParam;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;

@Path(value="")
@ResourceFilters(value={ParamFilter.class})
public class DatanodeWebHdfsMethods {
    public static final Log LOG = LogFactory.getLog(DatanodeWebHdfsMethods.class);
    private static final UriFsPathParam ROOT = new UriFsPathParam("");
    @Context
    private ServletContext context;
    @Context
    private HttpServletResponse response;

    private void init(UserGroupInformation ugi, DelegationParam delegation, InetSocketAddress nnRpcAddr, UriFsPathParam path, HttpOpParam<?> op, Param<?, ?> ... parameters) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("HTTP " + (Object)((Object)((HttpOpParam.Op)((Object)((Enum)op.getValue()))).getType()) + ": " + op + ", " + path + ", ugi=" + ugi + Param.toSortedString(", ", parameters)));
        }
        if (nnRpcAddr == null) {
            throw new IllegalArgumentException("namenoderpcaddress is not specified.");
        }
        this.response.setContentType(null);
        if (UserGroupInformation.isSecurityEnabled()) {
            Token token = new Token();
            token.decodeFromUrlString((String)delegation.getValue());
            SecurityUtil.setTokenService(token, nnRpcAddr);
            token.setKind(DelegationTokenIdentifier.HDFS_DELEGATION_KIND);
            ugi.addToken(token);
        }
    }

    @PUT
    @Path(value="/")
    @Consumes(value={"*/*"})
    @Produces(value={"application/octet-stream", "application/json"})
    public Response putRoot(InputStream in, @Context UserGroupInformation ugi, @QueryParam(value="delegation") @DefaultValue(value="") DelegationParam delegation, @QueryParam(value="namenoderpcaddress") @DefaultValue(value="") NamenodeRpcAddressParam namenodeRpcAddress, @QueryParam(value="op") @DefaultValue(value="null") PutOpParam op, @QueryParam(value="permission") @DefaultValue(value="null") PermissionParam permission, @QueryParam(value="overwrite") @DefaultValue(value="false") OverwriteParam overwrite, @QueryParam(value="buffersize") @DefaultValue(value="null") BufferSizeParam bufferSize, @QueryParam(value="replication") @DefaultValue(value="null") ReplicationParam replication, @QueryParam(value="blocksize") @DefaultValue(value="null") BlockSizeParam blockSize) throws IOException, InterruptedException {
        return this.put(in, ugi, delegation, namenodeRpcAddress, ROOT, op, permission, overwrite, bufferSize, replication, blockSize);
    }

    @PUT
    @Path(value="{path:.*}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/octet-stream", "application/json"})
    public Response put(final InputStream in, final @Context UserGroupInformation ugi, final @QueryParam(value="delegation") @DefaultValue(value="") DelegationParam delegation, @QueryParam(value="namenoderpcaddress") @DefaultValue(value="") NamenodeRpcAddressParam namenodeRpcAddress, final @PathParam(value="path") UriFsPathParam path, final @QueryParam(value="op") @DefaultValue(value="null") PutOpParam op, final @QueryParam(value="permission") @DefaultValue(value="null") PermissionParam permission, final @QueryParam(value="overwrite") @DefaultValue(value="false") OverwriteParam overwrite, final @QueryParam(value="buffersize") @DefaultValue(value="null") BufferSizeParam bufferSize, final @QueryParam(value="replication") @DefaultValue(value="null") ReplicationParam replication, final @QueryParam(value="blocksize") @DefaultValue(value="null") BlockSizeParam blockSize) throws IOException, InterruptedException {
        final InetSocketAddress nnRpcAddr = (InetSocketAddress)namenodeRpcAddress.getValue();
        this.init(ugi, delegation, nnRpcAddr, path, op, permission, overwrite, bufferSize, replication, blockSize);
        return ugi.doAs(new PrivilegedExceptionAction<Response>(){

            @Override
            public Response run() throws IOException, URISyntaxException {
                return DatanodeWebHdfsMethods.this.put(in, ugi, delegation, nnRpcAddr, path.getAbsolutePath(), op, permission, overwrite, bufferSize, replication, blockSize);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response put(InputStream in, UserGroupInformation ugi, DelegationParam delegation, InetSocketAddress nnRpcAddr, String fullpath, PutOpParam op, PermissionParam permission, OverwriteParam overwrite, BufferSizeParam bufferSize, ReplicationParam replication, BlockSizeParam blockSize) throws IOException, URISyntaxException {
        DataNode datanode = (DataNode)this.context.getAttribute("datanode");
        switch ((PutOpParam.Op)op.getValue()) {
            case CREATE: {
                Configuration conf = new Configuration(datanode.getConf());
                conf.set("fs.permissions.umask-mode", "000");
                int b = bufferSize.getValue(conf);
                DFSClient dfsclient = new DFSClient(nnRpcAddr, conf);
                FSDataOutputStream out = null;
                try {
                    out = new FSDataOutputStream(dfsclient.create(fullpath, permission.getFsPermission(), (Boolean)overwrite.getValue() != false ? EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE) : EnumSet.of(CreateFlag.CREATE), replication.getValue(conf), blockSize.getValue(conf), null, b, null), null);
                    IOUtils.copyBytes(in, (OutputStream)out, b);
                    out.close();
                    out = null;
                    dfsclient.close();
                    dfsclient = null;
                }
                catch (Throwable throwable) {
                    IOUtils.cleanup(LOG, out);
                    IOUtils.cleanup(LOG, dfsclient);
                    throw throwable;
                }
                IOUtils.cleanup(LOG, out);
                IOUtils.cleanup(LOG, dfsclient);
                InetSocketAddress nnHttpAddr = NameNode.getHttpAddress(conf);
                URI uri = new URI("webhdfs", null, nnHttpAddr.getHostName(), nnHttpAddr.getPort(), fullpath, null, null);
                return Response.created((URI)uri).type("application/octet-stream").build();
            }
        }
        throw new UnsupportedOperationException(op + " is not supported");
    }

    @POST
    @Path(value="/")
    @Consumes(value={"*/*"})
    @Produces(value={"application/octet-stream", "application/json"})
    public Response postRoot(InputStream in, @Context UserGroupInformation ugi, @QueryParam(value="delegation") @DefaultValue(value="") DelegationParam delegation, @QueryParam(value="namenoderpcaddress") @DefaultValue(value="") NamenodeRpcAddressParam namenodeRpcAddress, @QueryParam(value="op") @DefaultValue(value="null") PostOpParam op, @QueryParam(value="buffersize") @DefaultValue(value="null") BufferSizeParam bufferSize) throws IOException, InterruptedException {
        return this.post(in, ugi, delegation, namenodeRpcAddress, ROOT, op, bufferSize);
    }

    @POST
    @Path(value="{path:.*}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/octet-stream", "application/json"})
    public Response post(final InputStream in, final @Context UserGroupInformation ugi, final @QueryParam(value="delegation") @DefaultValue(value="") DelegationParam delegation, @QueryParam(value="namenoderpcaddress") @DefaultValue(value="") NamenodeRpcAddressParam namenodeRpcAddress, final @PathParam(value="path") UriFsPathParam path, final @QueryParam(value="op") @DefaultValue(value="null") PostOpParam op, final @QueryParam(value="buffersize") @DefaultValue(value="null") BufferSizeParam bufferSize) throws IOException, InterruptedException {
        final InetSocketAddress nnRpcAddr = (InetSocketAddress)namenodeRpcAddress.getValue();
        this.init(ugi, delegation, nnRpcAddr, path, op, bufferSize);
        return ugi.doAs(new PrivilegedExceptionAction<Response>(){

            @Override
            public Response run() throws IOException {
                return DatanodeWebHdfsMethods.this.post(in, ugi, delegation, nnRpcAddr, path.getAbsolutePath(), op, bufferSize);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response post(InputStream in, UserGroupInformation ugi, DelegationParam delegation, InetSocketAddress nnRpcAddr, String fullpath, PostOpParam op, BufferSizeParam bufferSize) throws IOException {
        DataNode datanode = (DataNode)this.context.getAttribute("datanode");
        switch ((PostOpParam.Op)op.getValue()) {
            case APPEND: {
                Configuration conf = new Configuration(datanode.getConf());
                int b = bufferSize.getValue(conf);
                DFSClient dfsclient = new DFSClient(nnRpcAddr, conf);
                HdfsDataOutputStream out = null;
                try {
                    out = dfsclient.append(fullpath, b, null, null);
                    IOUtils.copyBytes(in, (OutputStream)out, b);
                    out.close();
                    out = null;
                    dfsclient.close();
                    dfsclient = null;
                }
                catch (Throwable throwable) {
                    IOUtils.cleanup(LOG, out);
                    IOUtils.cleanup(LOG, dfsclient);
                    throw throwable;
                }
                IOUtils.cleanup(LOG, out);
                IOUtils.cleanup(LOG, dfsclient);
                return Response.ok().type("application/octet-stream").build();
            }
        }
        throw new UnsupportedOperationException(op + " is not supported");
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/octet-stream", "application/json"})
    public Response getRoot(@Context UserGroupInformation ugi, @QueryParam(value="delegation") @DefaultValue(value="") DelegationParam delegation, @QueryParam(value="namenoderpcaddress") @DefaultValue(value="") NamenodeRpcAddressParam namenodeRpcAddress, @QueryParam(value="op") @DefaultValue(value="null") GetOpParam op, @QueryParam(value="offset") @DefaultValue(value="0") OffsetParam offset, @QueryParam(value="length") @DefaultValue(value="null") LengthParam length, @QueryParam(value="buffersize") @DefaultValue(value="null") BufferSizeParam bufferSize) throws IOException, InterruptedException {
        return this.get(ugi, delegation, namenodeRpcAddress, ROOT, op, offset, length, bufferSize);
    }

    @GET
    @Path(value="{path:.*}")
    @Produces(value={"application/octet-stream", "application/json"})
    public Response get(final @Context UserGroupInformation ugi, final @QueryParam(value="delegation") @DefaultValue(value="") DelegationParam delegation, @QueryParam(value="namenoderpcaddress") @DefaultValue(value="") NamenodeRpcAddressParam namenodeRpcAddress, final @PathParam(value="path") UriFsPathParam path, final @QueryParam(value="op") @DefaultValue(value="null") GetOpParam op, final @QueryParam(value="offset") @DefaultValue(value="0") OffsetParam offset, final @QueryParam(value="length") @DefaultValue(value="null") LengthParam length, final @QueryParam(value="buffersize") @DefaultValue(value="null") BufferSizeParam bufferSize) throws IOException, InterruptedException {
        final InetSocketAddress nnRpcAddr = (InetSocketAddress)namenodeRpcAddress.getValue();
        this.init(ugi, delegation, nnRpcAddr, path, op, offset, length, bufferSize);
        return ugi.doAs(new PrivilegedExceptionAction<Response>(){

            @Override
            public Response run() throws IOException {
                return DatanodeWebHdfsMethods.this.get(ugi, delegation, nnRpcAddr, path.getAbsolutePath(), op, offset, length, bufferSize);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response get(UserGroupInformation ugi, DelegationParam delegation, InetSocketAddress nnRpcAddr, String fullpath, GetOpParam op, OffsetParam offset, LengthParam length, BufferSizeParam bufferSize) throws IOException {
        DataNode datanode = (DataNode)this.context.getAttribute("datanode");
        Configuration conf = new Configuration(datanode.getConf());
        switch ((GetOpParam.Op)op.getValue()) {
            case OPEN: {
                int b = bufferSize.getValue(conf);
                DFSClient dfsclient = new DFSClient(nnRpcAddr, conf);
                HdfsDataInputStream in = null;
                try {
                    in = new HdfsDataInputStream(dfsclient.open(fullpath, b, true));
                    in.seek((Long)offset.getValue());
                }
                catch (IOException ioe) {
                    IOUtils.cleanup(LOG, in);
                    IOUtils.cleanup(LOG, dfsclient);
                    throw ioe;
                }
                long n = length.getValue() != null ? Math.min((Long)length.getValue(), in.getVisibleLength() - (Long)offset.getValue()) : in.getVisibleLength() - (Long)offset.getValue();
                return Response.ok((Object)new OpenEntity(in, n, dfsclient)).type("application/octet-stream").header("Access-Control-Allow-Methods", (Object)"GET").header("Access-Control-Allow-Origin", (Object)"*").build();
            }
            case GETFILECHECKSUM: {
                MD5MD5CRC32FileChecksum checksum = null;
                DFSClient dfsclient = new DFSClient(nnRpcAddr, conf);
                try {
                    checksum = dfsclient.getFileChecksum(fullpath);
                    dfsclient.close();
                    dfsclient = null;
                }
                catch (Throwable throwable) {
                    IOUtils.cleanup(LOG, dfsclient);
                    throw throwable;
                }
                IOUtils.cleanup(LOG, dfsclient);
                String js = JsonUtil.toJsonString(checksum);
                return Response.ok((Object)js).type("application/json").build();
            }
        }
        throw new UnsupportedOperationException(op + " is not supported");
    }
}

