/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import org.apache.flink.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DatanodeID
implements Comparable<DatanodeID> {
    public static final DatanodeID[] EMPTY_ARRAY = new DatanodeID[0];
    private String ipAddr;
    private String hostName;
    private String peerHostName;
    private int xferPort;
    private int infoPort;
    private int infoSecurePort;
    private int ipcPort;
    private String datanodeUuid = null;

    public DatanodeID(DatanodeID from) {
        this(from.getIpAddr(), from.getHostName(), from.getDatanodeUuid(), from.getXferPort(), from.getInfoPort(), from.getInfoSecurePort(), from.getIpcPort());
        this.peerHostName = from.getPeerHostName();
    }

    public DatanodeID(String ipAddr, String hostName, String datanodeUuid, int xferPort, int infoPort, int infoSecurePort, int ipcPort) {
        this.ipAddr = ipAddr;
        this.hostName = hostName;
        this.datanodeUuid = this.checkDatanodeUuid(datanodeUuid);
        this.xferPort = xferPort;
        this.infoPort = infoPort;
        this.infoSecurePort = infoSecurePort;
        this.ipcPort = ipcPort;
    }

    public void setIpAddr(String ipAddr) {
        this.ipAddr = ipAddr;
    }

    public void setPeerHostName(String peerHostName) {
        this.peerHostName = peerHostName;
    }

    public String getDatanodeUuid() {
        return this.datanodeUuid;
    }

    @VisibleForTesting
    public void setDatanodeUuidForTesting(String datanodeUuid) {
        this.datanodeUuid = datanodeUuid;
    }

    private String checkDatanodeUuid(String uuid) {
        if (uuid == null || uuid.isEmpty()) {
            return null;
        }
        return uuid;
    }

    public String getIpAddr() {
        return this.ipAddr;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getPeerHostName() {
        return this.peerHostName;
    }

    public String getXferAddr() {
        return this.ipAddr + ":" + this.xferPort;
    }

    private String getIpcAddr() {
        return this.ipAddr + ":" + this.ipcPort;
    }

    public String getInfoAddr() {
        return this.ipAddr + ":" + this.infoPort;
    }

    public String getInfoSecureAddr() {
        return this.ipAddr + ":" + this.infoSecurePort;
    }

    public String getXferAddrWithHostname() {
        return this.hostName + ":" + this.xferPort;
    }

    private String getIpcAddrWithHostname() {
        return this.hostName + ":" + this.ipcPort;
    }

    public String getXferAddr(boolean useHostname) {
        return useHostname ? this.getXferAddrWithHostname() : this.getXferAddr();
    }

    public String getIpcAddr(boolean useHostname) {
        return useHostname ? this.getIpcAddrWithHostname() : this.getIpcAddr();
    }

    public int getXferPort() {
        return this.xferPort;
    }

    public int getInfoPort() {
        return this.infoPort;
    }

    public int getInfoSecurePort() {
        return this.infoSecurePort;
    }

    public int getIpcPort() {
        return this.ipcPort;
    }

    public boolean equals(Object to) {
        if (this == to) {
            return true;
        }
        if (!(to instanceof DatanodeID)) {
            return false;
        }
        return this.getXferAddr().equals(((DatanodeID)to).getXferAddr()) && this.datanodeUuid.equals(((DatanodeID)to).getDatanodeUuid());
    }

    public int hashCode() {
        return this.getXferAddr().hashCode() ^ this.datanodeUuid.hashCode();
    }

    public String toString() {
        return this.getXferAddr();
    }

    public void updateRegInfo(DatanodeID nodeReg) {
        this.ipAddr = nodeReg.getIpAddr();
        this.hostName = nodeReg.getHostName();
        this.peerHostName = nodeReg.getPeerHostName();
        this.xferPort = nodeReg.getXferPort();
        this.infoPort = nodeReg.getInfoPort();
        this.infoSecurePort = nodeReg.getInfoSecurePort();
        this.ipcPort = nodeReg.getIpcPort();
    }

    @Override
    public int compareTo(DatanodeID that) {
        return this.getXferAddr().compareTo(that.getXferAddr());
    }
}

