/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.function.Consumer;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.ClusterOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.executiongraph.SlotProviderStrategy;
import org.apache.flink.runtime.jobgraph.ScheduleMode;
import org.apache.flink.runtime.jobmaster.slotpool.LocationPreferenceSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotProviderImpl;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotRequestBulkCheckerImpl;
import org.apache.flink.runtime.jobmaster.slotpool.PreviousAllocationSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SchedulerImpl;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;
import org.apache.flink.runtime.scheduler.DefaultExecutionSlotAllocatorFactory;
import org.apache.flink.runtime.scheduler.ExecutionSlotAllocatorFactory;
import org.apache.flink.runtime.scheduler.SlotSharingExecutionSlotAllocatorFactory;
import org.apache.flink.runtime.scheduler.strategy.EagerSchedulingStrategy;
import org.apache.flink.runtime.scheduler.strategy.LazyFromSourcesSchedulingStrategy;
import org.apache.flink.runtime.scheduler.strategy.PipelinedRegionSchedulingStrategy;
import org.apache.flink.runtime.scheduler.strategy.SchedulingStrategyFactory;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;

public class DefaultSchedulerComponents {
    private static final String PIPELINED_REGION_SCHEDULING = "region";
    private static final String LEGACY_SCHEDULING = "legacy";
    private final SchedulingStrategyFactory schedulingStrategyFactory;
    private final Consumer<ComponentMainThreadExecutor> startUpAction;
    private final ExecutionSlotAllocatorFactory allocatorFactory;

    private DefaultSchedulerComponents(SchedulingStrategyFactory schedulingStrategyFactory, Consumer<ComponentMainThreadExecutor> startUpAction, ExecutionSlotAllocatorFactory allocatorFactory) {
        this.schedulingStrategyFactory = schedulingStrategyFactory;
        this.startUpAction = startUpAction;
        this.allocatorFactory = allocatorFactory;
    }

    SchedulingStrategyFactory getSchedulingStrategyFactory() {
        return this.schedulingStrategyFactory;
    }

    Consumer<ComponentMainThreadExecutor> getStartUpAction() {
        return this.startUpAction;
    }

    ExecutionSlotAllocatorFactory getAllocatorFactory() {
        return this.allocatorFactory;
    }

    static DefaultSchedulerComponents createSchedulerComponents(ScheduleMode scheduleMode, boolean isApproximateLocalRecoveryEnabled, Configuration jobMasterConfiguration, SlotPool slotPool, Time slotRequestTimeout) {
        String schedulingStrategy;
        switch (schedulingStrategy = jobMasterConfiguration.getString(JobManagerOptions.SCHEDULING_STRATEGY)) {
            case "region": {
                Preconditions.checkArgument((!isApproximateLocalRecoveryEnabled ? 1 : 0) != 0, (String)"Approximate local recovery can not be used together with PipelinedRegionScheduler for now! Please set %s to legacy.", (Object[])new Object[]{JobManagerOptions.SCHEDULING_STRATEGY.key()});
                return DefaultSchedulerComponents.createPipelinedRegionSchedulerComponents(scheduleMode, jobMasterConfiguration, slotPool, slotRequestTimeout);
            }
            case "legacy": {
                Preconditions.checkArgument((!isApproximateLocalRecoveryEnabled || !scheduleMode.allowLazyDeployment() ? 1 : 0) != 0, (Object)"Approximate local recovery can only be used together with EAGER schedule mode!");
                return DefaultSchedulerComponents.createLegacySchedulerComponents(scheduleMode, jobMasterConfiguration, slotPool, slotRequestTimeout);
            }
        }
        throw new IllegalStateException("Unsupported scheduling strategy " + schedulingStrategy);
    }

    private static DefaultSchedulerComponents createLegacySchedulerComponents(ScheduleMode scheduleMode, Configuration jobMasterConfiguration, SlotPool slotPool, Time slotRequestTimeout) {
        SlotSelectionStrategy slotSelectionStrategy = DefaultSchedulerComponents.selectSlotSelectionStrategy(jobMasterConfiguration);
        SchedulerImpl scheduler = new SchedulerImpl(slotSelectionStrategy, slotPool);
        SlotProviderStrategy slotProviderStrategy = SlotProviderStrategy.from(scheduleMode, scheduler, slotRequestTimeout);
        return new DefaultSchedulerComponents(DefaultSchedulerComponents.createLegacySchedulingStrategyFactory(scheduleMode), scheduler::start, new DefaultExecutionSlotAllocatorFactory(slotProviderStrategy));
    }

    private static SchedulingStrategyFactory createLegacySchedulingStrategyFactory(ScheduleMode scheduleMode) {
        switch (scheduleMode) {
            case EAGER: {
                return new EagerSchedulingStrategy.Factory();
            }
            case LAZY_FROM_SOURCES_WITH_BATCH_SLOT_REQUEST: 
            case LAZY_FROM_SOURCES: {
                return new LazyFromSourcesSchedulingStrategy.Factory();
            }
        }
        throw new IllegalStateException("Unsupported schedule mode " + (Object)((Object)scheduleMode));
    }

    private static DefaultSchedulerComponents createPipelinedRegionSchedulerComponents(ScheduleMode scheduleMode, Configuration jobMasterConfiguration, SlotPool slotPool, Time slotRequestTimeout) {
        SlotSelectionStrategy slotSelectionStrategy = DefaultSchedulerComponents.selectSlotSelectionStrategy(jobMasterConfiguration);
        PhysicalSlotRequestBulkCheckerImpl bulkChecker = PhysicalSlotRequestBulkCheckerImpl.createFromSlotPool(slotPool, (Clock)SystemClock.getInstance());
        PhysicalSlotProviderImpl physicalSlotProvider = new PhysicalSlotProviderImpl(slotSelectionStrategy, slotPool);
        SlotSharingExecutionSlotAllocatorFactory allocatorFactory = new SlotSharingExecutionSlotAllocatorFactory(physicalSlotProvider, scheduleMode != ScheduleMode.LAZY_FROM_SOURCES_WITH_BATCH_SLOT_REQUEST, bulkChecker, slotRequestTimeout);
        return new DefaultSchedulerComponents(new PipelinedRegionSchedulingStrategy.Factory(), bulkChecker::start, allocatorFactory);
    }

    private static SlotSelectionStrategy selectSlotSelectionStrategy(Configuration configuration) {
        boolean evenlySpreadOutSlots = configuration.getBoolean(ClusterOptions.EVENLY_SPREAD_OUT_SLOTS_STRATEGY);
        LocationPreferenceSlotSelectionStrategy locationPreferenceSlotSelectionStrategy = evenlySpreadOutSlots ? LocationPreferenceSlotSelectionStrategy.createEvenlySpreadOut() : LocationPreferenceSlotSelectionStrategy.createDefault();
        return configuration.getBoolean(CheckpointingOptions.LOCAL_RECOVERY) ? PreviousAllocationSlotSelectionStrategy.create(locationPreferenceSlotSelectionStrategy) : locationPreferenceSlotSelectionStrategy;
    }
}

