/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.jobgraph.IntermediateDataSet;
import org.apache.flink.runtime.jobgraph.JobEdge;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;
import org.apache.flink.runtime.jobgraph.ScheduleMode;
import org.apache.flink.runtime.jobgraph.tasks.JobCheckpointingSettings;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationGroupDesc;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.IterableUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;

public class JobGraph
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<JobVertexID, JobVertex> taskVertices = new LinkedHashMap<JobVertexID, JobVertex>();
    private final Configuration jobConfiguration = new Configuration();
    private JobID jobID;
    private final String jobName;
    private ScheduleMode scheduleMode = ScheduleMode.LAZY_FROM_SOURCES;
    private boolean approximateLocalRecovery = false;
    private SerializedValue<ExecutionConfig> serializedExecutionConfig;
    private JobCheckpointingSettings snapshotSettings;
    private SavepointRestoreSettings savepointRestoreSettings = SavepointRestoreSettings.none();
    private final List<Path> userJars = new ArrayList<Path>();
    private final Map<String, DistributedCache.DistributedCacheEntry> userArtifacts = new HashMap<String, DistributedCache.DistributedCacheEntry>();
    private final List<PermanentBlobKey> userJarBlobKeys = new ArrayList<PermanentBlobKey>();
    private List<URL> classpaths = Collections.emptyList();

    public JobGraph(String jobName) {
        this(null, jobName);
    }

    public JobGraph(JobID jobId, String jobName) {
        this.jobID = jobId == null ? new JobID() : jobId;
        this.jobName = jobName == null ? "(unnamed job)" : jobName;
        try {
            this.setExecutionConfig(new ExecutionConfig());
        }
        catch (IOException e) {
            throw new RuntimeException("bug, empty execution config is not serializable");
        }
    }

    public JobGraph(JobVertex ... vertices) {
        this((String)null, vertices);
    }

    public JobGraph(String jobName, JobVertex ... vertices) {
        this(null, jobName, vertices);
    }

    public JobGraph(JobID jobId, String jobName, JobVertex ... vertices) {
        this(jobId, jobName);
        for (JobVertex vertex : vertices) {
            this.addVertex(vertex);
        }
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public void setJobID(JobID jobID) {
        this.jobID = jobID;
    }

    public String getName() {
        return this.jobName;
    }

    public Configuration getJobConfiguration() {
        return this.jobConfiguration;
    }

    public SerializedValue<ExecutionConfig> getSerializedExecutionConfig() {
        return this.serializedExecutionConfig;
    }

    public void setScheduleMode(ScheduleMode scheduleMode) {
        this.scheduleMode = scheduleMode;
    }

    public ScheduleMode getScheduleMode() {
        return this.scheduleMode;
    }

    public void enableApproximateLocalRecovery(boolean enabled) {
        this.approximateLocalRecovery = enabled;
    }

    public boolean isApproximateLocalRecoveryEnabled() {
        return this.approximateLocalRecovery;
    }

    public void setSavepointRestoreSettings(SavepointRestoreSettings settings) {
        this.savepointRestoreSettings = (SavepointRestoreSettings)Preconditions.checkNotNull((Object)settings, (String)"Savepoint restore settings");
    }

    public SavepointRestoreSettings getSavepointRestoreSettings() {
        return this.savepointRestoreSettings;
    }

    public void setExecutionConfig(ExecutionConfig executionConfig) throws IOException {
        Preconditions.checkNotNull((Object)executionConfig, (String)"ExecutionConfig must not be null.");
        this.serializedExecutionConfig = new SerializedValue((Object)executionConfig);
    }

    public void addVertex(JobVertex vertex) {
        JobVertexID id = vertex.getID();
        JobVertex previous = this.taskVertices.put(id, vertex);
        if (previous != null) {
            this.taskVertices.put(id, previous);
            throw new IllegalArgumentException("The JobGraph already contains a vertex with that id.");
        }
    }

    public Iterable<JobVertex> getVertices() {
        return this.taskVertices.values();
    }

    public JobVertex[] getVerticesAsArray() {
        return this.taskVertices.values().toArray(new JobVertex[this.taskVertices.size()]);
    }

    public int getNumberOfVertices() {
        return this.taskVertices.size();
    }

    public Set<SlotSharingGroup> getSlotSharingGroups() {
        Set slotSharingGroups = IterableUtils.toStream(this.getVertices()).map(JobVertex::getSlotSharingGroup).collect(Collectors.toSet());
        return Collections.unmodifiableSet(slotSharingGroups);
    }

    public Set<CoLocationGroupDesc> getCoLocationGroupDescriptors() {
        Set coLocationGroups = IterableUtils.toStream(this.getVertices()).map(JobVertex::getCoLocationGroup).filter(Objects::nonNull).distinct().map(CoLocationGroupDesc::from).collect(Collectors.toSet());
        return Collections.unmodifiableSet(coLocationGroups);
    }

    public void setSnapshotSettings(JobCheckpointingSettings settings) {
        this.snapshotSettings = settings;
    }

    public JobCheckpointingSettings getCheckpointingSettings() {
        return this.snapshotSettings;
    }

    public boolean isCheckpointingEnabled() {
        if (this.snapshotSettings == null) {
            return false;
        }
        long checkpointInterval = this.snapshotSettings.getCheckpointCoordinatorConfiguration().getCheckpointInterval();
        return checkpointInterval > 0L && checkpointInterval < Long.MAX_VALUE;
    }

    public JobVertex findVertexByID(JobVertexID id) {
        return this.taskVertices.get(id);
    }

    public void setClasspaths(List<URL> paths) {
        this.classpaths = paths;
    }

    public List<URL> getClasspaths() {
        return this.classpaths;
    }

    public int getMaximumParallelism() {
        int maxParallelism = -1;
        for (JobVertex vertex : this.taskVertices.values()) {
            maxParallelism = Math.max(vertex.getParallelism(), maxParallelism);
        }
        return maxParallelism;
    }

    public List<JobVertex> getVerticesSortedTopologicallyFromSources() throws InvalidProgramException {
        if (this.taskVertices.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<JobVertex> sorted = new ArrayList<JobVertex>(this.taskVertices.size());
        LinkedHashSet<JobVertex> remaining = new LinkedHashSet<JobVertex>(this.taskVertices.values());
        Iterator iter = remaining.iterator();
        while (iter.hasNext()) {
            JobVertex vertex = (JobVertex)iter.next();
            if (!vertex.hasNoConnectedInputs()) continue;
            sorted.add(vertex);
            iter.remove();
        }
        int startNodePos = 0;
        while (!remaining.isEmpty()) {
            if (startNodePos >= sorted.size()) {
                throw new InvalidProgramException("The job graph is cyclic.");
            }
            JobVertex current = (JobVertex)sorted.get(startNodePos++);
            this.addNodesThatHaveNoNewPredecessors(current, sorted, remaining);
        }
        return sorted;
    }

    private void addNodesThatHaveNoNewPredecessors(JobVertex start, List<JobVertex> target, Set<JobVertex> remaining) {
        for (IntermediateDataSet dataSet : start.getProducedDataSets()) {
            for (JobEdge edge : dataSet.getConsumers()) {
                JobVertex v = edge.getTarget();
                if (!remaining.contains(v)) continue;
                boolean hasNewPredecessors = false;
                for (JobEdge e : v.getInputs()) {
                    IntermediateDataSet source;
                    if (e == edge || !remaining.contains((source = e.getSource()).getProducer())) continue;
                    hasNewPredecessors = true;
                    break;
                }
                if (hasNewPredecessors) continue;
                target.add(v);
                remaining.remove(v);
                this.addNodesThatHaveNoNewPredecessors(v, target, remaining);
            }
        }
    }

    public void addJar(Path jar) {
        if (jar == null) {
            throw new IllegalArgumentException();
        }
        if (!this.userJars.contains(jar)) {
            this.userJars.add(jar);
        }
    }

    public void addJars(List<URL> jarFilesToAttach) {
        for (URL jar : jarFilesToAttach) {
            try {
                this.addJar(new Path(jar.toURI()));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("URL is invalid. This should not happen.", e);
            }
        }
    }

    public List<Path> getUserJars() {
        return this.userJars;
    }

    public void addUserArtifact(String name, DistributedCache.DistributedCacheEntry file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        this.userArtifacts.putIfAbsent(name, file);
    }

    public Map<String, DistributedCache.DistributedCacheEntry> getUserArtifacts() {
        return this.userArtifacts;
    }

    public void addUserJarBlobKey(PermanentBlobKey key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (!this.userJarBlobKeys.contains(key)) {
            this.userJarBlobKeys.add(key);
        }
    }

    public boolean hasUsercodeJarFiles() {
        return this.userJars.size() > 0;
    }

    public List<PermanentBlobKey> getUserJarBlobKeys() {
        return this.userJarBlobKeys;
    }

    public String toString() {
        return "JobGraph(jobId: " + this.jobID + ")";
    }

    public void setUserArtifactBlobKey(String entryName, PermanentBlobKey blobKey) throws IOException {
        byte[] serializedBlobKey = InstantiationUtil.serializeObject((Object)blobKey);
        this.userArtifacts.computeIfPresent(entryName, (key, originalEntry) -> new DistributedCache.DistributedCacheEntry(originalEntry.filePath, originalEntry.isExecutable, serializedBlobKey, originalEntry.isZipped));
    }

    public void setUserArtifactRemotePath(String entryName, String remotePath) {
        this.userArtifacts.computeIfPresent(entryName, (key, originalEntry) -> new DistributedCache.DistributedCacheEntry(remotePath, originalEntry.isExecutable, null, originalEntry.isZipped));
    }

    public void writeUserArtifactEntriesToConfiguration() {
        for (Map.Entry<String, DistributedCache.DistributedCacheEntry> userArtifact : this.userArtifacts.entrySet()) {
            DistributedCache.writeFileInfoToConfig((String)userArtifact.getKey(), (DistributedCache.DistributedCacheEntry)userArtifact.getValue(), (Configuration)this.jobConfiguration);
        }
    }
}

