/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.partition.BufferReaderWriterUtil;
import org.apache.flink.runtime.io.network.partition.PartitionedFile;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;

public class PartitionedFileReader
implements AutoCloseable {
    private final ByteBuffer headerBuf = BufferReaderWriterUtil.allocatedHeaderBuffer();
    private final ByteBuffer indexEntryBuf;
    private final PartitionedFile partitionedFile;
    private final int targetSubpartition;
    private final FileChannel dataFileChannel;
    private final FileChannel indexFileChannel;
    private int nextRegionToRead;
    private int currentRegionRemainingBuffers;
    private boolean isClosed;

    public PartitionedFileReader(PartitionedFile partitionedFile, int targetSubpartition) throws IOException {
        this.partitionedFile = (PartitionedFile)Preconditions.checkNotNull((Object)partitionedFile);
        this.targetSubpartition = targetSubpartition;
        this.indexEntryBuf = ByteBuffer.allocateDirect(12);
        BufferReaderWriterUtil.configureByteBuffer(this.indexEntryBuf);
        this.dataFileChannel = this.openFileChannel(partitionedFile.getDataFilePath());
        try {
            this.indexFileChannel = this.openFileChannel(partitionedFile.getIndexFilePath());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((AutoCloseable)this.dataFileChannel);
            throw throwable;
        }
    }

    private FileChannel openFileChannel(Path path) throws IOException {
        return FileChannel.open(path, StandardOpenOption.READ);
    }

    private boolean moveToNextReadableRegion() throws IOException {
        if (this.currentRegionRemainingBuffers > 0) {
            return true;
        }
        while (this.nextRegionToRead < this.partitionedFile.getNumRegions()) {
            this.partitionedFile.getIndexEntry(this.indexFileChannel, this.indexEntryBuf, this.nextRegionToRead, this.targetSubpartition);
            long dataOffset = this.indexEntryBuf.getLong();
            this.currentRegionRemainingBuffers = this.indexEntryBuf.getInt();
            ++this.nextRegionToRead;
            if (this.currentRegionRemainingBuffers <= 0) continue;
            this.dataFileChannel.position(dataOffset);
            return true;
        }
        return false;
    }

    @Nullable
    public Buffer readBuffer(MemorySegment target, BufferRecycler recycler) throws IOException {
        Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (Object)"File reader is already closed.");
        if (this.moveToNextReadableRegion()) {
            --this.currentRegionRemainingBuffers;
            return BufferReaderWriterUtil.readFromByteChannel(this.dataFileChannel, this.headerBuf, target, recycler);
        }
        return null;
    }

    @VisibleForTesting
    public boolean hasRemaining() throws IOException {
        Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (Object)"File reader is already closed.");
        return this.moveToNextReadableRegion();
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        IOException exception = null;
        try {
            if (this.dataFileChannel != null) {
                this.dataFileChannel.close();
            }
        }
        catch (IOException ioException) {
            exception = ioException;
        }
        try {
            if (this.indexFileChannel != null) {
                this.indexFileChannel.close();
            }
        }
        catch (IOException ioException) {
            exception = (IOException)ExceptionUtils.firstOrSuppressed((Throwable)ioException, (Throwable)exception);
        }
        if (exception != null) {
            throw exception;
        }
    }
}

