/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.List;
import org.apache.flink.runtime.executiongraph.EdgeManager;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResult;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.scheduler.strategy.ConsumerVertexGroup;

public class IntermediateResultPartition {
    private final IntermediateResult totalResult;
    private final ExecutionVertex producer;
    private final IntermediateResultPartitionID partitionId;
    private final EdgeManager edgeManager;
    private boolean hasDataProduced = false;

    public IntermediateResultPartition(IntermediateResult totalResult, ExecutionVertex producer, int partitionNumber, EdgeManager edgeManager) {
        this.totalResult = totalResult;
        this.producer = producer;
        this.partitionId = new IntermediateResultPartitionID(totalResult.getId(), partitionNumber);
        this.edgeManager = edgeManager;
    }

    public ExecutionVertex getProducer() {
        return this.producer;
    }

    public int getPartitionNumber() {
        return this.partitionId.getPartitionNumber();
    }

    public IntermediateResult getIntermediateResult() {
        return this.totalResult;
    }

    public IntermediateResultPartitionID getPartitionId() {
        return this.partitionId;
    }

    public ResultPartitionType getResultType() {
        return this.totalResult.getResultType();
    }

    public List<ConsumerVertexGroup> getConsumerVertexGroups() {
        return this.getEdgeManager().getConsumerVertexGroupsForPartition(this.partitionId);
    }

    public void markDataProduced() {
        this.hasDataProduced = true;
    }

    public boolean isConsumable() {
        if (this.getResultType().isPipelined()) {
            return this.hasDataProduced;
        }
        return this.totalResult.areAllPartitionsFinished();
    }

    void resetForNewExecution() {
        if (this.getResultType().isBlocking() && this.hasDataProduced) {
            this.totalResult.incrementNumberOfRunningProducersAndGetRemaining();
        }
        this.hasDataProduced = false;
    }

    public void addConsumers(ConsumerVertexGroup consumers) {
        this.getEdgeManager().connectPartitionWithConsumerVertexGroup(this.partitionId, consumers);
    }

    private EdgeManager getEdgeManager() {
        return this.edgeManager;
    }

    boolean markFinished() {
        if (!this.getResultType().isBlocking()) {
            throw new IllegalStateException("Tried to mark a non-blocking result partition as finished");
        }
        this.hasDataProduced = true;
        int refCnt = this.totalResult.decrementNumberOfRunningProducersAndGetRemaining();
        if (refCnt == 0) {
            return true;
        }
        if (refCnt < 0) {
            throw new IllegalStateException("Decremented number of unfinished producers below 0. This is most likely a bug in the execution state/intermediate result partition management.");
        }
        return false;
    }
}

