/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.zookeeper.filesystem;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.RetrievableStateHandle;
import org.apache.flink.runtime.state.RetrievableStreamStateHandle;
import org.apache.flink.runtime.zookeeper.RetrievableStateStorageHelper;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;

public class FileSystemStateStorageHelper<T extends Serializable>
implements RetrievableStateStorageHelper<T> {
    private final Path rootPath;
    private final String prefix;
    private final FileSystem fs;

    public FileSystemStateStorageHelper(String rootPath, String prefix) throws IOException {
        this(new Path(rootPath), prefix);
    }

    public FileSystemStateStorageHelper(Path rootPath, String prefix) throws IOException {
        this.rootPath = (Path)Preconditions.checkNotNull((Object)rootPath, (String)"Root path");
        this.prefix = (String)Preconditions.checkNotNull((Object)prefix, (String)"Prefix");
        this.fs = FileSystem.get((URI)rootPath.toUri());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RetrievableStateHandle<T> store(T state) throws Exception {
        Exception latestException = null;
        int attempt = 0;
        while (attempt < 10) {
            Path filePath = this.getNewFilePath();
            try (FSDataOutputStream outStream = this.fs.create(filePath, false);){
                InstantiationUtil.serializeObject((OutputStream)outStream, state);
                RetrievableStreamStateHandle retrievableStreamStateHandle = new RetrievableStreamStateHandle(filePath, outStream.getPos());
                return retrievableStreamStateHandle;
            }
            catch (Exception e) {
                latestException = e;
                ++attempt;
            }
        }
        throw new Exception("Could not open output stream for state backend", latestException);
    }

    private Path getNewFilePath() {
        return new Path(this.rootPath, FileUtils.getRandomFilename((String)this.prefix));
    }
}

