/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.flink.core.fs.AbstractMultiFSDataInputStream;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.runtime.state.StateUtil;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.Preconditions;

public class MultiStreamStateHandle
implements StreamStateHandle {
    private static final long serialVersionUID = -4588701089489569707L;
    private final List<StreamStateHandle> stateHandles;
    private final long stateSize;

    public MultiStreamStateHandle(List<StreamStateHandle> stateHandles) {
        this.stateHandles = (List)Preconditions.checkNotNull(stateHandles);
        long calculateSize = 0L;
        for (StreamStateHandle stateHandle : stateHandles) {
            calculateSize += stateHandle.getStateSize();
        }
        this.stateSize = calculateSize;
    }

    @Override
    public FSDataInputStream openInputStream() throws IOException {
        return new MultiFSDataInputStream(this.stateHandles);
    }

    @Override
    public void discardState() throws Exception {
        StateUtil.bestEffortDiscardAllStateObjects(this.stateHandles);
    }

    @Override
    public long getStateSize() {
        return this.stateSize;
    }

    public String toString() {
        return "MultiStreamStateHandle{stateHandles=" + this.stateHandles + ", stateSize=" + this.stateSize + '}';
    }

    static final class MultiFSDataInputStream
    extends AbstractMultiFSDataInputStream {
        private final TreeMap<Long, StreamStateHandle> stateHandleMap = new TreeMap();

        public MultiFSDataInputStream(List<StreamStateHandle> stateHandles) throws IOException {
            this.totalPos = 0L;
            long calculateSize = 0L;
            for (StreamStateHandle stateHandle : stateHandles) {
                this.stateHandleMap.put(calculateSize, stateHandle);
                calculateSize += stateHandle.getStateSize();
            }
            this.totalAvailable = calculateSize;
            if (this.totalAvailable > 0L) {
                StreamStateHandle first = this.stateHandleMap.firstEntry().getValue();
                this.delegate = first.openInputStream();
            }
        }

        protected FSDataInputStream getSeekedStreamForOffset(long globalStreamOffset) throws IOException {
            Map.Entry<Long, StreamStateHandle> handleEntry = this.stateHandleMap.floorEntry(globalStreamOffset);
            if (handleEntry != null) {
                FSDataInputStream stream = handleEntry.getValue().openInputStream();
                stream.seek(globalStreamOffset - handleEntry.getKey());
                return stream;
            }
            return null;
        }
    }
}

