/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.query;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.query.KvStateID;
import org.apache.flink.runtime.query.KvStateRegistryListener;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.internal.InternalKvState;

public class KvStateRegistry {
    private final ConcurrentHashMap<KvStateID, InternalKvState<?>> registeredKvStates = new ConcurrentHashMap();
    private final AtomicReference<KvStateRegistryListener> listener = new AtomicReference();

    public void registerListener(KvStateRegistryListener listener) {
        if (!this.listener.compareAndSet(null, listener)) {
            throw new IllegalStateException("Listener already registered.");
        }
    }

    public void unregisterListener() {
        this.listener.set(null);
    }

    public KvStateID registerKvState(JobID jobId, JobVertexID jobVertexId, KeyGroupRange keyGroupRange, String registrationName, InternalKvState<?> kvState) {
        KvStateID kvStateId = new KvStateID();
        if (this.registeredKvStates.putIfAbsent(kvStateId, kvState) == null) {
            KvStateRegistryListener listener = this.listener.get();
            if (listener != null) {
                listener.notifyKvStateRegistered(jobId, jobVertexId, keyGroupRange, registrationName, kvStateId);
            }
            return kvStateId;
        }
        throw new IllegalStateException((Object)((Object)kvStateId) + " is already registered.");
    }

    public void unregisterKvState(JobID jobId, JobVertexID jobVertexId, KeyGroupRange keyGroupRange, String registrationName, KvStateID kvStateId) {
        KvStateRegistryListener listener;
        if (this.registeredKvStates.remove((Object)kvStateId) != null && (listener = this.listener.get()) != null) {
            listener.notifyKvStateUnregistered(jobId, jobVertexId, keyGroupRange, registrationName);
        }
    }

    public InternalKvState<?> getKvState(KvStateID kvStateId) {
        return this.registeredKvStates.get((Object)kvStateId);
    }

    public TaskKvStateRegistry createTaskRegistry(JobID jobId, JobVertexID jobVertexId) {
        return new TaskKvStateRegistry(this, jobId, jobVertexId);
    }
}

