/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.dump;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.HistogramStatistics;
import org.apache.flink.metrics.Meter;
import org.apache.flink.runtime.metrics.dump.MetricDump;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.util.DataInputDeserializer;
import org.apache.flink.runtime.util.DataOutputSerializer;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricDumpSerialization {
    private static final Logger LOG = LoggerFactory.getLogger(MetricDumpSerialization.class);

    private MetricDumpSerialization() {
    }

    private static void serializeMetricInfo(DataOutput out, QueryScopeInfo info) throws IOException {
        out.writeUTF(info.scope);
        out.writeByte(info.getCategory());
        switch (info.getCategory()) {
            case 0: {
                break;
            }
            case 1: {
                String tmID = ((QueryScopeInfo.TaskManagerQueryScopeInfo)info).taskManagerID;
                out.writeUTF(tmID);
                break;
            }
            case 2: {
                QueryScopeInfo.JobQueryScopeInfo jobInfo = (QueryScopeInfo.JobQueryScopeInfo)info;
                out.writeUTF(jobInfo.jobID);
                break;
            }
            case 3: {
                QueryScopeInfo.TaskQueryScopeInfo taskInfo = (QueryScopeInfo.TaskQueryScopeInfo)info;
                out.writeUTF(taskInfo.jobID);
                out.writeUTF(taskInfo.vertexID);
                out.writeInt(taskInfo.subtaskIndex);
                break;
            }
            case 4: {
                QueryScopeInfo.OperatorQueryScopeInfo operatorInfo = (QueryScopeInfo.OperatorQueryScopeInfo)info;
                out.writeUTF(operatorInfo.jobID);
                out.writeUTF(operatorInfo.vertexID);
                out.writeInt(operatorInfo.subtaskIndex);
                out.writeUTF(operatorInfo.operatorName);
                break;
            }
            default: {
                throw new IOException("Unknown scope category: " + info.getCategory());
            }
        }
    }

    private static void serializeCounter(DataOutput out, QueryScopeInfo info, String name, Counter counter) throws IOException {
        long count = counter.getCount();
        MetricDumpSerialization.serializeMetricInfo(out, info);
        out.writeUTF(name);
        out.writeLong(count);
    }

    private static void serializeGauge(DataOutput out, QueryScopeInfo info, String name, Gauge<?> gauge) throws IOException {
        Object value = gauge.getValue();
        if (value == null) {
            throw new NullPointerException("Value returned by gauge " + name + " was null.");
        }
        String stringValue = gauge.getValue().toString();
        if (stringValue == null) {
            throw new NullPointerException("toString() of the value returned by gauge " + name + " returned null.");
        }
        MetricDumpSerialization.serializeMetricInfo(out, info);
        out.writeUTF(name);
        out.writeUTF(stringValue);
    }

    private static void serializeHistogram(DataOutput out, QueryScopeInfo info, String name, Histogram histogram) throws IOException {
        HistogramStatistics stat = histogram.getStatistics();
        long min = stat.getMin();
        long max = stat.getMax();
        double mean = stat.getMean();
        double median = stat.getQuantile(0.5);
        double stddev = stat.getStdDev();
        double p75 = stat.getQuantile(0.75);
        double p90 = stat.getQuantile(0.9);
        double p95 = stat.getQuantile(0.95);
        double p98 = stat.getQuantile(0.98);
        double p99 = stat.getQuantile(0.99);
        double p999 = stat.getQuantile(0.999);
        MetricDumpSerialization.serializeMetricInfo(out, info);
        out.writeUTF(name);
        out.writeLong(min);
        out.writeLong(max);
        out.writeDouble(mean);
        out.writeDouble(median);
        out.writeDouble(stddev);
        out.writeDouble(p75);
        out.writeDouble(p90);
        out.writeDouble(p95);
        out.writeDouble(p98);
        out.writeDouble(p99);
        out.writeDouble(p999);
    }

    private static void serializeMeter(DataOutput out, QueryScopeInfo info, String name, Meter meter) throws IOException {
        MetricDumpSerialization.serializeMetricInfo(out, info);
        out.writeUTF(name);
        out.writeDouble(meter.getRate());
    }

    private static MetricDump.CounterDump deserializeCounter(DataInputView dis) throws IOException {
        QueryScopeInfo scope = MetricDumpSerialization.deserializeMetricInfo((DataInput)dis);
        String name = dis.readUTF();
        long count = dis.readLong();
        return new MetricDump.CounterDump(scope, name, count);
    }

    private static MetricDump.GaugeDump deserializeGauge(DataInputView dis) throws IOException {
        QueryScopeInfo scope = MetricDumpSerialization.deserializeMetricInfo((DataInput)dis);
        String name = dis.readUTF();
        String value = dis.readUTF();
        return new MetricDump.GaugeDump(scope, name, value);
    }

    private static MetricDump.HistogramDump deserializeHistogram(DataInputView dis) throws IOException {
        QueryScopeInfo info = MetricDumpSerialization.deserializeMetricInfo((DataInput)dis);
        String name = dis.readUTF();
        long min = dis.readLong();
        long max = dis.readLong();
        double mean = dis.readDouble();
        double median = dis.readDouble();
        double stddev = dis.readDouble();
        double p75 = dis.readDouble();
        double p90 = dis.readDouble();
        double p95 = dis.readDouble();
        double p98 = dis.readDouble();
        double p99 = dis.readDouble();
        double p999 = dis.readDouble();
        return new MetricDump.HistogramDump(info, name, min, max, mean, median, stddev, p75, p90, p95, p98, p99, p999);
    }

    private static MetricDump.MeterDump deserializeMeter(DataInputView dis) throws IOException {
        QueryScopeInfo info = MetricDumpSerialization.deserializeMetricInfo((DataInput)dis);
        String name = dis.readUTF();
        double rate = dis.readDouble();
        return new MetricDump.MeterDump(info, name, rate);
    }

    private static QueryScopeInfo deserializeMetricInfo(DataInput dis) throws IOException {
        String scope = dis.readUTF();
        byte cat = dis.readByte();
        switch (cat) {
            case 0: {
                return new QueryScopeInfo.JobManagerQueryScopeInfo(scope);
            }
            case 1: {
                String tmID = dis.readUTF();
                return new QueryScopeInfo.TaskManagerQueryScopeInfo(tmID, scope);
            }
            case 2: {
                String jobID = dis.readUTF();
                return new QueryScopeInfo.JobQueryScopeInfo(jobID, scope);
            }
            case 3: {
                String jobID = dis.readUTF();
                String vertexID = dis.readUTF();
                int subtaskIndex = dis.readInt();
                return new QueryScopeInfo.TaskQueryScopeInfo(jobID, vertexID, subtaskIndex, scope);
            }
            case 4: {
                String jobID = dis.readUTF();
                String vertexID = dis.readUTF();
                int subtaskIndex = dis.readInt();
                String operatorName = dis.readUTF();
                return new QueryScopeInfo.OperatorQueryScopeInfo(jobID, vertexID, subtaskIndex, operatorName, scope);
            }
        }
        throw new IOException("Unknown scope category: " + cat);
    }

    public static class MetricDumpDeserializer {
        public List<MetricDump> deserialize(MetricSerializationResult data) {
            int x;
            DataInputDeserializer in = new DataInputDeserializer(data.serializedMetrics, 0, data.serializedMetrics.length);
            ArrayList<MetricDump> metrics = new ArrayList<MetricDump>(data.numCounters + data.numGauges + data.numHistograms + data.numMeters);
            for (x = 0; x < data.numCounters; ++x) {
                try {
                    metrics.add(MetricDumpSerialization.deserializeCounter(in));
                    continue;
                }
                catch (Exception e) {
                    LOG.debug("Failed to deserialize counter.", (Throwable)e);
                }
            }
            for (x = 0; x < data.numGauges; ++x) {
                try {
                    metrics.add(MetricDumpSerialization.deserializeGauge(in));
                    continue;
                }
                catch (Exception e) {
                    LOG.debug("Failed to deserialize gauge.", (Throwable)e);
                }
            }
            for (x = 0; x < data.numHistograms; ++x) {
                try {
                    metrics.add(MetricDumpSerialization.deserializeHistogram(in));
                    continue;
                }
                catch (Exception e) {
                    LOG.debug("Failed to deserialize histogram.", (Throwable)e);
                }
            }
            for (x = 0; x < data.numMeters; ++x) {
                try {
                    metrics.add(MetricDumpSerialization.deserializeMeter(in));
                    continue;
                }
                catch (Exception e) {
                    LOG.debug("Failed to deserialize meter.", (Throwable)e);
                }
            }
            return metrics;
        }
    }

    public static class MetricDumpSerializer {
        private DataOutputSerializer buffer = new DataOutputSerializer(32768);

        /*
         * WARNING - void declaration
         */
        public MetricSerializationResult serialize(Map<Counter, Tuple2<QueryScopeInfo, String>> counters, Map<Gauge<?>, Tuple2<QueryScopeInfo, String>> gauges, Map<Histogram, Tuple2<QueryScopeInfo, String>> histograms, Map<Meter, Tuple2<QueryScopeInfo, String>> meters) {
            void var8_17;
            void var7_11;
            this.buffer.clear();
            int numCounters = 0;
            for (Map.Entry<Counter, Tuple2<QueryScopeInfo, String>> entry : counters.entrySet()) {
                try {
                    MetricDumpSerialization.serializeCounter((DataOutput)((Object)this.buffer), (QueryScopeInfo)entry.getValue().f0, (String)entry.getValue().f1, entry.getKey());
                    ++numCounters;
                }
                catch (Exception exception) {
                    LOG.debug("Failed to serialize counter.", (Throwable)exception);
                }
            }
            int numGauges = 0;
            for (Map.Entry<Gauge<?>, Tuple2<QueryScopeInfo, String>> entry : gauges.entrySet()) {
                try {
                    MetricDumpSerialization.serializeGauge((DataOutput)((Object)this.buffer), (QueryScopeInfo)entry.getValue().f0, (String)entry.getValue().f1, entry.getKey());
                    ++numGauges;
                }
                catch (Exception exception) {
                    LOG.debug("Failed to serialize gauge.", (Throwable)exception);
                }
            }
            boolean bl = false;
            for (Map.Entry<Histogram, Tuple2<QueryScopeInfo, String>> entry : histograms.entrySet()) {
                try {
                    MetricDumpSerialization.serializeHistogram((DataOutput)((Object)this.buffer), (QueryScopeInfo)entry.getValue().f0, (String)entry.getValue().f1, entry.getKey());
                    ++var7_11;
                }
                catch (Exception e) {
                    LOG.debug("Failed to serialize histogram.", (Throwable)e);
                }
            }
            boolean bl2 = false;
            for (Map.Entry<Meter, Tuple2<QueryScopeInfo, String>> entry : meters.entrySet()) {
                try {
                    MetricDumpSerialization.serializeMeter((DataOutput)((Object)this.buffer), (QueryScopeInfo)entry.getValue().f0, (String)entry.getValue().f1, entry.getKey());
                    ++var8_17;
                }
                catch (Exception e) {
                    LOG.debug("Failed to serialize meter.", (Throwable)e);
                }
            }
            return new MetricSerializationResult(this.buffer.getCopyOfBuffer(), numCounters, numGauges, (int)var8_17, (int)var7_11);
        }

        public void close() {
            this.buffer = null;
        }
    }

    public static class MetricSerializationResult
    implements Serializable {
        private static final long serialVersionUID = 6928770855951536906L;
        public final byte[] serializedMetrics;
        public final int numCounters;
        public final int numGauges;
        public final int numMeters;
        public final int numHistograms;

        public MetricSerializationResult(byte[] serializedMetrics, int numCounters, int numGauges, int numMeters, int numHistograms) {
            Preconditions.checkNotNull((Object)serializedMetrics);
            Preconditions.checkArgument((numCounters >= 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((numGauges >= 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((numMeters >= 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((numHistograms >= 0 ? 1 : 0) != 0);
            this.serializedMetrics = serializedMetrics;
            this.numCounters = numCounters;
            this.numGauges = numGauges;
            this.numMeters = numMeters;
            this.numHistograms = numHistograms;
        }
    }
}

