/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.buffer.BufferPoolOwner;
import org.apache.flink.runtime.io.network.buffer.BufferProvider;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.PipelinedSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionConsumableNotifier;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.runtime.io.network.partition.SpillableSubpartition;
import org.apache.flink.runtime.taskmanager.TaskActions;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultPartition
implements BufferPoolOwner {
    private static final Logger LOG = LoggerFactory.getLogger(ResultPartition.class);
    private final String owningTaskName;
    private final TaskActions taskActions;
    private final JobID jobId;
    private final ResultPartitionID partitionId;
    private final ResultPartitionType partitionType;
    private final ResultSubpartition[] subpartitions;
    private final ResultPartitionManager partitionManager;
    private final ResultPartitionConsumableNotifier partitionConsumableNotifier;
    public final int numTargetKeyGroups;
    private final boolean sendScheduleOrUpdateConsumersMessage;
    private final AtomicBoolean isReleased = new AtomicBoolean();
    private final AtomicInteger pendingReferences = new AtomicInteger();
    private BufferPool bufferPool;
    private boolean hasNotifiedPipelinedConsumers;
    private boolean isFinished;
    private volatile Throwable cause;
    private int totalNumberOfBuffers;
    private long totalNumberOfBytes;

    public ResultPartition(String owningTaskName, TaskActions taskActions, JobID jobId, ResultPartitionID partitionId, ResultPartitionType partitionType, int numberOfSubpartitions, int numTargetKeyGroups, ResultPartitionManager partitionManager, ResultPartitionConsumableNotifier partitionConsumableNotifier, IOManager ioManager, boolean sendScheduleOrUpdateConsumersMessage) {
        this.owningTaskName = (String)Preconditions.checkNotNull((Object)owningTaskName);
        this.taskActions = (TaskActions)Preconditions.checkNotNull((Object)taskActions);
        this.jobId = (JobID)Preconditions.checkNotNull((Object)jobId);
        this.partitionId = (ResultPartitionID)Preconditions.checkNotNull((Object)partitionId);
        this.partitionType = (ResultPartitionType)((Object)Preconditions.checkNotNull((Object)((Object)partitionType)));
        this.subpartitions = new ResultSubpartition[numberOfSubpartitions];
        this.numTargetKeyGroups = numTargetKeyGroups;
        this.partitionManager = (ResultPartitionManager)Preconditions.checkNotNull((Object)partitionManager);
        this.partitionConsumableNotifier = (ResultPartitionConsumableNotifier)Preconditions.checkNotNull((Object)partitionConsumableNotifier);
        this.sendScheduleOrUpdateConsumersMessage = sendScheduleOrUpdateConsumersMessage;
        switch (partitionType) {
            case BLOCKING: {
                for (int i = 0; i < this.subpartitions.length; ++i) {
                    this.subpartitions[i] = new SpillableSubpartition(i, this, ioManager);
                }
                break;
            }
            case PIPELINED: 
            case PIPELINED_BOUNDED: {
                for (int i = 0; i < this.subpartitions.length; ++i) {
                    this.subpartitions[i] = new PipelinedSubpartition(i, this);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported result partition type.");
            }
        }
        this.pin();
        LOG.debug("{}: Initialized {}", (Object)owningTaskName, (Object)this);
    }

    public void registerBufferPool(BufferPool bufferPool) {
        Preconditions.checkArgument((bufferPool.getNumberOfRequiredMemorySegments() >= this.getNumberOfSubpartitions() ? 1 : 0) != 0, (Object)"Bug in result partition setup logic: Buffer pool has not enough guaranteed buffers for this result partition.");
        Preconditions.checkState((this.bufferPool == null ? 1 : 0) != 0, (Object)"Bug in result partition setup logic: Already registered buffer pool.");
        this.bufferPool = (BufferPool)Preconditions.checkNotNull((Object)bufferPool);
        if (!this.partitionType.hasBackPressure()) {
            bufferPool.setBufferPoolOwner(this);
        }
    }

    public JobID getJobId() {
        return this.jobId;
    }

    public ResultPartitionID getPartitionId() {
        return this.partitionId;
    }

    public int getNumberOfSubpartitions() {
        return this.subpartitions.length;
    }

    public BufferProvider getBufferProvider() {
        return this.bufferPool;
    }

    public BufferPool getBufferPool() {
        return this.bufferPool;
    }

    public int getTotalNumberOfBuffers() {
        return this.totalNumberOfBuffers;
    }

    public long getTotalNumberOfBytes() {
        return this.totalNumberOfBytes;
    }

    public int getNumberOfQueuedBuffers() {
        int totalBuffers = 0;
        for (ResultSubpartition subpartition : this.subpartitions) {
            totalBuffers += subpartition.unsynchronizedGetNumberOfQueuedBuffers();
        }
        return totalBuffers;
    }

    public ResultPartitionType getPartitionType() {
        return this.partitionType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Buffer buffer, int subpartitionIndex) throws IOException {
        boolean success = false;
        try {
            ResultSubpartition subpartition;
            this.checkInProduceState();
            ResultSubpartition resultSubpartition = subpartition = this.subpartitions[subpartitionIndex];
            synchronized (resultSubpartition) {
                success = subpartition.add(buffer);
                ++this.totalNumberOfBuffers;
                this.totalNumberOfBytes += (long)buffer.getSize();
            }
        }
        finally {
            if (success) {
                this.notifyPipelinedConsumers();
            } else {
                buffer.recycle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() throws IOException {
        boolean success = false;
        try {
            this.checkInProduceState();
            ResultSubpartition[] resultSubpartitionArray = this.subpartitions;
            int n = resultSubpartitionArray.length;
            for (int i = 0; i < n; ++i) {
                ResultSubpartition subpartition;
                ResultSubpartition resultSubpartition = subpartition = resultSubpartitionArray[i];
                synchronized (resultSubpartition) {
                    subpartition.finish();
                    continue;
                }
            }
            success = true;
        }
        finally {
            if (success) {
                this.isFinished = true;
                this.notifyPipelinedConsumers();
            }
        }
    }

    public void release() {
        this.release(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Throwable cause) {
        if (this.isReleased.compareAndSet(false, true)) {
            LOG.debug("{}: Releasing {}.", (Object)this.owningTaskName, (Object)this);
            if (cause != null) {
                this.cause = cause;
            }
            for (ResultSubpartition subpartition : this.subpartitions) {
                try {
                    ResultSubpartition resultSubpartition = subpartition;
                    synchronized (resultSubpartition) {
                        subpartition.release();
                    }
                }
                catch (Throwable t) {
                    LOG.error("Error during release of result subpartition: " + t.getMessage(), t);
                }
            }
        }
    }

    public void destroyBufferPool() {
        if (this.bufferPool != null) {
            this.bufferPool.lazyDestroy();
        }
    }

    public ResultSubpartitionView createSubpartitionView(int index, BufferAvailabilityListener availabilityListener) throws IOException {
        int refCnt = this.pendingReferences.get();
        Preconditions.checkState((refCnt != -1 ? 1 : 0) != 0, (Object)"Partition released.");
        Preconditions.checkState((refCnt > 0 ? 1 : 0) != 0, (Object)"Partition not pinned.");
        Preconditions.checkElementIndex((int)index, (int)this.subpartitions.length, (String)"Subpartition not found.");
        ResultSubpartitionView readView = this.subpartitions[index].createReadView(availabilityListener);
        LOG.debug("Created {}", (Object)readView);
        return readView;
    }

    public Throwable getFailureCause() {
        return this.cause;
    }

    public int getNumTargetKeyGroups() {
        return this.numTargetKeyGroups;
    }

    @Override
    public void releaseMemory(int toRelease) throws IOException {
        Preconditions.checkArgument((toRelease > 0 ? 1 : 0) != 0);
        for (ResultSubpartition subpartition : this.subpartitions) {
            if ((toRelease -= subpartition.releaseMemory()) <= 0) break;
        }
    }

    public String toString() {
        return "ResultPartition " + this.partitionId.toString() + " [" + (Object)((Object)this.partitionType) + ", " + this.subpartitions.length + " subpartitions, " + this.pendingReferences + " pending references]";
    }

    void pin() {
        block1: {
            int refCnt;
            while ((refCnt = this.pendingReferences.get()) >= 0) {
                if (!this.pendingReferences.compareAndSet(refCnt, refCnt + this.subpartitions.length)) continue;
                break block1;
            }
            throw new IllegalStateException("Released.");
        }
    }

    void onConsumedSubpartition(int subpartitionIndex) {
        if (this.isReleased.get()) {
            return;
        }
        int refCnt = this.pendingReferences.decrementAndGet();
        if (refCnt == 0) {
            this.partitionManager.onConsumedPartition(this);
        } else if (refCnt < 0) {
            throw new IllegalStateException("All references released.");
        }
        LOG.debug("{}: Received release notification for subpartition {} (reference count now at: {}).", new Object[]{this, subpartitionIndex, this.pendingReferences});
    }

    ResultSubpartition[] getAllPartitions() {
        return this.subpartitions;
    }

    private void checkInProduceState() {
        Preconditions.checkState((!this.isFinished ? 1 : 0) != 0, (Object)"Partition already finished.");
    }

    private void notifyPipelinedConsumers() {
        if (this.sendScheduleOrUpdateConsumersMessage && !this.hasNotifiedPipelinedConsumers && this.partitionType.isPipelined()) {
            this.partitionConsumableNotifier.notifyPartitionConsumable(this.jobId, this.partitionId, this.taskActions);
            this.hasNotifiedPipelinedConsumers = true;
        }
    }
}

