/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.instance;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.instance.SharedSlot;
import org.apache.flink.runtime.instance.Slot;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmanager.slots.AllocatedSlot;
import org.apache.flink.runtime.jobmanager.slots.SlotOwner;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.AbstractID;

public class SimpleSlot
extends Slot {
    private static final AtomicReferenceFieldUpdater<SimpleSlot, Execution> VERTEX_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SimpleSlot.class, Execution.class, "executedTask");
    private volatile Execution executedTask;
    private volatile Locality locality = Locality.UNCONSTRAINED;

    public SimpleSlot(JobID jobID, SlotOwner owner, TaskManagerLocation location, int slotNumber, TaskManagerGateway taskManagerGateway) {
        this(jobID, owner, location, slotNumber, taskManagerGateway, null, null);
    }

    public SimpleSlot(JobID jobID, SlotOwner owner, TaskManagerLocation location, int slotNumber, TaskManagerGateway taskManagerGateway, @Nullable SharedSlot parent, @Nullable AbstractID groupID) {
        super(parent != null ? parent.getAllocatedSlot() : new AllocatedSlot(NO_ALLOCATION_ID, jobID, location, slotNumber, ResourceProfile.UNKNOWN, taskManagerGateway), owner, slotNumber, parent, groupID);
    }

    public SimpleSlot(AllocatedSlot allocatedSlot, SlotOwner owner, int slotNumber) {
        this(allocatedSlot, owner, slotNumber, null, null);
    }

    public SimpleSlot(SharedSlot parent, SlotOwner owner, int slotNumber, AbstractID groupID) {
        this(parent.getAllocatedSlot(), owner, slotNumber, parent, groupID);
    }

    private SimpleSlot(AllocatedSlot allocatedSlot, SlotOwner owner, int slotNumber, @Nullable SharedSlot parent, @Nullable AbstractID groupID) {
        super(allocatedSlot, owner, slotNumber, parent, groupID);
    }

    @Override
    public int getNumberLeaves() {
        return 1;
    }

    public Execution getExecutedVertex() {
        return this.executedTask;
    }

    public boolean setExecutedVertex(Execution executedVertex) {
        if (executedVertex == null) {
            throw new NullPointerException();
        }
        if (this.isCanceled()) {
            return false;
        }
        if (!VERTEX_UPDATER.compareAndSet(this, null, executedVertex)) {
            return false;
        }
        if (this.isCanceled()) {
            this.executedTask = null;
            return false;
        }
        return true;
    }

    public Locality getLocality() {
        return this.locality;
    }

    public void setLocality(Locality locality) {
        this.locality = locality;
    }

    @Override
    public void releaseSlot() {
        if (!this.isCanceled()) {
            Execution exec = this.executedTask;
            if (exec != null && !exec.isFinished()) {
                exec.fail(new Exception("TaskManager was lost/killed: " + this.getTaskManagerLocation()));
            }
            if (this.getParent() == null) {
                if (this.markCancelled()) {
                    this.getOwner().returnAllocatedSlot(this);
                }
            } else {
                this.getParent().releaseChild(this);
            }
        }
    }

    @Override
    public String toString() {
        return "SimpleSlot " + super.toString();
    }
}

