/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.instance;

import java.io.Serializable;
import org.apache.flink.runtime.util.Hardware;

public final class HardwareDescription
implements Serializable {
    private static final long serialVersionUID = 3380016608300325361L;
    private final int numberOfCPUCores;
    private final long sizeOfPhysicalMemory;
    private final long sizeOfJvmHeap;
    private final long sizeOfManagedMemory;

    public HardwareDescription(int numberOfCPUCores, long sizeOfPhysicalMemory, long sizeOfJvmHeap, long sizeOfManagedMemory) {
        this.numberOfCPUCores = numberOfCPUCores;
        this.sizeOfPhysicalMemory = sizeOfPhysicalMemory;
        this.sizeOfJvmHeap = sizeOfJvmHeap;
        this.sizeOfManagedMemory = sizeOfManagedMemory;
    }

    public int getNumberOfCPUCores() {
        return this.numberOfCPUCores;
    }

    public long getSizeOfPhysicalMemory() {
        return this.sizeOfPhysicalMemory;
    }

    public long getSizeOfJvmHeap() {
        return this.sizeOfJvmHeap;
    }

    public long getSizeOfManagedMemory() {
        return this.sizeOfManagedMemory;
    }

    public String toString() {
        return String.format("cores=%d, physMem=%d, heap=%d, managed=%d", this.numberOfCPUCores, this.sizeOfPhysicalMemory, this.sizeOfJvmHeap, this.sizeOfManagedMemory);
    }

    public static HardwareDescription extractFromSystem(long managedMemory) {
        int numberOfCPUCores = Hardware.getNumberCPUCores();
        long sizeOfJvmHeap = Runtime.getRuntime().maxMemory();
        long sizeOfPhysicalMemory = Hardware.getSizeOfPhysicalMemory();
        return new HardwareDescription(numberOfCPUCores, sizeOfPhysicalMemory, sizeOfJvmHeap, managedMemory);
    }
}

