/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.savepoint;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.migration.runtime.checkpoint.savepoint.SavepointV0Serializer;
import org.apache.flink.runtime.checkpoint.savepoint.Savepoint;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointSerializer;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointV1Serializer;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointV2Serializer;
import org.apache.flink.util.Preconditions;

public class SavepointSerializers {
    private static final Map<Integer, SavepointSerializer<?>> SERIALIZERS = new HashMap(2);

    public static <T extends Savepoint> SavepointSerializer<T> getSerializer(T savepoint) {
        Preconditions.checkNotNull(savepoint, (String)"Savepoint");
        SavepointSerializer<?> serializer = SERIALIZERS.get(savepoint.getVersion());
        if (serializer != null) {
            return serializer;
        }
        throw new IllegalArgumentException("Unknown savepoint version " + savepoint.getVersion() + ".");
    }

    public static SavepointSerializer<?> getSerializer(int version) {
        SavepointSerializer<?> serializer = SERIALIZERS.get(version);
        if (serializer != null) {
            return serializer;
        }
        throw new IllegalArgumentException("Cannot restore savepoint version " + version + ".");
    }

    static {
        SERIALIZERS.put(0, SavepointV0Serializer.INSTANCE);
        SERIALIZERS.put(1, SavepointV1Serializer.INSTANCE);
        SERIALIZERS.put(2, SavepointV2Serializer.INSTANCE);
    }
}

